/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.Trackable;

public class Tracking<RAW extends Trackable, BASE extends Trackable> {
    private final IdentityHashMap<RAW, BASE> rawToBase = new IdentityHashMap();
    private final IdentityHashMap<BASE, RAW> baseToRaw = new IdentityHashMap();
    private final Collection<RAW> raws;
    private final Collection<BASE> bases;
    private final Predicate<RAW> unmatchedRawPredicate = new Predicate<RAW>(){

        public boolean apply(@Nonnull RAW raw) {
            return !Tracking.this.rawToBase.containsKey(raw);
        }
    };
    private final Predicate<BASE> unmatchedBasePredicate = new Predicate<BASE>(){

        public boolean apply(@Nonnull BASE raw) {
            return !Tracking.this.baseToRaw.containsKey(raw);
        }
    };
    private final Multimap<Integer, BASE> openManualIssuesByLine = ArrayListMultimap.create();

    public Tracking(Input<RAW> rawInput, Input<BASE> baseInput) {
        this.raws = rawInput.getIssues();
        this.bases = baseInput.getIssues();
    }

    public Iterable<RAW> getUnmatchedRaws() {
        return Iterables.filter(this.raws, this.unmatchedRawPredicate);
    }

    public Map<RAW, BASE> getMatchedRaws() {
        return this.rawToBase;
    }

    @CheckForNull
    public BASE baseFor(RAW raw) {
        return (BASE)((Trackable)this.rawToBase.get(raw));
    }

    public Iterable<BASE> getUnmatchedBases() {
        return Iterables.filter(this.bases, this.unmatchedBasePredicate);
    }

    boolean containsUnmatchedBase(BASE base) {
        return !this.baseToRaw.containsKey(base);
    }

    void match(RAW raw, BASE base) {
        this.rawToBase.put(raw, base);
        this.baseToRaw.put(base, raw);
    }

    boolean isComplete() {
        return this.rawToBase.size() == this.raws.size();
    }

    public Multimap<Integer, BASE> getOpenManualIssuesByLine() {
        return this.openManualIssuesByLine;
    }

    void keepManualIssueOpen(BASE manualIssue, @Nullable Integer line) {
        this.openManualIssuesByLine.put((Object)line, manualIssue);
        this.baseToRaw.put(manualIssue, null);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("rawToBase", this.rawToBase).add("baseToRaw", this.baseToRaw).add("raws", this.raws).add("bases", this.bases).add("openManualIssuesByLine", this.openManualIssuesByLine).toString();
    }
}

