/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.util;

public class InternalHashSet {
    private static final int INITIAL_SIZE = 64;
    private static final int TRIM_SIZE = 64;
    private int _mask = 63;
    private int _count;
    private Entry[] _entries = new Entry[64];

    public Entry lookup(int hashCode) {
        return this._entries[hashCode & this._mask];
    }

    public void put(Entry newEntry) {
        int index = newEntry.getHashCode() & this._mask;
        Entry entry = this._entries[index];
        newEntry._next = entry;
        this._entries[index] = newEntry;
        ++this._count;
        if (this._count > this._entries.length / 2) {
            this.grow();
        }
    }

    void grow() {
        Entry[] temp = new Entry[this._entries.length * 2];
        this._mask = temp.length - 1;
        for (int index = 0; index < this._entries.length; ++index) {
            Entry entry = this._entries[index];
            while (entry != null) {
                int newIndex = entry.getHashCode() & this._mask;
                Entry newEntry = entry;
                entry = entry._next;
                newEntry._next = temp[newIndex];
                temp[newIndex] = newEntry;
            }
        }
        this._entries = temp;
    }

    public Entry next(Entry entry) {
        if (entry != null && entry._next != null) {
            return entry._next;
        }
        int index = -1;
        if (entry != null) {
            index = (entry.getHashCode() & Integer.MAX_VALUE) % this._entries.length;
        }
        while (++index < this._entries.length) {
            if (this._entries[index] == null) continue;
            return this._entries[index];
        }
        return null;
    }

    public int size() {
        return this._count;
    }

    public void clear() {
        if (this._count == 0) {
            return;
        }
        if (this._entries.length > 64) {
            this._entries = new Entry[64];
        } else {
            for (int index = 0; index < this._entries.length; ++index) {
                this._entries[index] = null;
            }
        }
        this._count = 0;
        this._mask = this._entries.length - 1;
    }

    public static abstract class Entry {
        private Entry _next;
        private int _hashCode = -1;

        public Entry getNext() {
            return this._next;
        }

        private int getHashCode() {
            if (this._hashCode == -1) {
                this._hashCode = this.hashCode() & Integer.MAX_VALUE;
            }
            return this._hashCode;
        }

        public abstract int hashCode();
    }
}

