/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AdminCommand;
import com.persistit.ui.AdminPanel;
import com.persistit.ui.JavaHelpAdapter;
import com.persistit.ui.TaskSetupPanel;
import com.persistit.util.UtilControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;

public class AdminUI
implements UtilControl,
Runnable,
AdminCommand {
    static final String BUNDLE_NAME = "com.persistit.ui.AdminUI";
    static final String SPLASH_FILE_NAME = "persistit_splash.png";
    static final String DEFAULT_RMI_HOST = "localhost:1099";
    static final boolean ENABLE_SPLASH = false;
    static final String DEFAULT_CONFIG_FILE = "adminui.properties";
    static final String CONFIG_FILE_PROPERTY = "com.persistit.ui.properties";
    static final String HELP_SET_NAME = "help/PersistitHelp.hs";
    private DecimalFormat _percentageFormat;
    private SimpleDateFormat _dateFormat;
    private DecimalFormat _timeFormat;
    private DecimalFormat _longFormat;
    private DecimalFormat _integerFormat;
    private String _fileLocationFormat;
    private ResourceBundle _bundle;
    private Properties _properties;
    private JFrame _frame = null;
    private JTabbedPane _tabbedPane = null;
    private Management _management;
    private final Map _actionMap = new HashMap();
    private final List _textComponentList = new ArrayList();
    private String _rmiHost = "localhost:1099";
    private SplashWindow _splashWindow;
    private String[] _taskStates;
    int _selectedTab = -1;
    private Timer _refreshTimer = new Timer();
    private TimerTask _refreshTimerTask;
    private int _refreshInterval;
    private AbstractButton _refreshOnceButton;
    private boolean _refreshing;
    private FontUIResource _defaultFont;
    private FontUIResource _boldFont;
    private FontUIResource _fixedFont;
    private Color _persistitAccentColor;
    private String _waitingMessage;
    private String _nullMessage;
    private boolean _fixedFontMode = false;
    private boolean _wrapMode = false;
    private boolean _wrapWordMode = false;
    private String _myHostName = "unknown";
    private JavaHelpAdapter _javaHelpAdapter;

    @Override
    public boolean isAlive() {
        return this._frame != null;
    }

    @Override
    public void close() {
        Timer timer = this._refreshTimer;
        if (timer != null) {
            timer.cancel();
            this._refreshTimer = null;
        }
        final JFrame frame = this._frame;
        final JavaHelpAdapter adapter = this._javaHelpAdapter;
        this._frame = null;
        this._javaHelpAdapter = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (adapter != null) {
                    adapter.dispose();
                }
                if (frame != null) {
                    frame.dispose();
                }
            }
        });
    }

    @Override
    public void run() {
        this.resetRefreshTimer();
        this.refreshMenuEnableState();
        this.refresh(true);
    }

    public AdminUI(Management management) {
        this();
        this.setManagement(management);
    }

    public AdminUI(String rmiHost) {
        this();
        this._rmiHost = rmiHost;
        if (rmiHost != null) {
            this.connect(rmiHost);
        }
    }

    public AdminUI() {
        Thread daemonThread = new Thread(){

            @Override
            public void run() {
                AdminUI.this._frame = new JFrame();
                AdminUI.this.setupFrame();
            }
        };
        daemonThread.setDaemon(true);
        daemonThread.start();
        Thread hostNameThread = new Thread(){

            @Override
            public void run() {
                try {
                    InetAddress inetAddr = InetAddress.getLocalHost();
                    AdminUI.this._myHostName = inetAddr.getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        hostNameThread.setDaemon(true);
        hostNameThread.start();
        try {
            daemonThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean reset) {
        AdminUI adminUI = this;
        synchronized (adminUI) {
            if (this._refreshing) {
                return;
            }
            this._refreshing = true;
        }
        try {
            Management management = this._management;
            if (management != null) {
                try {
                    management.isInitialized();
                }
                catch (RemoteException re) {
                    this.disconnect();
                    management = null;
                }
            }
            if (this._tabbedPane != null) {
                try {
                    AdminPanel mp = (AdminPanel)this._tabbedPane.getSelectedComponent();
                    mp.refresh(reset || management == null);
                }
                catch (Exception e) {
                    this.postException(e);
                }
            }
            for (AdminAction action : this._actionMap.values()) {
                if (!action.isToggle()) continue;
                action.stateChanged(this.getManagementState(action));
            }
        }
        finally {
            this._refreshing = false;
        }
    }

    public Management getManagement() {
        return this._management;
    }

    @Override
    public void setManagement(Management newManagement) {
        Management oldManagement = this._management;
        if (oldManagement != null) {
            this.unfreeze(oldManagement);
        }
        this._management = newManagement;
        SwingUtilities.invokeLater(this);
    }

    private void unfreeze(Management management) {
        try {
            management.setShutdownSuspended(false);
            management.setUpdateSuspended(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String propertyName) {
        try {
            if (this._bundle == null) {
                this._bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                String propFileName = null;
                try {
                    propFileName = System.getProperty(CONFIG_FILE_PROPERTY);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (propFileName == null) {
                    propFileName = DEFAULT_CONFIG_FILE;
                }
                try {
                    FileInputStream fis = new FileInputStream(propFileName);
                    this._properties = new Properties();
                    this._properties.load(fis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String value = null;
            if (this._properties != null) {
                value = this._properties.getProperty(propertyName);
            }
            if (value == null) {
                value = this._bundle.getString(propertyName);
            }
            return value;
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public int getRefreshInterval() {
        return this._refreshInterval;
    }

    public String getHostName() {
        return this._myHostName;
    }

    public FontUIResource getBoldFont() {
        return this._boldFont;
    }

    public FontUIResource getDefaultFont() {
        return this._defaultFont;
    }

    public FontUIResource getFixedFont() {
        return this._fixedFont;
    }

    public Color getPersistitAccentColor() {
        return this._persistitAccentColor;
    }

    public String getWaitingMessage() {
        return this._waitingMessage;
    }

    public String getNullMessage() {
        return this._nullMessage;
    }

    public String getTaskStateString(int state) {
        if (state >= 0 && state < this._taskStates.length) {
            return this._taskStates[state];
        }
        return "?";
    }

    public String formatDate(long ts) {
        if (ts == 0L || ts == Long.MAX_VALUE || ts == Long.MIN_VALUE) {
            return "";
        }
        return this._dateFormat.format(new Date(ts));
    }

    public String formatTime(long ts) {
        return this._timeFormat.format((double)ts / 1000.0);
    }

    public String formatInteger(int v) {
        return this._integerFormat.format(v);
    }

    public String formatLong(long v) {
        return this._longFormat.format(v);
    }

    public String formatPercent(double v) {
        return this._percentageFormat.format(v);
    }

    public String formatFileLocation(String path, long address) {
        return path == null ? "" : String.format(this._fileLocationFormat, path, address);
    }

    private void setFrameTitle(String hostName) {
        String title = this.getProperty("title");
        if (title == null) {
            title = "Persistit Admin Client";
        }
        if (title.indexOf("Persistit") < 0) {
            title = "Persistit - " + title;
        }
        if (hostName != null && hostName.length() > 0) {
            title = title + " - " + hostName;
        }
        this._frame.setTitle(title);
    }

    private void setupFrame() {
        this._defaultFont = new FontUIResource("Dialog", 0, 12);
        this._boldFont = new FontUIResource("Dialog", 1, 12);
        this._fixedFont = new FontUIResource("Monospaced", 0, 12);
        this._persistitAccentColor = new Color(119, 17, 34);
        String lnfClassName = this.getProperty("lnf");
        boolean lafLoaded = false;
        if (lnfClassName != null && lnfClassName.length() > 0) {
            try {
                Class<?> lnfClass = Class.forName(lnfClassName);
                Method setPropertyMethod = null;
                Enumeration<String> props = this._bundle.getKeys();
                while (props.hasMoreElements()) {
                    String propName = props.nextElement();
                    if (!propName.startsWith("lnf.")) continue;
                    String propValue = this._bundle.getString(propName);
                    if (setPropertyMethod == null) {
                        setPropertyMethod = lnfClass.getMethod("setProperty", String.class, String.class);
                    }
                    setPropertyMethod.invoke(null, propName, propValue);
                }
                LookAndFeel lnf = (LookAndFeel)lnfClass.newInstance();
                UIManager.setLookAndFeel(lnf);
                lafLoaded = true;
            }
            catch (Exception ex) {
                System.err.println("Could not load LnF class " + lnfClassName);
                ex.printStackTrace();
            }
        }
        if (!lafLoaded) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        AdminUI.setUIFont(this._defaultFont);
        this._percentageFormat = new DecimalFormat(this.getProperty("PERCENTAGE_FORMAT"));
        this._dateFormat = new SimpleDateFormat(this.getProperty("DATE_FORMAT"));
        this._timeFormat = new DecimalFormat(this.getProperty("TIME_FORMAT"));
        this._longFormat = new DecimalFormat(this.getProperty("LONG_FORMAT"));
        this._integerFormat = new DecimalFormat(this.getProperty("INTEGER_FORMAT"));
        this._fileLocationFormat = this.getProperty("FILE_LOCATION_FORMAT");
        this._waitingMessage = this.getProperty("WaitingMessage");
        this._nullMessage = this.getProperty("NullMessage");
        this._taskStates = new String[7];
        for (int state = 0; state < 7; ++state) {
            this._taskStates[state] = this.getProperty("TaskState." + state);
        }
        this._tabbedPane = new JTabbedPane();
        this._frame.getContentPane().add(this._tabbedPane);
        this._frame.setDefaultCloseOperation(2);
        this._frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdminUI.this.setManagement(null);
                        AdminUI.this.close();
                    }
                });
            }
        });
        this.setupMenu();
        this.setupTabbedPanes();
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                AdminUI.this.handleTabChanged();
            }
        });
        this.handleTabChanged();
        this.refreshMenuEnableState();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setFrameTitle(null);
        this._frame.pack();
        this._frame.setLocation((screenSize.width - this._frame.getWidth()) / 2, (screenSize.height - this._frame.getHeight()) / 2);
        this._frame.setVisible(true);
    }

    void setupMenu() {
        JMenuBar bar = new JMenuBar();
        this._frame.setJMenuBar(bar);
        String menuBarItems = this.getProperty("MainMenu");
        StringTokenizer st1 = new StringTokenizer(menuBarItems, ",");
        while (st1.hasMoreTokens()) {
            String s = st1.nextToken();
            AdminAction menuAction = this.createAction(this, s);
            JMenu menu = new JMenu(menuAction);
            menuAction.addButton(menu);
            bar.add(menu);
            StringTokenizer st2 = new StringTokenizer(s, ":");
            String actionName = st2.nextToken();
            JComponent[] items = this.createMenuArray(this, "MainMenu", actionName);
            for (int index = 0; index < items.length; ++index) {
                menu.add(items[index]);
            }
        }
    }

    JComponent[] createMenuArray(AdminCommand command, String basePropertyName, String actionName) {
        String propName;
        String t;
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        int index = 0;
        while ((t = this.getProperty(propName = basePropertyName + "." + actionName + "." + index)) != null && !t.startsWith(".")) {
            if (t.startsWith("-")) {
                list.add(new JSeparator());
            } else {
                AdminAction action = this.createAction(command, t);
                AbstractButton item = action.menuItem(command, propName);
                action.addButton(item);
                list.add(item);
            }
            ++index;
        }
        return list.toArray(new JComponent[list.size()]);
    }

    private void setupTabbedPanes() {
        String paneSpecification;
        int index = 0;
        while ((paneSpecification = this.getProperty("TabbedPane." + index)) != null && !paneSpecification.startsWith(".")) {
            StringTokenizer st = new StringTokenizer(paneSpecification, ":");
            String className = st.nextToken();
            String caption = st.nextToken();
            String iconName = null;
            if (st.hasMoreTokens()) {
                iconName = st.nextToken();
            }
            try {
                Class<?> cl = Class.forName(className);
                AdminPanel panel = (AdminPanel)cl.newInstance();
                panel.setup(this);
                this._tabbedPane.addTab(caption, panel);
            }
            catch (Exception e) {
                this.showMessage(e, this.getProperty("SetupFailedMessage"), 0);
            }
            ++index;
        }
    }

    private void handleTabChanged() {
        AdminPanel newPanel;
        int oldTab = this._selectedTab;
        int newTab = this._tabbedPane.getSelectedIndex();
        if (oldTab == newTab) {
            return;
        }
        this._selectedTab = newTab;
        AdminPanel oldPanel = oldTab == -1 ? null : (AdminPanel)this._tabbedPane.getComponent(oldTab);
        AdminPanel adminPanel = newPanel = newTab == -1 ? null : (AdminPanel)this._tabbedPane.getComponent(newTab);
        if (oldPanel != null) {
            oldPanel.setIsShowing(false);
            this.changeMenuMap(oldPanel.getMenuMap(), false);
        }
        if (newPanel != null) {
            newPanel.setIsShowing(true);
            this.changeMenuMap(newPanel.getMenuMap(), true);
            this.scheduleRefresh(-1);
        }
        newPanel.setDefaultButton();
    }

    void changeMenuMap(Map menuMap, boolean add) {
        for (Map.Entry entry : menuMap.entrySet()) {
            String menuName = (String)entry.getKey();
            if (menuName.indexOf(".") >= 0) {
                menuName = menuName.substring(0, menuName.indexOf("."));
            }
            JComponent[] items = (JComponent[])entry.getValue();
            Action menuAction = (Action)this._actionMap.get(menuName);
            JMenuBar bar = this._frame.getJMenuBar();
            if (menuAction == null) continue;
            for (int index = 0; index < bar.getMenuCount(); ++index) {
                JMenu menu = bar.getMenu(index);
                if (menu.getAction() != menuAction) continue;
                for (int k = 0; k < items.length; ++k) {
                    JComponent item = items[k];
                    if (add) {
                        menu.add(item);
                        continue;
                    }
                    menu.remove(item);
                }
            }
        }
    }

    void refreshMenuEnableState() {
        for (AdminAction action : this._actionMap.values()) {
            if (!action.isDisableSensitive()) continue;
            action.setEnabled(this._management != null);
        }
    }

    private static void setUIFont(FontUIResource font) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, font);
        }
    }

    JComponent addLabeledField(JPanel panel, GridBagConstraints gbc, JComponent component, String propertyName, boolean newLine) {
        String prop = this.getProperty(propertyName);
        StringTokenizer st = new StringTokenizer(prop, ":");
        String caption = st.nextToken();
        String widthStr = st.nextToken();
        String alignment = st.nextToken();
        String gridwidth = st.nextToken();
        String tooltip = st.nextToken();
        String heightStr = "1";
        int p = widthStr.indexOf(44);
        if (p >= 0) {
            heightStr = widthStr.substring(p + 1);
            widthStr = widthStr.substring(0, p);
        }
        JLabel label = new JLabel(caption);
        label.setHorizontalAlignment(11);
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        panel.add((Component)label, gbc);
        ++gbc.gridx;
        try {
            gbc.gridwidth = "REMAINDER".equals(gridwidth) ? 0 : ("RELATIVE".equals(gridwidth) ? -1 : Integer.parseInt(gridwidth));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        component.setToolTipText(tooltip);
        JComponent wrappedComponent = component;
        if (component instanceof JTextField) {
            JTextField textField = (JTextField)component;
            textField.setColumns(Integer.parseInt(widthStr));
            textField.setHorizontalAlignment(alignment.equals("R") ? 11 : (alignment.equals("C") ? 0 : 10));
            textField.setEditable(false);
            textField.setEnabled(true);
            textField.setBackground(Color.white);
        } else if (component instanceof JTextArea) {
            JTextArea textArea = (JTextArea)component;
            textArea.setColumns(Integer.parseInt(widthStr));
            textArea.setRows(Integer.parseInt(heightStr));
            textArea.setEditable(false);
            textArea.setEnabled(true);
            textArea.setBackground(Color.white);
            wrappedComponent = new JScrollPane(textArea);
            wrappedComponent.setMinimumSize(textArea.getPreferredScrollableViewportSize());
            this.registerTextComponent(textArea);
        }
        gbc.weightx = 1.0;
        panel.add((Component)wrappedComponent, gbc);
        if (newLine || gbc.gridwidth == 0 || gbc.gridwidth == -1) {
            ++gbc.gridy;
            gbc.gridx = 0;
        } else {
            gbc.gridx += gbc.gridwidth;
        }
        component.setMinimumSize(component.getPreferredSize());
        return component;
    }

    AdminAction createAction(AdminCommand command, String specification) {
        boolean hasSubActions;
        boolean isRadio;
        boolean isToggle;
        boolean isDisableSensitive;
        StringTokenizer st = new StringTokenizer(specification, ":");
        String actionName = st.nextToken();
        String caption = null;
        String iconName = null;
        if (st.hasMoreTokens()) {
            caption = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            iconName = st.nextToken();
        }
        if (isDisableSensitive = actionName.startsWith("?")) {
            actionName = actionName.substring(1);
        }
        if (isToggle = actionName.startsWith("*")) {
            actionName = actionName.substring(1);
        }
        if (isRadio = actionName.startsWith("!")) {
            actionName = actionName.substring(1);
        }
        if (hasSubActions = actionName.startsWith("+")) {
            actionName = actionName.substring(1);
        }
        int mnemonicIndex = -1;
        char acceleratorChar = '\u0000';
        if (caption != null) {
            int acceleratorIndex;
            mnemonicIndex = caption.indexOf(38);
            if (mnemonicIndex >= 0) {
                caption = caption.substring(0, mnemonicIndex) + caption.substring(mnemonicIndex + 1);
            }
            if ((acceleratorIndex = caption.indexOf(94)) >= 0 && acceleratorIndex + 1 < caption.length()) {
                acceleratorChar = caption.charAt(acceleratorIndex + 1);
                caption = caption.substring(0, acceleratorIndex) + caption.substring(acceleratorIndex + 2);
            }
        }
        AdminAction action = null;
        action = caption == null ? new AdminAction(actionName) : (iconName == null || iconName.length() == 0 ? new AdminAction(command, actionName, caption) : new AdminAction(command, actionName, caption, new ImageIcon(iconName)));
        action._isToggle = isToggle;
        action._isRadio = isRadio;
        action._hasSubActions = hasSubActions;
        action._isDisableSensitive = isDisableSensitive;
        action._mnemonicIndex = mnemonicIndex;
        action._acceleratorChar = acceleratorChar;
        this._actionMap.put(actionName, action);
        return action;
    }

    public JTabbedPane getTabbedPane() {
        return this._tabbedPane;
    }

    public AdminAction getAction(String actionName) {
        return (AdminAction)this._actionMap.get(actionName);
    }

    public TitledBorder createTitledBorder(String captionProperty) {
        String caption = this.getProperty(captionProperty);
        if (caption == null || caption.length() == 0) {
            caption = " ";
        }
        return BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 2, 2, 2), caption, 4, 0, this._boldFont, this._persistitAccentColor);
    }

    private void connectDialog(String defaultHost) {
        final Object value = JOptionPane.showInputDialog(this._frame, "RMI Registry", "Connection Specification", 3, null, null, defaultHost);
        if (value instanceof String) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    AdminUI.this.connect((String)value);
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    private boolean connect(String rmiHost) {
        try {
            this._rmiHost = rmiHost;
            Management management = (Management)Naming.lookup("//" + rmiHost + "/PersistitManagementServer");
            this.setManagement(management);
            this.setFrameTitle(rmiHost);
            return true;
        }
        catch (Exception e) {
            this.setManagement(null);
            this.showMessage(e, this.getProperty("ConnectionFailedMessage"), 0);
            return false;
        }
    }

    private void disconnect() {
        this.setManagement(null);
    }

    void showMessage(final Object message, final String title, final int type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(AdminUI.this._frame, message, title, type);
            }
        });
    }

    public static void main(String[] args) {
        new AdminUI(args.length > 0 ? args[0] : null);
    }

    ButtonModel getMenuItemModel(String actionName) {
        AdminAction action = (AdminAction)this._actionMap.get(actionName);
        ArrayList buttons = action.getButtonList();
        if (buttons != null) {
            for (AbstractButton button : buttons) {
                if (!(button instanceof JMenuItem)) continue;
                return button.getModel();
            }
        }
        return null;
    }

    private void resetRefreshTimer() {
        if (this._refreshOnceButton != null) {
            this._refreshOnceButton.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(AdminAction action, ActionEvent ae) {
        try {
            String name = action._name;
            boolean textModeChanged = false;
            Management management = this._management;
            if (name.startsWith("REFRESH")) {
                int interval = 0;
                if (name.startsWith("REFRESH_")) {
                    interval = Integer.parseInt(name.substring("REFRESH_".length()));
                }
                this.scheduleRefresh(interval);
            } else if ("EXIT".equals(name)) {
                this.setManagement(null);
                this.close();
            } else if ("CONNECT".equals(name)) {
                this.connectDialog(this._rmiHost);
            } else if ("DISCONNECT".equals(name)) {
                this.disconnect();
            } else if ("ABOUT".equals(name)) {
                if (this._splashWindow == null) {
                    this._splashWindow = new SplashWindow(this._frame);
                    this._splashWindow.display();
                }
            } else if ("HELP".equals(name)) {
                this.showHelp(ae);
            } else if ("SSUSP".equals(name)) {
                boolean state = ((AbstractButton)ae.getSource()).isSelected();
                if (management != null && management.isInitialized()) {
                    int confirm;
                    if (state && (confirm = JOptionPane.showConfirmDialog(this._frame, this.getProperty("ssusp.confirm"))) != 0) {
                        state = false;
                    }
                    management.setShutdownSuspended(state);
                    this.scheduleRefresh(-1);
                } else {
                    ((AbstractButton)ae.getSource()).setSelected(false);
                }
            } else if ("USUSP".equals(name)) {
                boolean state = ((AbstractButton)ae.getSource()).isSelected();
                if (management != null && management.isInitialized()) {
                    int confirm;
                    if (state && (confirm = JOptionPane.showConfirmDialog(this._frame, this.getProperty("ususp.confirm"))) != 0) {
                        state = false;
                    }
                    management.setUpdateSuspended(state);
                    this.scheduleRefresh(-1);
                } else {
                    ((AbstractButton)ae.getSource()).setSelected(false);
                }
            } else if ("AONLY".equals(name)) {
                boolean state = ((AbstractButton)ae.getSource()).isSelected();
                if (management != null && management.isInitialized()) {
                    int confirm;
                    if (state && (confirm = JOptionPane.showConfirmDialog(this._frame, this.getProperty("aonly.confirm"))) != 0) {
                        state = false;
                    }
                    management.setAppendOnly(state);
                    this.scheduleRefresh(-1);
                } else {
                    ((AbstractButton)ae.getSource()).setSelected(false);
                }
            } else if ("JCOPY".equals(name)) {
                boolean state = ((AbstractButton)ae.getSource()).isSelected();
                if (management != null && management.isInitialized()) {
                    int confirm;
                    if (state && (confirm = JOptionPane.showConfirmDialog(this._frame, this.getProperty("jcopy.confirm"))) != 0) {
                        state = false;
                    }
                    management.setJournalCopyingFast(state);
                    this.scheduleRefresh(-1);
                } else {
                    ((AbstractButton)ae.getSource()).setSelected(false);
                }
            } else if ("FLUSH".equals(name)) {
                if (management != null && management.isInitialized()) {
                    management.flushAndForce();
                }
            } else if ("WRAP_MODE_NONE".equals(name)) {
                this._wrapMode = false;
                textModeChanged = true;
            } else if ("WRAP_MODE_CHARACTER".equals(name)) {
                this._wrapMode = true;
                this._wrapWordMode = false;
                textModeChanged = true;
            } else if ("WRAP_MODE_WORD".equals(name)) {
                this._wrapMode = true;
                this._wrapWordMode = true;
                textModeChanged = true;
            } else if ("FONT_MODE_NORMAL".equals(name)) {
                this._fixedFontMode = false;
                textModeChanged = true;
            } else if ("FONT_MODE_FIXED".equals(name)) {
                this._fixedFontMode = true;
                textModeChanged = true;
            } else if (name.startsWith("TASK.")) {
                String taskDescriptorPropName = "TaskDescriptor." + name.substring(5);
                String taskDescriptorString = this.getProperty(taskDescriptorPropName);
                TaskSetupPanel tsp = new TaskSetupPanel(this, taskDescriptorString);
                JOptionPane optionPane = new JOptionPane(tsp, 3, 2);
                JDialog dialog = optionPane.createDialog(this._frame, tsp.getTaskName());
                dialog.setResizable(true);
                tsp.refresh(false);
                dialog.pack();
                dialog.setVisible(true);
                Object value = optionPane.getValue();
                if (value != null && value instanceof Integer && (Integer)value == 0) {
                    this.doTask(tsp);
                }
            } else if ("START_NEW_TASK".equals(name)) {
                AdminAction taskAction;
                JPopupMenu popup = new JPopupMenu(this.getProperty("SelectNewTaskMessage"));
                int index = 0;
                while ((taskAction = this.getAction("TASK." + index)) != null) {
                    popup.add(new JMenuItem(taskAction));
                    ++index;
                }
                JComponent source = (JComponent)ae.getSource();
                popup.show(source, source.getWidth(), 0);
            } else {
                System.out.println("Undefined ACTION name " + name);
            }
            if (textModeChanged) {
                this.handleTextModeChanged();
            }
        }
        catch (NoSuchObjectException ex) {
            this.setManagement(null);
            this.scheduleRefresh(0);
        }
        catch (Exception ex) {
            this.postException(ex);
        }
    }

    public boolean getManagementState(AdminAction action) {
        String name = action.getName();
        try {
            if (this._management == null) {
                return false;
            }
            if ("SSUSP".equals(name)) {
                return this._management.isShutdownSuspended();
            }
            if ("USUSP".equals(name)) {
                return this._management.isUpdateSuspended();
            }
            if ("AONLY".equals(name)) {
                return this._management.getJournalInfo().isAppendOnly();
            }
            if ("USUSP".equals(name)) {
                return this._management.getJournalInfo().isFastCopying();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    void handleTextModeChanged() {
        for (JComponent component : this._textComponentList) {
            component.setFont(this._fixedFontMode ? this._fixedFont : this._defaultFont);
            if (!(component instanceof JTextArea)) continue;
            JTextArea tc = (JTextArea)component;
            tc.setLineWrap(this._wrapMode);
            if (!this._wrapMode) continue;
            tc.setWrapStyleWord(this._wrapWordMode);
        }
    }

    void registerTextComponent(JComponent component) {
        this._textComponentList.add(component);
    }

    public void postException(Throwable throwable) {
        try {
            Throwable cause = null;
            if (throwable instanceof RemoteException) {
                try {
                    Method method = throwable.getClass().getMethod("getCause", new Class[0]);
                    if (method != null) {
                        cause = (Throwable)method.invoke((Object)throwable, new Object[0]);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (cause != null) {
                throwable = cause;
            }
            if (throwable instanceof Management.WrappedRemoteException) {
                throwable = ((Management.WrappedRemoteException)throwable).getCause();
            }
            this.showMessage(throwable, this.getProperty("ExceptionMessage"), 0);
        }
        catch (Exception e) {
            System.out.println("Exception while reporting throwable:");
            e.printStackTrace();
        }
    }

    public synchronized void scheduleRefresh(int interval) {
        if (this._refreshTimer == null) {
            return;
        }
        if (this._refreshTimerTask != null) {
            this._refreshTimerTask.cancel();
        }
        this._refreshTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            AdminUI.this.refresh(false);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        };
        if (interval >= 0) {
            this._refreshInterval = interval;
        }
        if (this._refreshInterval > 0) {
            this._refreshTimer.schedule(this._refreshTimerTask, 0L, (long)(this._refreshInterval * 1000));
        } else {
            this._refreshTimer.schedule(this._refreshTimerTask, 0L);
        }
    }

    protected void doTask(TaskSetupPanel tsp) throws RemoteException {
        Management management = this.getManagement();
        if (management != null) {
            management.startTask(tsp.getDescriptionString(), tsp.getOwnerString(), tsp.getCommandLine(), tsp.getExpirationTime(), tsp.isVerboseEnabled() ? 1 : 0);
        }
        this.scheduleRefresh(1000);
    }

    private synchronized void showHelp(ActionEvent ae) {
    }

    private class SplashWindow
    extends JWindow {
        Image _image;

        private SplashWindow(JFrame frame) {
            super(frame);
        }

        private void display() {
            URL url = AdminUI.class.getResource(AdminUI.SPLASH_FILE_NAME);
            this._image = Toolkit.getDefaultToolkit().createImage(url);
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this._image, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int width = this._image.getWidth(this);
            int height = this._image.getHeight(this);
            this.setSize(width, height);
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenDim.width - width) / 2, (screenDim.height - height) / 2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    SplashWindow.this.setVisible(false);
                    SplashWindow.this.dispose();
                    AdminUI.this._splashWindow = null;
                }
            });
            this.setVisible(true);
        }

        @Override
        public void update(Graphics g) {
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this._image, 0, 0, this);
        }
    }

    class AdminAction
    extends AbstractAction {
        private String _name;
        private String _caption;
        private AdminCommand _command;
        private boolean _isToggle;
        private boolean _isRadio;
        private boolean _hasSubActions;
        boolean _isDisableSensitive;
        private ArrayList _buttonList;
        private int _mnemonicIndex;
        private int _acceleratorChar;

        AdminAction(String actionName) {
            this._name = "";
            this._caption = "";
            this._name = actionName;
        }

        AdminAction(AdminCommand command, String actionName, String caption) {
            super(caption);
            this._name = "";
            this._caption = "";
            this._name = actionName;
            this._caption = caption;
            this._command = command;
        }

        AdminAction(AdminCommand command, String actionName, String caption, Icon icon) {
            super(caption, icon);
            this._name = "";
            this._caption = "";
            this._name = actionName;
            this._caption = caption;
            this._command = command;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!AdminUI.this._refreshing) {
                this._command.actionPerformed(this, ae);
            }
        }

        public String getName() {
            return this._name;
        }

        public AdminCommand getActionCommand() {
            return this._command;
        }

        public String toString() {
            return this._caption;
        }

        public boolean isToggle() {
            return this._isToggle;
        }

        public boolean isRadio() {
            return this._isRadio;
        }

        public boolean hasSubActions() {
            return this._hasSubActions;
        }

        public boolean isDisableSensitive() {
            return this._isDisableSensitive;
        }

        public ArrayList getButtonList() {
            return this._buttonList;
        }

        public void addButton(AbstractButton button) {
            if (this._buttonList == null) {
                this._buttonList = new ArrayList();
            }
            this._buttonList.add(button);
            if (this._mnemonicIndex >= 0) {
                char mnemonicChar = this._caption.charAt(this._mnemonicIndex);
                button.setMnemonic((int)mnemonicChar);
            }
            if (this._acceleratorChar > 0 && button instanceof JMenuItem && !(button instanceof JMenu)) {
                KeyStroke accelerator = KeyStroke.getKeyStroke(this._acceleratorChar, 2);
                ((JMenuItem)button).setAccelerator(accelerator);
            }
        }

        public void removeButton(AbstractButton button) {
            if (this._buttonList != null) {
                this._buttonList.remove(button);
            }
            if (this._buttonList.size() == 0) {
                this._buttonList = null;
            }
        }

        public void stateChanged(boolean selected) {
            if (this._buttonList != null) {
                for (int i = 0; i < this._buttonList.size(); ++i) {
                    AbstractButton button = (AbstractButton)this._buttonList.get(i);
                    if (button.isSelected() == selected) continue;
                    button.setSelected(selected);
                }
            }
        }

        public AbstractButton menuItem(AdminCommand command, String propName) {
            JMenuItem item;
            if (this.isToggle()) {
                item = new JCheckBoxMenuItem(this);
                this.addButton(item);
            } else if (this.isRadio()) {
                item = new JRadioButtonMenuItem(this);
                this.addButton(item);
            } else if (this.hasSubActions()) {
                String subName;
                String u;
                item = new JMenu(this);
                ButtonGroup bg = null;
                int subIndex = 0;
                while ((u = AdminUI.this.getProperty(subName = propName + "." + subIndex)) != null) {
                    AdminAction action = AdminUI.this.createAction(command, u);
                    AbstractButton subItem = action.menuItem(command, subName);
                    item.add(subItem);
                    if (subItem instanceof JRadioButtonMenuItem) {
                        boolean first;
                        boolean bl = first = bg == null;
                        if (first) {
                            bg = new ButtonGroup();
                        }
                        bg.add(subItem);
                        if (first) {
                            subItem.setSelected(true);
                        }
                    }
                    ++subIndex;
                }
            } else {
                item = new JMenuItem(this);
            }
            if ("REFRESH_0".equals(this._name)) {
                AdminUI.this._refreshOnceButton = item;
            }
            return item;
        }
    }
}

