/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.AccumulatorState;
import com.persistit.AntiValue;
import com.persistit.Buffer;
import com.persistit.ClassInfo;
import com.persistit.DefaultObjectCoder;
import com.persistit.DefaultValueCoder;
import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.MVV;
import com.persistit.Persistit;
import com.persistit.TransactionIndex;
import com.persistit.TransactionStatus;
import com.persistit.Tree;
import com.persistit.TreeState;
import com.persistit.TreeStatistics;
import com.persistit.ValueState;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.CoderManager;
import com.persistit.encoding.HandleCache;
import com.persistit.encoding.SerialValueCoder;
import com.persistit.encoding.ValueCoder;
import com.persistit.encoding.ValueDisplayer;
import com.persistit.encoding.ValueRenderer;
import com.persistit.exception.ConversionException;
import com.persistit.exception.InvalidKeyException;
import com.persistit.exception.MalformedValueException;
import com.persistit.exception.PersistitException;
import com.persistit.util.Debug;
import com.persistit.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Value {
    public static final Value EMPTY_VALUE = new Value(null, 0, 0);
    public static final int INITIAL_SIZE = 256;
    public static final int DEFAULT_MAXIMUM_SIZE = 0x400000;
    public static final int MAXIMUM_SIZE = 0x4000000;
    private static final int SIZE_GRANULARITY = 256;
    private static final char TRUE_CHAR = 'T';
    private static final char FALSE_CHAR = 'F';
    private static final String UNDEFINED = "undefined";
    private static final int TYPE_NULL = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_BYTE = 3;
    private static final int TYPE_SHORT = 5;
    private static final int TYPE_CHAR = 7;
    private static final int TYPE_INT = 8;
    private static final int TYPE_LONG = 10;
    private static final int TYPE_FLOAT = 13;
    private static final int TYPE_DOUBLE = 14;
    private static final int CLASS_BOOLEAN = 18;
    private static final int CLASS_BYTE = 19;
    private static final int CLASS_SHORT = 21;
    private static final int CLASS_CHAR = 23;
    private static final int CLASS_INT = 24;
    private static final int CLASS_LONG = 26;
    private static final int CLASS_FLOAT = 29;
    private static final int CLASS_DOUBLE = 30;
    private static final int CLASS_OBJECT = 31;
    private static final int CLASS_STRING = 32;
    private static final int CLASS_DATE = 33;
    private static final int CLASS_BIG_INTEGER = 34;
    private static final int CLASS_BIG_DECIMAL = 35;
    static final int CLASS_ANTIVALUE = 49;
    private static final int CLASS_REREF = 50;
    static final int CLASS_ACCUMULATOR = 58;
    static final int CLASS_TREE_STATISTICS = 59;
    static final int CLASS_TREE = 60;
    private static final int CLASS_SERIALIZED = 61;
    private static final int CLASS_ARRAY = 62;
    private static final int CLASS_MULTI_ARRAY = 63;
    private static final int TYPE_MVV = 254;
    private static final int BASE1 = 0;
    private static final int BASE2 = 16;
    private static final int BASE3 = 32;
    private static final int BASE5 = 48;
    private static final int CLASS1 = 64;
    private static final int CLASS5 = 112;
    private static final int COUNT1 = 128;
    private static final int COUNT5 = 176;
    private static final int SIZE1 = 192;
    private static final int SIZE5 = 240;
    private static final int[] ENCODED_SIZE_BITS = new int[]{-1, 0, 16, 32, -1, 48};
    private static final Class<?>[] CLASSES = new Class[]{null, Void.TYPE, Boolean.TYPE, Byte.TYPE, null, Short.TYPE, null, Character.TYPE, Integer.TYPE, null, Long.TYPE, null, null, Float.TYPE, Double.TYPE, null, null, Void.class, Boolean.class, Byte.class, null, Short.class, null, Character.class, Integer.class, null, Long.class, null, null, Float.class, Double.class, Object.class, String.class, Date.class, BigInteger.class, BigDecimal.class, null, null, null, null, null, null, null, null, null, null, null, null, null, AntiValue.class, Object.class, null, null, null, null, null, null, null, null, null, Serializable.class, Serializable.class};
    private static final int[] FIXED_ENCODING_SIZES = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 4, 4, 8, 8, 16, 4, 8, -1, 0, 0, 1, 1, 1, 2, 2, 2, 4, 4, 8, 8, 16, 4, 8, -1, -1, 8, -1, -1};
    private static final int TOO_MANY_LEVELS_THRESHOLD = 100;
    private static final int SAB_INCREMENT = 1024;
    private final Map<Class<?>, Class<?>[]> _arrayTypeCache = new HashMap();
    private int _maximumSize = 0x400000;
    private int _size = 0;
    private int _end = 0;
    private int _next = 0;
    private int _depth = 0;
    private int[] _endArray;
    private int _level;
    private byte[] _bytes;
    private byte[] _longBytes;
    private int _longSize;
    private boolean _longMode;
    private long _pointer = -1L;
    private int _pointerPageType = -1;
    private ValueObjectInputStream _vis;
    private ValueObjectOutputStream _vos;
    private int _serializedItemCount;
    private WeakReference<ValueCache> _valueCacheWeakRef;
    private ValueCache _valueCache;
    private boolean _shared = true;
    private DefaultValueCoder _currentCoder;
    private Object _currentObject;
    private final Persistit _persistit;
    private SoftReference<StringBuilder> _stringAssemblyBufferSoftRef;

    public Value(Persistit persistit) {
        this(persistit, 256, 0x400000);
    }

    public Value(Persistit persistit, int initialSize) {
        this(persistit, initialSize, 0x400000);
    }

    public Value(Persistit persistit, int initialSize, int maximumSize) {
        this._persistit = persistit;
        this._bytes = new byte[initialSize];
        this._maximumSize = maximumSize;
    }

    public Value(Value source) {
        this(source._persistit, source._bytes.length, source._maximumSize);
        source.copyTo(this);
    }

    public Value clear() {
        this._size = 0;
        this.reset();
        return this;
    }

    void clear(boolean secure) {
        if (secure) {
            StringBuilder sb;
            Util.clearBytes(this._bytes, 0, this._bytes.length);
            if (this._longBytes != null) {
                Util.clearBytes(this._longBytes, 0, this._longBytes.length);
            }
            this._longSize = 0;
            if (this._stringAssemblyBufferSoftRef != null && (sb = this._stringAssemblyBufferSoftRef.get()) != null) {
                int length = sb.length();
                for (int index = 0; index < length; ++index) {
                    sb.setCharAt(index, '\u0000');
                }
            }
        }
        this.clear();
    }

    private StringBuilder getStringAssemblyBuffer(int size) {
        StringBuilder sb = null;
        if (this._stringAssemblyBufferSoftRef != null) {
            sb = this._stringAssemblyBufferSoftRef.get();
        }
        if (sb == null) {
            sb = new StringBuilder(size + 1024);
            this._stringAssemblyBufferSoftRef = new SoftReference<StringBuilder>(sb);
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    public void copyTo(Value target) {
        if (target == this) {
            return;
        }
        Debug.$assert0.t(!this.isLongRecordMode());
        Debug.$assert0.t(!target.isLongRecordMode());
        target.setMaximumSize(this._maximumSize);
        target.ensureFit(this._size);
        System.arraycopy(this._bytes, 0, target._bytes, 0, this._size);
        target._size = this._size;
        target._pointer = this._pointer;
        target._longMode = this._longMode;
        target.reset();
    }

    public int hashCode() {
        int hashCode = 0;
        for (int index = 0; index < this._size; ++index) {
            hashCode = hashCode * 17 ^ this._bytes[index] & 0xFF;
        }
        return hashCode & Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            Value value = (Value)obj;
            if (value._size != this._size) {
                return false;
            }
            for (int i = 0; i < this._size; ++i) {
                if (value._bytes[i] == this._bytes[i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof ValueState) {
            return ((ValueState)obj).equals(this);
        }
        return false;
    }

    public boolean trim() {
        return this.trim(0);
    }

    public boolean trim(int newSize) {
        if (this._bytes.length > this._size && this._bytes.length > newSize) {
            byte[] bytes = new byte[Math.max(this._size, newSize)];
            System.arraycopy(this._bytes, 0, bytes, 0, this._size);
            this._bytes = bytes;
            return true;
        }
        return false;
    }

    public boolean ensureFit(int length) {
        if (this._size + length <= this._bytes.length) {
            return false;
        }
        if (this._size + length > this._maximumSize) {
            throw new ConversionException("Requested size=" + (this._size + length) + " exceeds maximum size=" + this._maximumSize);
        }
        int newArraySize = ((this._size + length) * 2 + 256 - 1) / 256 * 256;
        if (newArraySize > this._maximumSize) {
            newArraySize = this._maximumSize;
        }
        byte[] bytes = new byte[newArraySize];
        System.arraycopy(this._bytes, 0, bytes, 0, this._size);
        this._bytes = bytes;
        return true;
    }

    public void copyFromEncodedBytes(byte[] dest, int from, int to, int length) {
        System.arraycopy(this._bytes, from, dest, to, length);
    }

    public int getEncodedSize() {
        return this._size;
    }

    public void putEncodedBytes(byte[] from, int offset, int length) {
        this.ensureFit(length);
        if (length > 0) {
            System.arraycopy(from, offset, this._bytes, 0, length);
        }
        this.setEncodedSize(length);
    }

    public byte[] getEncodedBytes() {
        return this._bytes;
    }

    public void setEncodedSize(int size) {
        if (size < 0 || size > this._bytes.length) {
            throw new IllegalArgumentException("Size " + size + " exceeds capacity");
        }
        this._size = size;
        this._depth = 0;
    }

    public int getMaximumSize() {
        return this._maximumSize;
    }

    @Deprecated
    public void setMaximumSize(int size) {
        if (size < this._size) {
            throw new IllegalArgumentException("Value is larger than new maximum size");
        }
        if (size > 0x4000000) {
            throw new IllegalArgumentException("Value is larger than absolute limit 67108864");
        }
        this.trim(size);
        this._maximumSize = size;
    }

    public int getCursor() {
        return this._next;
    }

    public void setCursor(int cursor) {
        if (cursor < 0 || cursor > this._size) {
            throw new IllegalArgumentException("Cursor out of bound (0," + this._size + ")");
        }
        this._next = cursor;
    }

    public void setStreamMode(boolean b) {
        this.reset();
        this._depth = b ? 1 : 0;
    }

    public boolean isStreamMode() {
        return this._depth > 0;
    }

    public boolean isDefined() {
        return this._size != 0;
    }

    public boolean isNull() {
        return this.getTypeHandle() == 1;
    }

    public boolean isNull(boolean skipNull) {
        if (this.isNull()) {
            if (skipNull && this._depth > 0) {
                ++this._next;
                ++this._serializedItemCount;
            }
            return true;
        }
        return false;
    }

    boolean isAntiValue() {
        if (this._size == 0) {
            return false;
        }
        return (this._bytes[0] & 0xFF) == 49;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this._size == 0) {
            return UNDEFINED;
        }
        if (this._longMode && (this._bytes[0] & 0xFF) == 255 && this._size >= 120) {
            return this.toStringLongMode();
        }
        int saveDepth = this._depth;
        int saveLevel = this._level;
        int saveNext = this._next;
        int saveEnd = this._end;
        StringBuilder sb = new StringBuilder();
        this.setStreamMode(true);
        try {
            boolean first = true;
            while (this._next < this._size) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                this.decodeDisplayable(true, sb, null);
            }
        }
        catch (ConversionException e) {
            int truncatedSize = Math.min(this._size - this._next, 256);
            sb.append("ConversionException " + e.getCause() + " index=" + this._next + " size=" + (this._size - this._next) + ": " + Util.hexDump(this._bytes, 0, truncatedSize));
        }
        catch (Exception e) {
            sb.append("Exception " + e + " while decoding value at index=" + this._next + ": " + e);
        }
        finally {
            this._end = saveEnd;
            this._next = saveNext;
            this._level = saveLevel;
            this._depth = saveDepth;
        }
        return sb.toString();
    }

    private String toStringLongMode() {
        StringBuilder sb = new StringBuilder();
        sb.append("LongRec size=");
        sb.append(Buffer.decodeLongRecordDescriptorSize(this._bytes, 0));
        sb.append(" page=");
        sb.append(Buffer.decodeLongRecordDescriptorPointer(this._bytes, 0));
        return sb.toString();
    }

    public void decodeDisplayable(boolean quoted, StringBuilder sb) {
        this.decodeDisplayable(quoted, sb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeDisplayable(final boolean quoted, final StringBuilder sb, final CoderContext context) {
        this.checkSize(1);
        int start = this._next;
        int level = this._level;
        int classHandle = this.nextType();
        int currentItemCount = this._serializedItemCount;
        boolean isVariableLength = this._next - start > 1;
        switch (classHandle) {
            case 1: {
                this._next = start;
                sb.append(this.getNull());
                break;
            }
            case 3: {
                this._next = start;
                this.appendParenthesizedFriendlyClassName(sb, Byte.TYPE);
                sb.append(this.getByte());
                break;
            }
            case 7: {
                this._next = start;
                this.appendParenthesizedFriendlyClassName(sb, Character.TYPE);
                if (quoted) {
                    Util.appendQuotedChar(sb, this.getChar());
                    break;
                }
                sb.append((int)this.getChar());
                break;
            }
            case 8: {
                this._next = start;
                sb.append(this.getInt());
                break;
            }
            case 10: {
                this._next = start;
                this.appendParenthesizedFriendlyClassName(sb, Long.TYPE);
                sb.append(this.getLong());
                break;
            }
            case 13: {
                this._next = start;
                this.appendParenthesizedFriendlyClassName(sb, Float.TYPE);
                sb.append(this.getFloat());
                break;
            }
            case 14: {
                this._next = start;
                sb.append(this.getDouble());
                break;
            }
            case 2: {
                this._next = start;
                sb.append(this.getBoolean());
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 32: {
                this._next = start;
                if (this._level != level) {
                    this._end = this.popEnd();
                }
                Object value = this.get(null, context);
                this.appendDisplayable(sb, value, quoted, false);
                break;
            }
            case 50: {
                this._next = start;
                Object value = this.get(null, context);
                this.appendDisplayable(sb, value, quoted, true);
                break;
            }
            case 62: {
                try {
                    ++this._depth;
                    ++this._serializedItemCount;
                    this.registerEncodedObject(sb.length());
                    int componentClassHandle = this.nextType();
                    switch (componentClassHandle) {
                        case 2: {
                            sb.append("boolean[]{");
                            int length = this._end - this._next;
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                sb.append(this.toBoolean(this._next) ? "true" : "false");
                                ++this._next;
                            }
                            break;
                        }
                        case 3: {
                            sb.append("byte[]{");
                            int length = this._end - this._next;
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                sb.append(Util.getByte(this._bytes, this._next));
                                ++this._next;
                            }
                            break;
                        }
                        case 5: {
                            sb.append("short[]{");
                            int length = this.arraySize(this._end, this._next, 2);
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                sb.append(Util.getShort(this._bytes, this._next));
                                this._next += 2;
                            }
                            break;
                        }
                        case 7: {
                            sb.append("char[]{");
                            int length = this.arraySize(this._end, this._next, 2);
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                int c = Util.getChar(this._bytes, this._next);
                                if (quoted) {
                                    Util.appendQuotedChar(sb, c);
                                } else {
                                    sb.append(c);
                                }
                                this._next += 2;
                            }
                            break;
                        }
                        case 8: {
                            sb.append("int[]{");
                            int length = this.arraySize(this._end, this._next, 4);
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                sb.append(Util.getInt(this._bytes, this._next));
                                this._next += 4;
                            }
                            break;
                        }
                        case 10: {
                            sb.append("long[]{");
                            int length = this.arraySize(this._end, this._next, 8);
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                sb.append(Util.getLong(this._bytes, this._next));
                                this._next += 8;
                            }
                            break;
                        }
                        case 13: {
                            sb.append("float[]{");
                            int length = this.arraySize(this._end, this._next, 4);
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                float f = Float.intBitsToFloat(Util.getInt(this._bytes, this._next));
                                sb.append(f);
                                this._next += 4;
                            }
                            break;
                        }
                        case 14: {
                            sb.append("double[]{");
                            int length = this.arraySize(this._end, this._next, 8);
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                double d = Double.longBitsToDouble(Util.getLong(this._bytes, this._next));
                                sb.append(d);
                                this._next += 8;
                            }
                            break;
                        }
                        default: {
                            Class<?> cl = this.classForHandle(componentClassHandle);
                            if (cl != null) {
                                this.appendFriendlyClassName(sb, cl);
                            }
                            sb.append("[]{");
                            int length = this.decodeElementCount();
                            for (int index = 0; index < length; ++index) {
                                if (index > 0) {
                                    sb.append(',');
                                }
                                this.decodeDisplayable(quoted, sb, context);
                            }
                        }
                    }
                    sb.append('}');
                }
                finally {
                    --this._depth;
                }
                if (!isVariableLength) break;
                this.closeVariableLengthItem();
                break;
            }
            case 63: {
                this._next = start;
                this.decodeDisplayableMultiArray(quoted, sb, context, null);
                break;
            }
            case 61: {
                this._next = start;
                int length = sb.length();
                ++this._depth;
                try {
                    Object object = this.get(null, context);
                    this.getValueCache().store(currentItemCount, new DisplayMarker(sb.length()));
                    this.appendDisplayable(sb, object, quoted, false);
                    break;
                }
                catch (Exception e) {
                    sb.setLength(length);
                    sb.append("(Serialized-Object)");
                    Util.bytesToHex(sb, this._bytes, start, this._end - start);
                    break;
                }
                finally {
                    --this._depth;
                    if (isVariableLength) {
                        this.closeVariableLengthItem();
                    }
                }
            }
            case 254: {
                int savedSize = this._size;
                sb.append('[');
                try {
                    MVV.visitAllVersions(new MVV.VersionVisitor(){
                        boolean first = true;

                        @Override
                        public void init() {
                        }

                        @Override
                        public void sawVersion(long version, int offset, int valueLength) {
                            if (!this.first) {
                                sb.append(',');
                            }
                            sb.append(TransactionStatus.versionString(version));
                            try {
                                long tc = Value.this._persistit.getTransactionIndex().commitStatus(version, Long.MAX_VALUE, 0);
                                sb.append("<" + TransactionStatus.tcString(tc) + ">");
                            }
                            catch (Exception e) {
                                sb.append("<" + e + ">");
                            }
                            sb.append(':');
                            if (valueLength == 0) {
                                sb.append(Value.UNDEFINED);
                            } else {
                                Value.this._next = offset;
                                Value.this._end = (Value.this._size = Value.this._next + valueLength);
                                Value.this.decodeDisplayable(quoted, sb, context);
                            }
                            this.first = false;
                        }
                    }, this.getEncodedBytes(), 0, this.getEncodedSize());
                }
                catch (Throwable t) {
                    sb.append("<<").append(t).append(">>");
                }
                finally {
                    this._end = this._size = savedSize;
                    this._next = this._size;
                }
                sb.append(']');
                break;
            }
            default: {
                if (classHandle >= 64) {
                    try {
                        Class<?> clazz = this.classForHandle(classHandle);
                        ValueCoder coder = null;
                        ++this._depth;
                        this.getValueCache().store(currentItemCount, new DisplayMarker(sb.length()));
                        ++this._serializedItemCount;
                        if (clazz != null) {
                            coder = this.getValueCoder(clazz);
                        }
                        if (coder instanceof ValueDisplayer) {
                            this.appendParenthesizedFriendlyClassName(sb, clazz);
                            ((ValueDisplayer)coder).display(this, sb, clazz, context);
                            break;
                        }
                        if (coder instanceof SerialValueCoder) {
                            int length = sb.length();
                            try {
                                this._next = start;
                                Object object = this.get(null, context);
                                this.getValueCache().store(currentItemCount, new DisplayMarker(sb.length()));
                                this.appendDisplayable(sb, object, quoted, false);
                            }
                            catch (Exception e) {
                                sb.setLength(length);
                                sb.append("(Serialized-Object)");
                                Util.bytesToHex(sb, this._bytes, start, this._end - start);
                            }
                            break;
                        }
                        this.appendParenthesizedFriendlyClassName(sb, clazz);
                        sb.append('{');
                        boolean first = true;
                        while (this.hasMoreItems()) {
                            if (!first) {
                                sb.append(',');
                            }
                            first = false;
                            this.decodeDisplayable(true, sb, null);
                        }
                        sb.append('}');
                        break;
                    }
                    catch (Throwable t) {
                        sb.append("<<" + t + ">>");
                        break;
                    }
                    finally {
                        --this._depth;
                        if (isVariableLength) {
                            this.closeVariableLengthItem();
                        }
                    }
                }
                try {
                    this._next = start;
                    Object value = this.get(null, context);
                    this.getValueCache().store(currentItemCount, new DisplayMarker(sb.length()));
                    this.appendDisplayable(sb, value, quoted, false);
                    break;
                }
                catch (Throwable t) {
                    sb.append("<<" + t + ">>");
                    break;
                }
                finally {
                    if (isVariableLength) {
                        this.closeVariableLengthItem();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeDisplayableMultiArray(boolean quoted, StringBuilder sb, CoderContext context, Class<?> prototype) {
        int start = this._next;
        int type = this.nextType(63, 50);
        if (type == 50) {
            this._next = start;
            Object array = this.get(null, null);
            if (array != null && !(array instanceof DisplayMarker) && !array.getClass().isArray()) throw new ConversionException("Referenced object is not an array");
            this.appendDisplayable(sb, array, quoted, true);
            return;
        }
        try {
            ++this._depth;
            int componentClassHandle = this.nextType();
            this.checkSize(1);
            int dimensions = this._bytes[this._next++] & 0xFF;
            if (prototype == null) {
                prototype = Array.newInstance(this.classForHandle(componentClassHandle), new int[dimensions]).getClass();
            }
            int length = this.decodeElementCount();
            ++this._serializedItemCount;
            this.registerEncodedObject(sb.length());
            sb.append('[');
            Class<?> componentType = prototype.getComponentType();
            if (componentType.getComponentType().isArray()) {
                for (int index = 0; index < length; ++index) {
                    if (index > 0) {
                        sb.append(',');
                    }
                    this.decodeDisplayableMultiArray(quoted, sb, context, componentType);
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    if (index > 0) {
                        sb.append(',');
                    }
                    this.decodeDisplayable(quoted, sb, context);
                }
            }
            sb.append(']');
        }
        finally {
            --this._depth;
        }
        this.closeVariableLengthItem();
    }

    private void appendParenthesizedFriendlyClassName(StringBuilder sb, Class<?> cl) {
        sb.append('(');
        this.appendFriendlyClassName(sb, cl);
        sb.append(')');
    }

    private void appendFriendlyClassName(StringBuilder sb, Class<?> cl) {
        if (cl == null) {
            sb.append(cl);
            return;
        }
        if (cl.isPrimitive()) {
            sb.append(cl.getName());
        } else if (cl.isArray()) {
            this.appendFriendlyClassName(sb, cl.getComponentType());
            sb.append("[]");
        } else if (cl == String.class) {
            sb.append("String");
        } else if (cl == Date.class) {
            sb.append("Date");
        } else if (Number.class.isAssignableFrom(cl) && cl.getName().startsWith("java.lang.") || cl.getName().startsWith("java.math.")) {
            sb.append(cl.getName().substring(10));
        } else {
            sb.append(cl.getName());
        }
    }

    private void appendDisplayable(StringBuilder sb, Object value, boolean quoted, boolean reference) {
        if (value == null) {
            sb.append(value);
        } else {
            Class<?> cl = value.getClass();
            String className = cl.getName();
            if (cl == String.class) {
                String s = (String)value;
                int length = s.length();
                if (length > 24 && reference) {
                    length = 21;
                }
                if (quoted) {
                    sb.append("\"");
                    for (int index = 0; index < s.length(); ++index) {
                        Util.appendQuotedChar(sb, s.charAt(index));
                    }
                    sb.append("\"");
                } else {
                    sb.append(s.substring(0, length));
                }
                if (length < s.length()) {
                    sb.append("...");
                }
            } else if (cl == Date.class) {
                this.appendParenthesizedFriendlyClassName(sb, cl);
                sb.append(Key.SDF.format((Date)value));
            } else if (value instanceof Number) {
                sb.append('(');
                sb.append(className.startsWith("java.lang.") ? className.substring(10) : className);
                sb.append(')');
                sb.append(value);
            } else if (value instanceof DisplayMarker) {
                sb.append(value);
            } else if (value instanceof AntiValue) {
                sb.append(cl.getSimpleName());
                sb.append(value);
            } else {
                this.appendParenthesizedFriendlyClassName(sb, cl);
                try {
                    String s = value.toString();
                    this.appendDisplayable(sb, s, false, reference);
                }
                catch (Throwable t) {
                    sb.append("<<" + t + ">>");
                }
            }
        }
    }

    int getTypeHandle() {
        int saveDepth = this._depth;
        int saveLevel = this._level;
        int saveNext = this._next;
        int saveEnd = this._end;
        int result = this.nextType();
        this._end = saveEnd;
        this._next = saveNext;
        this._level = saveLevel;
        this._depth = saveDepth;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getType() {
        int saveDepth = this._depth;
        int saveLevel = this._level;
        int saveNext = this._next;
        int saveEnd = this._end;
        try {
            int classHandle = this.nextType();
            if (classHandle == 50) {
                int base = this._bytes[this._next++] & 0xFF;
                int handle = this.decodeVariableLengthInt(base);
                Object object = this.getValueCache().get(handle);
                if (object == null) {
                    throw new IllegalStateException("Reference to handle " + handle + " has no value");
                }
                Class<?> clazz = object.getClass();
                return clazz;
            }
            if (classHandle > 0 && classHandle < CLASSES.length && CLASSES[classHandle] != null) {
                Class<?> base = CLASSES[classHandle];
                return base;
            }
            if (classHandle == 62) {
                ++this._depth;
                int componentClassHandle = this.nextType();
                Class<?> handle = this.arrayClass(this.classForHandle(componentClassHandle), 1);
                return handle;
            }
            if (classHandle == 63) {
                ++this._depth;
                int componentClassHandle = this.nextType();
                this.checkSize(1);
                int dimensions = this._bytes[this._next++] & 0xFF;
                Class<?> clazz = this.arrayClass(this.classForHandle(componentClassHandle), dimensions);
                return clazz;
            }
            Class<?> clazz = this.classForHandle(classHandle);
            return clazz;
        }
        finally {
            this._end = saveEnd;
            this._next = saveNext;
            this._level = saveLevel;
            this._depth = saveDepth;
        }
    }

    public boolean isType(Class<?> clazz) {
        int classHandle = this.getTypeHandle();
        if (classHandle == 254 || classHandle == 49) {
            return false;
        }
        if (classHandle > 0 && classHandle < CLASSES.length) {
            return CLASSES[classHandle] == clazz;
        }
        try {
            return this.getType() == clazz;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Class<?> arrayClass(Class<?> componentClass, int dimensions) {
        Class<?>[] arraysByDimension = this._arrayTypeCache.get(componentClass);
        Class<?> result = null;
        if (arraysByDimension != null && arraysByDimension.length > dimensions) {
            result = arraysByDimension[dimensions];
        }
        if (result != null) {
            return result;
        }
        result = dimensions == 1 ? Array.newInstance(componentClass, 0).getClass() : Array.newInstance(componentClass, new int[dimensions]).getClass();
        if (arraysByDimension != null) {
            if (arraysByDimension.length <= dimensions) {
                Class[] temp = new Class[dimensions + 2];
                System.arraycopy(arraysByDimension, 0, temp, 0, arraysByDimension.length);
                arraysByDimension = temp;
                this._arrayTypeCache.put(componentClass, arraysByDimension);
            }
        } else {
            arraysByDimension = new Class[dimensions + 2];
        }
        arraysByDimension[dimensions] = result;
        return result;
    }

    public Object getNull() {
        int start = this._next;
        int type = this.nextType();
        if (type == 1) {
            ++this._serializedItemCount;
            return null;
        }
        this._next = start;
        Object object = this.get(null, null);
        if (object == null) {
            return null;
        }
        throw new ConversionException("Expected null");
    }

    public boolean getBoolean() {
        int start = this._next;
        if (this.nextType() == 2) {
            ++this._serializedItemCount;
            return this.getBooleanInternal();
        }
        this._next = start;
        return (Boolean)this.getExpectedType(Boolean.class);
    }

    private boolean getBooleanInternal() {
        this.checkSize(1);
        boolean result = this.toBoolean(this._next);
        ++this._next;
        return result;
    }

    public byte getByte() {
        int start = this._next;
        if (this.nextType() == 3) {
            ++this._serializedItemCount;
            return this.getByteInternal();
        }
        this._next = start;
        return (Byte)this.getExpectedType(Byte.class);
    }

    private byte getByteInternal() {
        this.checkSize(1);
        byte result = this._bytes[this._next++];
        return result;
    }

    public short getShort() {
        int start = this._next;
        if (this.nextType() == 5) {
            ++this._serializedItemCount;
            return this.getShortInternal();
        }
        this._next = start;
        return (Short)this.getExpectedType(Short.class);
    }

    private short getShortInternal() {
        this.checkSize(2);
        short result = (short)Util.getShort(this._bytes, this._next);
        this._next += 2;
        return result;
    }

    public char getChar() {
        int start = this._next;
        if (this.nextType() == 7) {
            ++this._serializedItemCount;
            return this.getCharInternal();
        }
        this._next = start;
        return ((Character)this.getExpectedType(Character.class)).charValue();
    }

    private char getCharInternal() {
        this.checkSize(2);
        char result = (char)Util.getChar(this._bytes, this._next);
        this._next += 2;
        return result;
    }

    public int getInt() {
        int start = this._next;
        if (this.nextType() == 8) {
            ++this._serializedItemCount;
            return this.getIntInternal();
        }
        this._next = start;
        return (Integer)this.getExpectedType(Integer.class);
    }

    private int getIntInternal() {
        this.checkSize(4);
        int result = Util.getInt(this._bytes, this._next);
        this._next += 4;
        return result;
    }

    public long getLong() {
        int start = this._next;
        if (this.nextType() == 10) {
            ++this._serializedItemCount;
            return this.getLongInternal();
        }
        this._next = start;
        return (Long)this.getExpectedType(Long.class);
    }

    private long getLongInternal() {
        this.checkSize(8);
        long result = Util.getLong(this._bytes, this._next);
        this._next += 8;
        return result;
    }

    public float getFloat() {
        int start = this._next;
        if (this.nextType() == 13) {
            ++this._serializedItemCount;
            return this.getFloatInternal();
        }
        this._next = start;
        return ((Float)this.getExpectedType(Float.class)).floatValue();
    }

    private float getFloatInternal() {
        this.checkSize(4);
        float result = Float.intBitsToFloat(Util.getInt(this._bytes, this._next));
        this._next += 4;
        return result;
    }

    public double getDouble() {
        int start = this._next;
        if (this.nextType() == 14) {
            ++this._serializedItemCount;
            return this.getDoubleInternal();
        }
        this._next = start;
        return (Double)this.getExpectedType(Double.class);
    }

    private double getDoubleInternal() {
        this.checkSize(8);
        double result = Double.longBitsToDouble(Util.getLong(this._bytes, this._next));
        this._next += 8;
        return result;
    }

    public Object peek() {
        return this.peek(null, null);
    }

    public Object peek(Object target) {
        return this.peek(target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(Object target, CoderContext context) {
        Object object;
        int saveDepth = this._depth;
        int saveLevel = this._level;
        int saveNext = this._next;
        int saveEnd = this._end;
        try {
            object = this.get(target, context);
        }
        finally {
            this._end = saveEnd;
            this._next = saveNext;
            this._level = saveLevel;
            this._depth = saveDepth;
        }
        return object;
    }

    public Object get() {
        return this.get(null, null);
    }

    public Object get(Object target) {
        return this.get(target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object get(final Object target, final CoderContext context) {
        object /* !! */  = null;
        start = this._next--;
        classHandle = this.nextType();
        currentItemCount = this._serializedItemCount++;
        switch (classHandle) {
            case 1: {
                break;
            }
            case 2: 
            case 18: {
                object /* !! */  = this.getBooleanInternal() != false ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: 
            case 19: {
                object /* !! */  = this.getByteInternal();
                break;
            }
            case 5: 
            case 21: {
                object /* !! */  = this.getShortInternal();
                break;
            }
            case 7: 
            case 23: {
                object /* !! */  = Character.valueOf(this.getCharInternal());
                break;
            }
            case 8: 
            case 24: {
                object /* !! */  = this.getIntInternal();
                break;
            }
            case 13: 
            case 29: {
                object /* !! */  = Float.valueOf(this.getFloatInternal());
                break;
            }
            case 10: 
            case 26: {
                object /* !! */  = this.getLongInternal();
                break;
            }
            case 14: 
            case 30: {
                object /* !! */  = this.getDoubleInternal();
                break;
            }
            case 32: {
                if (target != null && target instanceof Appendable) {
                    this.utfToAppendable((Appendable)target, this._next, this._end);
                    object /* !! */  = target;
                } else {
                    sb = this.getStringAssemblyBuffer(this._end - this._next);
                    this.utfToAppendable(sb, this._next, this._end);
                    object /* !! */  = sb.toString();
                }
                this.closeVariableLengthItem();
                break;
            }
            case 33: {
                time = Util.getLong(this._bytes, this._next);
                this._next += 8;
                object /* !! */  = new Date(time);
                break;
            }
            case 34: {
                length = this._end - this._next;
                bytes = new byte[length];
                System.arraycopy(this._bytes, this._next, bytes, 0, length);
                this._next += length;
                object /* !! */  = new BigInteger(bytes);
                this.closeVariableLengthItem();
                break;
            }
            case 58: {
                accumulator = target != null && target instanceof AccumulatorState != false ? (AccumulatorState)target : new AccumulatorState();
                ++this._depth;
                try {
                    accumulator.load(this);
                }
                finally {
                    --this._depth;
                }
                object /* !! */  = accumulator;
                break;
            }
            case 59: {
                treeStatistics = target != null && target instanceof TreeStatistics != false ? (TreeStatistics)target : new TreeStatistics();
                this._next += treeStatistics.load(this._bytes, this._next, this._end - this._next);
                object /* !! */  = treeStatistics;
                break;
            }
            case 60: {
                if (target != null && target instanceof Tree) {
                    tree = (Tree)target;
                    this._next += tree.load(this._bytes, this._next, this._end - this._next);
                    object /* !! */  = tree;
                    break;
                }
                treeState = new TreeState();
                this._next += treeState.load(this._bytes, this._next, this._end - this._next);
                object /* !! */  = treeState;
                break;
            }
            case 35: {
                length = this._end - this._next;
                scale = Util.getInt(this._bytes, this._next);
                bytes = new byte[length - 4];
                System.arraycopy(this._bytes, this._next + 4, bytes, 0, length - 4);
                this._next += length;
                object /* !! */  = new BigDecimal(new BigInteger(bytes), scale);
                this.closeVariableLengthItem();
                break;
            }
            case 49: {
                length = this._end - this._next;
                elisionCount = 0;
                bytes = null;
                if (length > 0) {
                    elisionCount = Util.getShort(this._bytes, this._next);
                    bytes = new byte[length - 2];
                    System.arraycopy(this._bytes, this._next + 2, bytes, 0, length - 2);
                }
                this._next += length;
                object /* !! */  = new AntiValue(elisionCount, bytes);
                this.closeVariableLengthItem();
                break;
            }
            case 62: {
                try {
                    ++this._depth;
                    componentClassHandle = this.nextType();
                    switch (componentClassHandle) {
                        case 2: {
                            result = new boolean[this._end - this._next];
                            for (index = 0; index < result.length; ++index) {
                                result[index] = this.toBoolean(this._next + index);
                            }
                            object /* !! */  = (String[])result;
                            ** break;
lbl116:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            result = new byte[this._end - this._next];
                            System.arraycopy(this._bytes, this._next, result, 0, this._end - this._next);
                            object /* !! */  = (String[])result;
                            ** break;
lbl122:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            result = new short[this.arraySize(this._end, this._next, 2)];
                            for (index = 0; index < result.length; ++index) {
                                result[index] = (short)Util.getShort(this._bytes, this._next + index * 2);
                            }
                            object /* !! */  = (String[])result;
                            ** break;
lbl130:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            result = new char[this.arraySize(this._end, this._next, 2)];
                            for (index = 0; index < result.length; ++index) {
                                result[index] = (char)Util.getChar(this._bytes, this._next + index * 2);
                            }
                            object /* !! */  = (String[])result;
                            ** break;
lbl138:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            result = new int[this.arraySize(this._end, this._next, 4)];
                            for (index = 0; index < result.length; ++index) {
                                result[index] = Util.getInt(this._bytes, this._next + index * 4);
                            }
                            object /* !! */  = (String[])result;
                            ** break;
lbl146:
                            // 1 sources

                            break;
                        }
                        case 10: {
                            result = new long[this.arraySize(this._end, this._next, 8)];
                            for (index = 0; index < result.length; ++index) {
                                result[index] = Util.getLong(this._bytes, this._next + index * 8);
                            }
                            object /* !! */  = (String[])result;
                            ** break;
lbl154:
                            // 1 sources

                            break;
                        }
                        case 13: {
                            result = new float[this.arraySize(this._end, this._next, 4)];
                            for (index = 0; index < result.length; ++index) {
                                result[index] = Float.intBitsToFloat(Util.getInt(this._bytes, this._next + index * 4));
                            }
                            object /* !! */  = (String[])result;
                            ** break;
lbl162:
                            // 1 sources

                            break;
                        }
                        case 14: {
                            result = new double[this.arraySize(this._end, this._next, 8)];
                            for (index = 0; index < result.length; ++index) {
                                result[index] = Double.longBitsToDouble(Util.getLong(this._bytes, this._next + index * 8));
                            }
                            object /* !! */  = (String[])result;
                            ** break;
lbl170:
                            // 1 sources

                            break;
                        }
                        case 32: {
                            length = this.decodeElementCount();
                            result = new String[length];
                            for (index = 0; index < length; ++index) {
                                result[index] = this.getString();
                            }
                            object /* !! */  = result;
                            ** break;
lbl179:
                            // 1 sources

                            break;
                        }
                        default: {
                            componentClass = this.classForHandle(componentClassHandle);
                            length = this.decodeElementCount();
                            result = (Object[])Array.newInstance(componentClass, length);
                            this.getValueCache().store(currentItemCount, result);
                            for (index = 0; index < length; ++index) {
                                Array.set(result, index, this.get(null, null));
                            }
                            object /* !! */  = result;
                            ** break;
lbl190:
                            // 1 sources

                            break;
                        }
                    }
                }
                finally {
                    --this._depth;
                }
                this.closeVariableLengthItem();
                break;
            }
            case 63: {
                --this._serializedItemCount;
                object /* !! */  = this.getMultiArray(null);
                break;
            }
            case 61: {
                ++this._depth;
                try {
                    ois = new OldValueInputStream(this);
                    object /* !! */  = ois.readObject();
                    if (this._next != this._end) {
                        throw new ConversionException("Invalid serialized Object at index=" + this._next);
                    }
                    this.closeVariableLengthItem();
                    break;
                }
                catch (IOException ioe) {
                    throw new ConversionException("@" + start, ioe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ConversionException("@" + start, cnfe);
                }
                finally {
                    --this._depth;
                }
            }
            case 50: {
                base = this._bytes[this._next++] & 255;
                handle = this.decodeVariableLengthInt(base);
                object /* !! */  = this.getValueCache().get(handle);
                break;
            }
            case 254: {
                savedSize = this._size;
                outList = new ArrayList<E>();
                try {
                    ++this._depth;
                    MVV.visitAllVersions(new MVV.VersionVisitor(){

                        @Override
                        public void init() {
                        }

                        @Override
                        public void sawVersion(long version, int offset, int valueLength) {
                            Object obj = null;
                            if (valueLength > 0) {
                                Value.this._next = offset;
                                Value.this._end = (Value.this._size = Value.this._next + valueLength);
                                obj = Value.this.get(target, context);
                            }
                            outList.add(obj);
                        }
                    }, this.getEncodedBytes(), 0, this.getEncodedSize());
                }
                catch (PersistitException pe) {
                    throw new ConversionException("@" + start, pe);
                }
                finally {
                    --this._depth;
                    this._end = this._size = savedSize;
                    this._next = this._size;
                }
                return outList.toArray();
            }
            default: {
                saveDepth = this._depth++;
                try {
                    cl = this.classForHandle(classHandle);
                    coder = this.getValueCoder(cl);
                    if (coder == null) ** GOTO lbl250
                    if (target != null) ** GOTO lbl245
                    object /* !! */  = coder.get(this, cl, context);
                    ** GOTO lbl254
lbl245:
                    // 1 sources

                    if (!(coder instanceof ValueRenderer)) ** GOTO lbl249
                    ((ValueRenderer)coder).render(this, target, cl, context);
                    object /* !! */  = target;
                    ** GOTO lbl254
lbl249:
                    // 1 sources

                    throw new ConversionException("No ValueRenderer for class " + cl.getName());
lbl250:
                    // 1 sources

                    throw new ConversionException("No ValueCoder for class " + cl.getName());
                }
                finally {
                    this._depth = saveDepth;
                }
lbl254:
                // 2 sources

                this.closeVariableLengthItem();
                break;
            }
        }
        if (this._depth > 0) {
            this.getValueCache().store(currentItemCount, object /* !! */ );
        } else {
            this.releaseValueCache();
        }
        return object /* !! */ ;
    }

    private int arraySize(int end, int next, int blockSize) {
        int size = end - next;
        if (size % blockSize != 0) {
            throw new ConversionException("Invalid array size");
        }
        return size / blockSize;
    }

    private int utfToAppendable(Appendable sb, int offset, int end) {
        boolean counter = false;
        block5: for (int i = offset; i < end; ++i) {
            int b = this._bytes[i] & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Util.append(sb, (char)b);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if (++i >= this._end) {
                        throw new ConversionException();
                    }
                    byte b2 = this._bytes[i];
                    if ((b2 & 0xC0) != 128) {
                        throw new ConversionException();
                    }
                    Util.append(sb, (char)((b & 0x1F) << 6 | b2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((i += 2) >= this._end) {
                        throw new ConversionException();
                    }
                    byte b2 = this._bytes[i - 1];
                    byte b3 = this._bytes[i];
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        throw new ConversionException();
                    }
                    Util.append(sb, (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0));
                    continue block5;
                }
                default: {
                    throw new ConversionException();
                }
            }
        }
        return 0;
    }

    public void registerEncodedObject(Object object) {
        if (this._depth > 0) {
            this.getValueCache().store(this._serializedItemCount - 1, object);
        }
    }

    private void registerEncodedObject(int index) {
        if (this._depth > 0) {
            this.getValueCache().store(this._serializedItemCount - 1, new DisplayMarker(index));
        }
    }

    public String getString() {
        return (String)this.getExpectedType(String.class);
    }

    public <T extends Appendable> Appendable getString(T sb) {
        ++this._serializedItemCount;
        if (this.nextType(32) == 1) {
            return null;
        }
        this.utfToAppendable(sb, this._next, this._end);
        this.closeVariableLengthItem();
        return sb;
    }

    public Date getDate() {
        return (Date)this.getExpectedType(Date.class);
    }

    public BigInteger getBigInteger() {
        return (BigInteger)this.getExpectedType(BigInteger.class);
    }

    public BigDecimal getBigDecimal() {
        return (BigDecimal)this.getExpectedType(BigDecimal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getArrayLength() {
        int start = this._next++;
        int type = this.nextType(62, 63);
        if (type == 1) {
            return -1;
        }
        int componentClassHandle = -1;
        int result = -1;
        try {
            ++this._depth;
            componentClassHandle = this.nextType();
            if (type == 63) {
                // empty if block
            }
            int length = this._end - this._next;
            result = type == 62 && componentClassHandle > 0 && componentClassHandle <= 14 && FIXED_ENCODING_SIZES[componentClassHandle] > 0 ? length / FIXED_ENCODING_SIZES[componentClassHandle] : this.decodeElementCount();
        }
        finally {
            this.closeVariableLengthItem();
            --this._depth;
            this._next = start;
        }
        return result;
    }

    public Object getArray() {
        Object object = this.get(null, null);
        if (object == null || object.getClass().isArray()) {
            return object;
        }
        throw new ConversionException("Expected an array but value is a " + object.getClass().getName());
    }

    public boolean[] getBooleanArray() {
        return (boolean[])this.getExpectedType(boolean[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBooleanArray(boolean[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(2);
            int sourceLength = this._end - this._next;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            for (int index = 0; index < length; ++index) {
                array[toOffset + index] = this.toBoolean(index + fromOffset);
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public byte[] getByteArray() {
        return (byte[])this.getExpectedType(byte[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getByteArray(byte[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (array == this._bytes) {
            throw new IllegalArgumentException("Can't overwrite encoded bytes");
        }
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(3);
            int sourceLength = this._end - this._next;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            if (length > 0) {
                System.arraycopy(this._bytes, this._next + fromOffset, array, toOffset, length);
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public short[] getShortArray() {
        return (short[])this.getExpectedType(short[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShortArray(short[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(5);
            int sourceLength = (this._end - this._next) / 2;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            for (int index = 0; index < length; ++index) {
                array[toOffset + index] = (short)Util.getShort(this._bytes, this._next + (index + fromOffset) * 2);
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public char[] getCharArray() {
        return (char[])this.getExpectedType(char[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharArray(char[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(7);
            int sourceLength = (this._end - this._next) / 2;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            for (int index = 0; index < length; ++index) {
                array[toOffset + index] = (char)Util.getChar(this._bytes, this._next + (index + fromOffset) * 2);
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public int[] getIntArray() {
        return (int[])this.getExpectedType(int[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntArray(int[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(8);
            int sourceLength = (this._end - this._next) / 4;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            for (int index = 0; index < length; ++index) {
                array[toOffset + index] = Util.getInt(this._bytes, this._next + (index + fromOffset) * 4);
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public long[] getLongArray() {
        return (long[])this.getExpectedType(long[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLongArray(long[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(10);
            int sourceLength = (this._end - this._next) / 8;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            for (int index = 0; index < length; ++index) {
                array[toOffset + index] = Util.getLong(this._bytes, this._next + (index + fromOffset) * 8);
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public float[] getFloatArray() {
        return (float[])this.getExpectedType(float[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFloatArray(float[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(13);
            int sourceLength = (this._end - this._next) / 4;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            for (int index = 0; index < length; ++index) {
                array[toOffset + index] = Float.intBitsToFloat(Util.getInt(this._bytes, this._next + (index + fromOffset) * 4));
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public double[] getDoubleArray() {
        return (double[])this.getExpectedType(double[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDoubleArray(double[] array, int fromOffset, int toOffset, int length) {
        ++this._serializedItemCount;
        if (this.nextType(62) == 1) {
            return -1;
        }
        try {
            ++this._depth;
            this.nextType(14);
            int sourceLength = (this._end - this._next) / 8;
            if (length > sourceLength - fromOffset) {
                length = sourceLength - fromOffset;
            }
            if (length > array.length - toOffset) {
                length = array.length - toOffset;
            }
            for (int index = 0; index < length; ++index) {
                array[toOffset + index] = Double.longBitsToDouble(Util.getLong(this._bytes, this._next + (index + fromOffset) * 8));
            }
            this.closeVariableLengthItem();
            int n = length;
            return n;
        }
        finally {
            --this._depth;
        }
    }

    public Object[] getObjectArray() {
        return (Object[])this.getExpectedType(Object[].class);
    }

    public String[] getStringArray() {
        return (String[])this.getExpectedType(String[].class);
    }

    public boolean hasMoreItems() {
        return this._next < this._end;
    }

    public void put(boolean booleanValue) {
        this.preparePut();
        this.ensureFit(2);
        this._bytes[this._size++] = 2;
        this._bytes[this._size++] = (byte)(booleanValue ? 84 : 70);
        ++this._serializedItemCount;
    }

    public void put(byte byteValue) {
        this.preparePut();
        this.ensureFit(2);
        this._bytes[this._size++] = 3;
        this._bytes[this._size++] = byteValue;
        ++this._serializedItemCount;
    }

    public void put(short shortValue) {
        this.preparePut();
        this.ensureFit(3);
        this._bytes[this._size++] = 5;
        Util.putShort(this._bytes, this._size, shortValue);
        this._size += 2;
        ++this._serializedItemCount;
    }

    public void put(char charValue) {
        this.preparePut();
        this.ensureFit(3);
        this._bytes[this._size++] = 7;
        Util.putChar(this._bytes, this._size, charValue);
        this._size += 2;
        ++this._serializedItemCount;
    }

    public void put(int intValue) {
        this.preparePut();
        this.ensureFit(5);
        this._bytes[this._size++] = 8;
        Util.putInt(this._bytes, this._size, intValue);
        this._size += 4;
        ++this._serializedItemCount;
    }

    public void put(long longValue) {
        this.preparePut();
        this.ensureFit(9);
        this._bytes[this._size++] = 10;
        Util.putLong(this._bytes, this._size, longValue);
        this._size += 8;
        ++this._serializedItemCount;
    }

    public void put(float floatValue) {
        this.preparePut();
        this.ensureFit(5);
        this._bytes[this._size++] = 13;
        Util.putInt(this._bytes, this._size, Float.floatToIntBits(floatValue));
        this._size += 4;
        ++this._serializedItemCount;
    }

    public void put(double doubleValue) {
        this.preparePut();
        this.ensureFit(9);
        this._bytes[this._size++] = 14;
        Util.putLong(this._bytes, this._size, Double.doubleToLongBits(doubleValue));
        this._size += 8;
        ++this._serializedItemCount;
    }

    public void put(Object object) {
        this.put(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, CoderContext context) {
        int serializationHandle;
        this.preparePut();
        int currentItemCount = this._serializedItemCount++;
        if (object == null) {
            this.ensureFit(1);
            this._bytes[this._size++] = 1;
            return;
        }
        if (this._depth > 0 && this._shared && (serializationHandle = this.getValueCache().put(currentItemCount, object)) != -1) {
            this.ensureFit(5);
            this._bytes[this._size++] = 50;
            this._size += this.encodeVariableLengthInt(0, this._size, serializationHandle);
            return;
        }
        Class<?> cl = object.getClass();
        if (cl == String.class) {
            String string = (String)object;
            this.putUTF(string);
        } else if (cl == Date.class) {
            this.ensureFit(9);
            this._bytes[this._size++] = 33;
            Util.putLong(this._bytes, this._size, ((Date)object).getTime());
            this._size += 8;
        } else if (cl == BigInteger.class) {
            byte[] bytes = ((BigInteger)object).toByteArray();
            int length = bytes.length;
            this.ensureFit(length + 2);
            int index = this._size;
            this._bytes[index++] = 34;
            System.arraycopy(bytes, 0, this._bytes, index, length);
            this._size = index + length;
            this.endVariableSizeItem(length + 1);
        } else if (cl == BigDecimal.class) {
            BigDecimal bigDecimalValue = (BigDecimal)object;
            BigInteger unscaled = bigDecimalValue.unscaledValue();
            byte[] bytes = unscaled.toByteArray();
            int length = bytes.length;
            this.ensureFit(length + 8);
            int index = this._size;
            this._bytes[index++] = 35;
            Util.putInt(this._bytes, index, bigDecimalValue.scale());
            System.arraycopy(bytes, 0, this._bytes, index += 4, length);
            this._size = index + length;
            this.endVariableSizeItem(length + 5);
        } else if (cl == Boolean.class) {
            this.ensureFit(2);
            this._bytes[this._size++] = 18;
            this._bytes[this._size++] = (byte)((Boolean)object != false ? 84 : 70);
        } else if (cl == Byte.class) {
            this.ensureFit(2);
            this._bytes[this._size++] = 19;
            this._bytes[this._size++] = (Byte)object;
        } else if (cl == Short.class) {
            this.ensureFit(3);
            this._bytes[this._size++] = 21;
            Util.putShort(this._bytes, this._size, ((Short)object).shortValue());
            this._size += 2;
        } else if (cl == Character.class) {
            this.ensureFit(3);
            this._bytes[this._size++] = 23;
            Util.putChar(this._bytes, this._size, ((Character)object).charValue());
            this._size += 2;
        } else if (cl == Integer.class) {
            this.ensureFit(5);
            this._bytes[this._size++] = 24;
            Util.putInt(this._bytes, this._size, (Integer)object);
            this._size += 4;
        } else if (cl == Long.class) {
            this.ensureFit(9);
            this._bytes[this._size++] = 26;
            Util.putLong(this._bytes, this._size, (Long)object);
            this._size += 8;
        } else if (cl == Float.class) {
            this.ensureFit(5);
            this._bytes[this._size++] = 29;
            Util.putInt(this._bytes, this._size, Float.floatToRawIntBits(((Float)object).floatValue()));
            this._size += 4;
        } else if (cl == Double.class) {
            this.ensureFit(9);
            this._bytes[this._size++] = 30;
            Util.putLong(this._bytes, this._size, Double.doubleToRawLongBits((Double)object));
            this._size += 8;
        } else {
            if (object instanceof Accumulator) {
                this.ensureFit(536);
                this._bytes[this._size++] = 58;
                ++this._depth;
                try {
                    ((Accumulator)object).store(this);
                }
                finally {
                    --this._depth;
                }
            }
            if (cl == TreeStatistics.class) {
                this.ensureFit(54);
                this._bytes[this._size++] = 59;
                this._size += ((TreeStatistics)object).store(this._bytes, this._size);
            } else if (cl == Tree.class) {
                this.ensureFit(512);
                this._bytes[this._size++] = 60;
                this._size += ((Tree)object).store(this._bytes, this._size);
            } else if (cl.isArray()) {
                Class<?> componentClass = cl.getComponentType();
                int length = Array.getLength(object);
                if (componentClass.isPrimitive()) {
                    if (componentClass == Boolean.TYPE) {
                        this.putBooleanArray1((boolean[])object, 0, length);
                    } else if (componentClass == Byte.TYPE) {
                        this.putByteArray1((byte[])object, 0, length);
                    } else if (componentClass == Short.TYPE) {
                        this.putShortArray1((short[])object, 0, length);
                    } else if (componentClass == Character.TYPE) {
                        this.putCharArray1((char[])object, 0, length);
                    } else if (componentClass == Integer.TYPE) {
                        this.putIntArray1((int[])object, 0, length);
                    } else if (componentClass == Long.TYPE) {
                        this.putLongArray1((long[])object, 0, length);
                    } else if (componentClass == Float.TYPE) {
                        this.putFloatArray1((float[])object, 0, length);
                    } else if (componentClass == Double.TYPE) {
                        this.putDoubleArray1((double[])object, 0, length);
                    }
                } else {
                    this.putObjectArray1((Object[])object, 0, length);
                }
            } else {
                int start;
                this.ensureFit(6);
                int end = start = this._size;
                boolean replaced = false;
                try {
                    Object replacement;
                    if (this._shared && this._depth == 0) {
                        this.getValueCache().put(currentItemCount, object);
                    }
                    ++this._depth;
                    ValueCoder coder = this.getValueCoder(cl);
                    while (coder instanceof DefaultObjectCoder && (replacement = ((DefaultObjectCoder)coder).writeReplace(this, object)) != object) {
                        replaced = true;
                        if (replacement == null) break;
                        object = replacement;
                        cl = replacement.getClass();
                        coder = this.getValueCoder(cl);
                    }
                    if (replaced) {
                        this.put(object, context);
                        end = this._size;
                    } else {
                        int handle = cl == Object.class ? 31 : this.handleForClass(cl);
                        if (coder != null) {
                            this._size += this.encodeVariableLengthInt(64, this._size, handle - 64);
                            coder.put(this, object, context);
                            end = this._size;
                        } else {
                            this._bytes[this._size++] = 61;
                            OldValueOutputStream oos = new OldValueOutputStream(this);
                            oos.writeObject(object);
                            oos.close();
                            end = this._size;
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new ConversionException(ioe);
                }
                finally {
                    --this._depth;
                    this._size = end;
                }
                if (!replaced) {
                    this.endVariableSizeItem(this._size - start);
                }
            }
        }
        if (this._depth == 0) {
            this.releaseValueCache();
        }
    }

    public void putNull() {
        this.put(null, null);
    }

    public void putString(String string) {
        this.put(string, null);
    }

    public void putUTF(String string) {
        this.preparePut();
        this.putCharSequenceInternal(string);
    }

    public void putString(CharSequence sb) {
        if (sb == null) {
            this.putNull();
        } else {
            ++this._serializedItemCount;
            this.preparePut();
            this.putCharSequenceInternal(sb);
        }
    }

    public void putDate(Date dateValue) {
        this.put(dateValue, null);
    }

    public void putBigInteger(BigInteger bigIntValue) {
        this.put(bigIntValue, null);
    }

    public void putBigDecimal(BigDecimal bigDecimalValue) {
        this.put(bigDecimalValue, null);
    }

    public void putBooleanArray(boolean[] array) {
        this.put(array, null);
    }

    public void putBooleanArray(boolean[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putBooleanArray1(array, offset, length);
    }

    private void putBooleanArray1(boolean[] array, int offset, int length) {
        this.ensureFit(length + 2);
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 2;
        for (int index = 0; index < length; ++index) {
            Util.putByte(this._bytes, this._size, array[index + offset] ? 84 : 70);
            ++this._size;
        }
        this.endVariableSizeItem(length + 2);
    }

    public void putByteArray(byte[] array) {
        this.put(array, null);
    }

    public void putByteArray(byte[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putByteArray1(array, offset, length);
    }

    private void putByteArray1(byte[] array, int offset, int length) {
        this.ensureFit(length + 2);
        int index = this._size;
        this._bytes[index++] = 62;
        this._bytes[index++] = 3;
        System.arraycopy(array, offset, this._bytes, index, length);
        this._size = index + length;
        this.endVariableSizeItem(length + 2);
    }

    public void putShortArray(short[] array) {
        this.put(array, null);
    }

    public void putShortArray(short[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putShortArray1(array, offset, length);
    }

    void putShortArray1(short[] array, int offset, int length) {
        this.ensureFit(length * 2 + 2);
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 5;
        for (int index = 0; index < length; ++index) {
            Util.putShort(this._bytes, this._size, array[index + offset]);
            this._size += 2;
        }
        this.endVariableSizeItem(length * 2 + 2);
    }

    public void putCharArray(char[] array) {
        this.put(array, null);
    }

    public void putCharArray(char[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putCharArray1(array, offset, length);
    }

    private void putCharArray1(char[] array, int offset, int length) {
        this.ensureFit(length * 2 + 2);
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 7;
        for (int index = 0; index < length; ++index) {
            Util.putChar(this._bytes, this._size, array[index + offset]);
            this._size += 2;
        }
        this.endVariableSizeItem(length * 2 + 2);
    }

    public void putIntArray(int[] array) {
        this.put(array, null);
    }

    public void putIntArray(int[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putIntArray1(array, offset, length);
    }

    private void putIntArray1(int[] array, int offset, int length) {
        this.ensureFit(length * 4 + 2);
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 8;
        for (int index = 0; index < length; ++index) {
            Util.putInt(this._bytes, this._size, array[index + offset]);
            this._size += 4;
        }
        this.endVariableSizeItem(length * 4 + 2);
    }

    public void putLongArray(long[] array) {
        this.put(array, null);
    }

    public void putLongArray(long[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putLongArray1(array, offset, length);
    }

    private void putLongArray1(long[] array, int offset, int length) {
        this.ensureFit(length * 8 + 2);
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 10;
        for (int index = 0; index < length; ++index) {
            Util.putLong(this._bytes, this._size, array[index + offset]);
            this._size += 8;
        }
        this.endVariableSizeItem(length * 8 + 2);
    }

    public void putFloatArray(float[] array) {
        this.put(array, null);
    }

    public void putFloatArray(float[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putFloatArray1(array, offset, length);
    }

    private void putFloatArray1(float[] array, int offset, int length) {
        this.ensureFit(length * 4 + 2);
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 13;
        for (int index = 0; index < length; ++index) {
            Util.putInt(this._bytes, this._size, Float.floatToRawIntBits(array[index + offset]));
            this._size += 4;
        }
        this.endVariableSizeItem(length * 4 + 2);
    }

    public void putDoubleArray(double[] array) {
        this.put(array, null);
    }

    public void putDoubleArray(double[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.putDoubleArray1(array, offset, length);
    }

    private void putDoubleArray1(double[] array, int offset, int length) {
        this.ensureFit(length * 8 + 2);
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 14;
        for (int index = 0; index < length; ++index) {
            Util.putLong(this._bytes, this._size, Double.doubleToRawLongBits(array[index + offset]));
            this._size += 8;
        }
        this.endVariableSizeItem(length * 8 + 2);
    }

    public void putStringArray(String[] array) {
        this.put(array, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStringArray(String[] array, int offset, int length) {
        this.checkArrayLength(length, offset, array.length);
        this.preparePut();
        this.ensureFit(7 + length);
        int start = this._size;
        this._bytes[this._size++] = 62;
        this._bytes[this._size++] = 32;
        this._size += this.encodeVariableLengthInt(128, this._size, length);
        for (int index = 0; index < length; ++index) {
            try {
                ++this._depth;
                this.putString(array[index + offset]);
                continue;
            }
            finally {
                --this._depth;
            }
        }
        this.endVariableSizeItem(this._size - start);
    }

    public void putObjectArray(Object[] array) {
        this.put(array, null);
    }

    public void putObjectArray(Object[] array, int offset, int length) {
        this.preparePut();
        this.putObjectArray1(array, offset, length);
    }

    public void skip() {
        if (this._depth == 0) {
            return;
        }
        int currentHandle = this._serializedItemCount++;
        int saveNext = this._next;
        int saveEnd = this._end;
        int classHandle = this.nextType();
        if (classHandle == 0) {
            return;
        }
        int size = -1;
        if (classHandle < FIXED_ENCODING_SIZES.length) {
            size = FIXED_ENCODING_SIZES[classHandle];
        } else if (classHandle == 50) {
            int base = this._bytes[this._next++] & 0xFF;
            this.decodeVariableLengthInt(base);
            size = 0;
        }
        if (size >= 0) {
            this._next += size;
        } else {
            this.getValueCache().put(currentHandle, new SkippedFieldMarker(this, saveNext, saveEnd));
            this.closeVariableLengthItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putObjectArray1(Object[] array, int offset, int length) {
        int dimensions = 1;
        Class<?> componentType = array.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
            ++dimensions;
        }
        this.checkArrayLength(length, offset, array.length);
        int start = this._size;
        this.ensureFit(12);
        this._bytes[this._size++] = (byte)(dimensions == 1 ? 62 : 63);
        this.encodeClass(componentType);
        if (dimensions != 1) {
            this._bytes[this._size++] = (byte)dimensions;
        }
        this._size += this.encodeVariableLengthInt(128, this._size, length);
        for (int index = 0; index < length; ++index) {
            try {
                ++this._depth;
                this.put(array[index + offset]);
                continue;
            }
            finally {
                --this._depth;
            }
        }
        this.endVariableSizeItem(this._size - start);
    }

    void putAntiValue(short elisionCount, byte[] bytes) {
        this.preparePut();
        int start = this._size;
        this.ensureFit(8 + bytes.length);
        this._bytes[this._size++] = 49;
        Util.putShort(this._bytes, this._size, elisionCount);
        this._size += Util.putBytes(this._bytes, this._size + 2, bytes) + 2;
        this.endVariableSizeItem(this._size - start);
    }

    void putAntiValueMVV() {
        this.preparePut();
        this.ensureFit(1);
        this._bytes[this._size++] = 49;
        ++this._serializedItemCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directPut(ValueCoder coder, Object object, CoderContext context) {
        if (object == null) {
            this.putNull();
            return;
        }
        this.preparePut();
        ++this._depth;
        int end = this._size;
        try {
            this.ensureFit(6);
            int handle = this.directHandle(coder, object.getClass());
            assert (handle >= 64 && handle < 112);
            this._size += this.encodeVariableLengthInt(64, this._size, handle - 64);
            coder.put(this, object, context);
            end = this._size;
        }
        finally {
            --this._depth;
            this._size = end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object directGet(ValueRenderer coder, Class<?> clazz, CoderContext context) {
        int type = this.nextType();
        if (type == 1) {
            return null;
        }
        int expectedType = this.directHandle(coder, clazz);
        assert (expectedType >= 64 && expectedType < 112);
        this.expectType(expectedType, type);
        ++this._depth;
        ++this._serializedItemCount;
        try {
            Object object = coder.get(this, clazz, context);
            return object;
        }
        finally {
            --this._depth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object directGet(ValueRenderer coder, Object target, Class<?> clazz, CoderContext context) {
        int type = this.nextType();
        if (type == 1) {
            return null;
        }
        int expectedType = this.directHandle(coder, clazz);
        assert (expectedType >= 64 && expectedType < 112);
        this.expectType(expectedType, type);
        ++this._depth;
        ++this._serializedItemCount;
        try {
            coder.render(this, target, clazz, context);
            Object object = target;
            return object;
        }
        finally {
            --this._depth;
        }
    }

    long getPointerValue() {
        return this._pointer;
    }

    void setPointerValue(long pointer) {
        this._pointer = pointer;
    }

    int getPointerPageType() {
        return this._pointerPageType;
    }

    void setPointerPageType(int pageType) {
        this._pointerPageType = pageType;
    }

    byte[] getLongBytes() {
        return this._longBytes;
    }

    int getLongSize() {
        return this._longSize;
    }

    void setLongSize(int size) {
        this._longSize = size;
    }

    boolean isLongRecordMode() {
        return this._longMode;
    }

    void setLongRecordMode(boolean mode) {
        this._longMode = mode;
    }

    private ValueCoder getValueCoder(Class<?> clazz) {
        CoderManager cm = this._persistit.getCoderManager();
        if (cm != null) {
            return cm.getValueCoder(clazz);
        }
        return null;
    }

    void changeLongRecordMode(boolean mode) {
        if (mode != this._longMode) {
            if (this._longBytes == null || this._longBytes.length < 120) {
                this._longBytes = new byte[120];
                this._longSize = 120;
            }
            byte[] tempBytes = this._bytes;
            int tempSize = this._size;
            this._bytes = this._longBytes;
            this._size = this._longSize;
            this._longBytes = tempBytes;
            this._longSize = tempSize;
            this._longMode = mode;
            this.assertLongRecordModeIsCorrect();
        }
    }

    private void assertLongRecordModeIsCorrect() {
        if (this._longMode) {
            Debug.$assert1.t(this._bytes.length == 120);
        } else {
            Debug.$assert1.t(this._longBytes == null || this._longBytes.length == 120);
        }
    }

    private void reset() {
        this._next = 0;
        this._end = this._size;
        this._depth = 0;
        this._level = 0;
        this._serializedItemCount = 0;
        if (this._endArray != null && this._endArray.length > 100) {
            this._endArray = null;
        }
        this.releaseValueCache();
    }

    private void preparePut() {
        if (this._depth == 0) {
            this._size = 0;
            this.releaseValueCache();
        }
    }

    private void checkSize(int size) {
        if (this._next + size != this._size) {
            if (this._next + size >= this._size) {
                throw new MalformedValueException("Not enough bytes in Value at index=" + (this._next - 1));
            }
            if (this._depth == 0) {
                throw new MalformedValueException("Too many bytes in Value at index=" + (this._next - 1));
            }
        }
    }

    private void checkArrayLength(int length, int offset, int arrayLength) {
        if (length < 0 || length + offset > arrayLength) {
            throw new IllegalArgumentException("Invalid length " + length);
        }
    }

    private void pushEnd(int end) {
        if (this._endArray == null) {
            this._endArray = new int[10];
        } else if (this._level >= this._endArray.length) {
            int[] temp = new int[this._level * 2 + 1];
            System.arraycopy(this._endArray, 0, temp, 0, this._level);
            this._endArray = temp;
        }
        this._endArray[this._level++] = end;
    }

    private void closeVariableLengthItem() {
        this._next = this._end;
        this._end = this._level > 0 ? this.popEnd() : this._size;
    }

    private int popEnd() {
        return this._endArray[--this._level];
    }

    private int type() {
        if (this._next >= this._end) {
            throw new ConversionException("No more data at index=" + this._next + " end=" + this._end);
        }
        return this._bytes[this._next] & 0xFF;
    }

    private int nextType() {
        int type;
        if (this._depth > 0) {
            while (this._next >= this._end && this._level > 0) {
                this._end = this.popEnd();
            }
            type = this.type();
            ++this._next;
            if (type >= 192 && type <= 240) {
                int size = this.decodeVariableLengthInt(type);
                this.pushEnd(this._end);
                this._end = this._next + size;
                type = this._bytes[this._next++] & 0xFF;
            }
            if (type >= 64 && type <= 112) {
                type = this.decodeVariableLengthInt(type) + 64;
            } else if (type == 255) {
                return -1;
            }
        } else {
            this._next = 0;
            this._end = this._size;
            this._serializedItemCount = 0;
            this.releaseValueCache();
            if (this._level != 0) {
                this._level = 0;
                if (this._endArray != null && this._endArray.length > 100) {
                    this._endArray = null;
                }
            }
            if (this._size == 0) {
                throw new ConversionException("Value is undefined");
            }
            if ((type = this._bytes[this._next++] & 0xFF) >= 64 && type <= 112) {
                type = this.decodeVariableLengthInt(type) + 64;
            } else if (type == 255) {
                return -1;
            }
        }
        return type;
    }

    private int nextType(int expectedType) {
        int type = this.nextType();
        if (type != 1) {
            this.expectType(expectedType, type);
        }
        return type;
    }

    private int nextType(int expectedType1, int expectedType2) {
        int type = this.nextType();
        if (type != 1 && type != expectedType2) {
            this.expectType(expectedType1, type);
        }
        return type;
    }

    private void expectType(int expected, int actual) {
        if (expected != actual) {
            throw new ConversionException("Expected a " + this.classForHandle(expected) + " but value is a " + this.classForHandle(actual));
        }
    }

    private Object getExpectedType(Class<?> type) {
        Object object = this.get(null, null);
        if (object == null || type.isAssignableFrom(object.getClass())) {
            return object;
        }
        throw new ConversionException("Expected a " + type.getName() + " but value is a " + object.getClass().getName());
    }

    private void endVariableSizeItem(int itemSize) {
        if (this._depth > 0) {
            this._size += this.encodeVariableLengthInt(192, this._size - itemSize, itemSize);
        }
    }

    private int encodeVariableLengthInt(int base, int index, int value) {
        int encodingSize;
        Debug.$assert0.t((base & 0x3F) == 0);
        int n = value < 16 ? 1 : (value < 4096 ? 2 : (encodingSize = value < 0x100000 ? 3 : 5));
        if (this._size > index) {
            this.ensureFit(encodingSize);
            System.arraycopy(this._bytes, index, this._bytes, index + encodingSize, this._size - index);
        }
        base |= ENCODED_SIZE_BITS[encodingSize];
        switch (encodingSize) {
            case 5: {
                this._bytes[index + 4] = (byte)(value & 0xFF);
                this._bytes[index + 3] = (byte)((value >>>= 8) & 0xFF);
                value >>>= 8;
            }
            case 3: {
                this._bytes[index + 2] = (byte)(value & 0xFF);
                value >>>= 8;
            }
            case 2: {
                this._bytes[index + 1] = (byte)(value & 0xFF);
                value >>>= 8;
            }
            case 1: {
                this._bytes[index] = (byte)(base | value & 0xF);
            }
        }
        return encodingSize;
    }

    private int decodeElementCount() {
        int base = this._bytes[this._next] & 0xFF;
        if (base < 128 || base > 176) {
            throw new MalformedValueException("Invalid element count introducer " + base + " at " + this._next);
        }
        ++this._next;
        return this.decodeVariableLengthInt(base);
    }

    private int decodeVariableLengthInt(int base) {
        int result = base & 0xF;
        switch (base &= 0x30) {
            case 48: {
                result = result << 8 | this._bytes[this._next++] & 0xFF;
                result = result << 8 | this._bytes[this._next++] & 0xFF;
            }
            case 32: {
                result = result << 8 | this._bytes[this._next++] & 0xFF;
            }
            case 16: {
                result = result << 8 | this._bytes[this._next++] & 0xFF;
            }
        }
        return result;
    }

    private void encodeClass(Class<?> cl) {
        int classHandle = this.handleForClass(cl);
        if (classHandle < 64) {
            this.ensureFit(1);
            this._bytes[this._size++] = (byte)classHandle;
        } else {
            this.ensureFit(5);
            this._size += this.encodeVariableLengthInt(64, this._size, classHandle - 64);
        }
    }

    private int handleForClass(Class<?> cl) {
        int to;
        int from;
        if (cl.isArray()) {
            return 62;
        }
        if (cl.isPrimitive()) {
            from = 1;
            to = 14;
        } else {
            from = 18;
            to = CLASSES.length;
        }
        for (int index = from; index < to; ++index) {
            if (CLASSES[index] != cl) continue;
            return index;
        }
        return this.handleForIndexedClass(cl);
    }

    private int handleForIndexedClass(Class<?> cl) {
        ClassInfo ci = this._persistit.getClassIndex().lookupByClass(cl);
        if (ci != null) {
            return ci.getHandle();
        }
        throw new ConversionException("Class not mapped to handle " + cl.getName());
    }

    private Class<?> classForHandle(int classHandle) {
        if (classHandle > 0 && classHandle < CLASSES.length && CLASSES[classHandle] != null) {
            return CLASSES[classHandle];
        }
        if (classHandle == 62) {
            return Object[].class;
        }
        if (classHandle == 63) {
            return Object[][].class;
        }
        ClassInfo ci = this.classInfoForHandle(classHandle);
        return ci.getDescribedClass();
    }

    private ClassInfo classInfoForHandle(int classHandle) {
        ClassInfo classInfo = this._persistit.getClassIndex().lookupByHandle(classHandle);
        if (classInfo != null) {
            return classInfo;
        }
        throw new ConversionException("Unknown class handle " + classHandle);
    }

    private boolean toBoolean(int index) {
        char ch = (char)(this._bytes[index] & 0xFF);
        if (ch == 'T') {
            return true;
        }
        if (ch == 'F') {
            return false;
        }
        throw new ConversionException("Expected a Boolean  but value " + ch + " is neither 'T' nor 'F' at index=" + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMultiArray(Class<?> prototype) {
        Object result;
        int start = this._next;
        int type = this.nextType(63, 50);
        if (type == 50) {
            this._next = start;
            Object array = this.get(null, null);
            if (array == null || array.getClass().isArray()) {
                return array;
            }
            throw new ConversionException("Referenced object is not an array");
        }
        try {
            ++this._depth;
            int componentClassHandle = this.nextType();
            this.checkSize(1);
            int dimensions = this._bytes[this._next++] & 0xFF;
            if (prototype == null) {
                prototype = Array.newInstance(this.classForHandle(componentClassHandle), new int[dimensions]).getClass();
            }
            int length = this.decodeElementCount();
            result = Array.newInstance(prototype.getComponentType(), length);
            ++this._serializedItemCount;
            this.registerEncodedObject(result);
            Class<?> componentType = prototype.getComponentType();
            if (componentType.getComponentType().isArray()) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.getMultiArray(componentType));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.get(null, null));
                }
            }
        }
        finally {
            --this._depth;
        }
        this.closeVariableLengthItem();
        return result;
    }

    void decodeAntiValue(Exchange exchange) throws InvalidKeyException {
        this.nextType(49);
        int length = this._end - this._next;
        if (length > 0) {
            int elisionCount = Util.getShort(this._bytes, this._next);
            AntiValue.fixUpKeys(exchange, elisionCount, this._bytes, this._next + 2, length - 2);
        }
        this._next += length;
        this.closeVariableLengthItem();
    }

    public ObjectOutputStream getObjectOutputStream() throws ConversionException {
        if (this._vos == null) {
            this._vos = (ValueObjectOutputStream)this.getPrivilegedStream(true);
        }
        return this._vos;
    }

    public ObjectInputStream getObjectInputStream() throws ConversionException {
        if (this._vis == null) {
            this._vis = (ValueObjectInputStream)this.getPrivilegedStream(false);
        }
        return this._vis;
    }

    private Object getPrivilegedStream(final boolean output) {
        try {
            final Value value = this;
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (output) {
                        return new ValueObjectOutputStream(value);
                    }
                    return new ValueObjectInputStream(value);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ConversionException("While creating " + (output ? "ValueObjectOutputStream" : "ValueObjectInputStream"), pae.getException());
        }
    }

    public OldValueInputStream oldValueInputStream(ObjectStreamClass classDescriptor) throws IOException {
        return new OldValueInputStream(this, classDescriptor);
    }

    public OldValueOutputStream oldValueOutputStream(ObjectStreamClass classDescriptor) throws IOException {
        return new OldValueOutputStream(this, classDescriptor);
    }

    DefaultValueCoder getCurrentCoder() {
        return this._currentCoder;
    }

    Object getCurrentObject() {
        return this._currentObject;
    }

    void setCurrentCoder(DefaultValueCoder coder) {
        this._currentCoder = coder;
    }

    void setCurrentObject(Object object) {
        this._currentObject = object;
    }

    private ValueCache getValueCache() {
        if (this._valueCache == null && this._valueCacheWeakRef != null) {
            this._valueCache = (ValueCache)this._valueCacheWeakRef.get();
        }
        if (this._valueCache == null) {
            this._valueCache = new ValueCache();
            this._valueCacheWeakRef = new WeakReference<ValueCache>(this._valueCache);
        }
        return this._valueCache;
    }

    private void releaseValueCache() {
        this._serializedItemCount = 0;
        if (this._valueCache != null) {
            this._valueCache.clear();
            this._valueCache = null;
        }
    }

    List<Version> unpackMvvVersions() throws PersistitException {
        final ArrayList<Version> versions = new ArrayList<Version>();
        MVV.VersionVisitor visitor = new MVV.VersionVisitor(){

            @Override
            public void sawVersion(long version, int valueOffset, int valueLength) {
                long tc = -1L;
                try {
                    tc = Value.this._persistit.getTransactionIndex().commitStatus(version, Long.MAX_VALUE, 0);
                }
                catch (Exception e) {
                    tc = -1L;
                }
                Value value = new Value(Value.this._persistit);
                value.ensureFit(valueLength);
                System.arraycopy(Value.this._bytes, valueOffset, value.getEncodedBytes(), 0, valueLength);
                value.setEncodedSize(valueLength);
                value.trim();
                versions.add(new Version(version, tc, value));
            }

            @Override
            public void init() throws PersistitException {
            }
        };
        MVV.visitAllVersions(visitor, this.getEncodedBytes(), 0, this.getEncodedSize());
        return versions;
    }

    private void putCharSequenceInternal(CharSequence string) {
        int length = string.length();
        this.ensureFit(length + 1);
        int saveSize = this._size;
        int index = this._size;
        this._bytes[index++] = 32;
        int maxLength = this._bytes.length;
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                if (index + 1 > maxLength) {
                    this._size = index;
                    this.ensureFit(index + 1 + (length - i) * 2);
                    maxLength = this._bytes.length;
                }
                this._bytes[index++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                if (index + 3 > maxLength) {
                    this._size = index;
                    this.ensureFit(index + 3 + (length - i) * 2);
                    maxLength = this._bytes.length;
                }
                this._bytes[index++] = (byte)(0xE0 | c >> 12 & 0xF);
                this._bytes[index++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._bytes[index++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            if (index + 2 > maxLength) {
                this._size = index;
                this.ensureFit(index + 2 + (length - i) * 2);
                maxLength = this._bytes.length;
            }
            this._bytes[index++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this._bytes[index++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        length = index - saveSize;
        this._size = index;
        this.endVariableSizeItem(length);
    }

    private int directHandle(ValueCoder coder, Class<?> clazz) {
        if (coder instanceof HandleCache) {
            HandleCache cache = (HandleCache)((Object)coder);
            int handle = cache.getHandle();
            if (handle == 0) {
                handle = this.handleForClass(clazz);
                cache.setHandle(handle);
            }
            return handle;
        }
        return this.handleForClass(clazz);
    }

    static class Version {
        private final long _versionHandle;
        private final long _commitTimestamp;
        private final Value _value;

        private Version(long versionHandle, long commitTimestamp, Value value) {
            this._versionHandle = versionHandle;
            this._commitTimestamp = commitTimestamp;
            this._value = value;
        }

        public long getVersionHandle() {
            return this._versionHandle;
        }

        public long getCommitTimestamp() {
            return this._commitTimestamp;
        }

        public Value getValue() {
            return this._value;
        }

        public long getStartTimestamp() {
            return TransactionIndex.vh2ts(this._versionHandle);
        }

        public int getStep() {
            return TransactionIndex.vh2step(this._versionHandle);
        }

        public String toString() {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("%,d", this.getStartTimestamp()));
                if (this.getStep() > 0) {
                    sb.append(String.format("#%02d", this.getStep()));
                }
                sb.append("<" + TransactionStatus.tcString(this._commitTimestamp) + ">");
                sb.append(":");
                sb.append(this._value);
                return sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.toString();
            }
        }
    }

    private static class SkippedFieldMarker {
        final Value _value;
        final int _next;
        final int _end;

        private SkippedFieldMarker(Value value, int next, int end) {
            this._value = value;
            this._next = next;
            this._end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object get() {
            int saveDepth = this._value._depth;
            int saveLevel = this._value._level;
            int saveNext = this._value._next;
            int saveEnd = this._value._end;
            try {
                this._value._next = this._next;
                this._value._end = this._end;
                Object object = this._value.get();
                return object;
            }
            finally {
                this._value._end = saveEnd;
                this._value._next = saveNext;
                this._value._level = saveLevel;
                this._value._depth = saveDepth;
            }
        }
    }

    private static class DisplayMarker {
        int _start;

        DisplayMarker(int start) {
            this._start = start;
        }

        public String toString() {
            return "@" + Integer.toString(this._start);
        }
    }

    static class ValueCache {
        private static final int INITIAL_SIZE = 256;
        Object[] _array = new Object[256];
        int _handleCount = 0;

        ValueCache() {
            this.clear();
        }

        int lookup(Object object) {
            int index = this._handleCount;
            while (--index >= 0) {
                if (this._array[index] != object) continue;
                return index;
            }
            return -1;
        }

        Object get(int handle) {
            Object object = this._array[handle];
            if (object instanceof SkippedFieldMarker) {
                this._array[handle] = object = ((SkippedFieldMarker)object).get();
            }
            return object;
        }

        void store(int handle, Object object) {
            if (handle >= this._array.length) {
                this.grow(1 + handle * 2);
            }
            if (handle >= this._handleCount) {
                this._handleCount = handle + 1;
            }
            this._array[handle] = object;
        }

        int put(int handle, Object object) {
            int previous = this.lookup(object);
            if (previous != -1) {
                return previous;
            }
            this.store(handle, object);
            return -1;
        }

        void grow(int newSize) {
            Object[] temp = this._array;
            this._array = new Object[newSize];
            System.arraycopy(temp, 0, this._array, 0, temp.length);
        }

        void clear() {
            int index = this._handleCount;
            while (--index >= 0) {
                this._array[index] = null;
            }
            this._handleCount = 0;
        }
    }

    static class OldValueOutputStream
    extends ObjectOutputStream {
        Value _value;
        ObjectStreamClass _classDescriptor;
        boolean _innerClassDescriptor;

        OldValueOutputStream(Value value, ObjectStreamClass classDescriptor) throws IOException {
            this(value);
            if (classDescriptor == null) {
                throw new ConversionException("Null class descriptor");
            }
            this._classDescriptor = classDescriptor;
        }

        private OldValueOutputStream(Value value) throws IOException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                    Value.this.ensureFit(1);
                    ((Value)Value.this)._bytes[((Value)Value.this)._size++] = (byte)b;
                }

                @Override
                public void write(byte[] bytes) {
                    this.write(bytes, 0, bytes.length);
                }

                @Override
                public void write(byte[] bytes, int offset, int size) {
                    Value.this.ensureFit(size);
                    System.arraycopy(bytes, offset, Value.this._bytes, Value.this._size, size);
                    Value.this._size += size;
                }
            });
            this._value = value;
        }

        @Override
        protected final void writeClassDescriptor(ObjectStreamClass classDescriptor) throws IOException {
            if (this._classDescriptor == null) {
                super.writeClassDescriptor(classDescriptor);
            } else if (this._innerClassDescriptor) {
                Class<?> clazz = classDescriptor.forClass();
                int handle = this._value.handleForIndexedClass(clazz);
                this.writeInt(handle);
            } else {
                this._innerClassDescriptor = true;
            }
        }

        @Override
        protected final void writeStreamHeader() throws IOException {
            if (this._classDescriptor == null) {
                super.writeStreamHeader();
            }
        }
    }

    public static class OldValueInputStream
    extends ObjectInputStream {
        Value _value;
        boolean _innerClassDescriptor;
        int _mark = -1;
        ObjectStreamClass _classDescriptor;

        private OldValueInputStream(Value value, ObjectStreamClass classDescriptor) throws IOException {
            this(value);
            if (classDescriptor == null) {
                throw new ConversionException("Null class descriptor");
            }
            this._value = value;
            this._classDescriptor = classDescriptor;
        }

        private OldValueInputStream(Value value) throws IOException {
            super(new InputStream(){

                @Override
                public int read() {
                    if (Value.this._next < Value.this._end) {
                        return Value.this._bytes[Value.this._next++] & 0xFF;
                    }
                    return -1;
                }

                @Override
                public int read(byte[] bytes) {
                    return this.read(bytes, 0, bytes.length);
                }

                @Override
                public int read(byte[] bytes, int offset, int size) {
                    if (Value.this._next + size > Value.this._end) {
                        size = Value.this._end - Value.this._next;
                    }
                    if (size <= 0) {
                        size = -1;
                    } else {
                        System.arraycopy(Value.this._bytes, Value.this._next, bytes, offset, size);
                        Value.this._next += size;
                    }
                    return size;
                }

                @Override
                public long skip(long lsize) {
                    int size;
                    int n = size = lsize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lsize;
                    if (size < 0) {
                        return 0L;
                    }
                    if (Value.this._next + size > Value.this._end) {
                        size = Value.this._end - Value.this._next;
                    }
                    if (size < 0) {
                        return 0L;
                    }
                    Value.this._next += size;
                    return size;
                }

                @Override
                public int available() {
                    int available = Value.this._end - Value.this._next;
                    return available > 0 ? available : 0;
                }
            });
            this._value = value;
        }

        @Override
        protected final ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            if (this._classDescriptor == null) {
                return super.readClassDescriptor();
            }
            if (this._innerClassDescriptor) {
                int handle = this.readInt();
                ClassInfo classInfo = this._value.classInfoForHandle(handle);
                ObjectStreamClass classDescriptor = null;
                if (classInfo != null) {
                    classDescriptor = classInfo.getClassDescriptor();
                }
                if (classDescriptor == null) {
                    throw new ConversionException("Unknown class handle " + handle);
                }
                return classDescriptor;
            }
            this._innerClassDescriptor = true;
            return this._classDescriptor;
        }

        @Override
        protected final void readStreamHeader() throws IOException {
            if (this._classDescriptor == null) {
                super.readStreamHeader();
            }
        }

        @Override
        public void mark(int readLimit) {
            this._mark = this._value._next;
        }

        @Override
        public void reset() throws IOException {
            if (this._mark < 0) {
                throw new IOException("No mark");
            }
            this._value._next = this._mark;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
            String name = desc.getName();
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
    }

    private static class ValueObjectInputStream
    extends ObjectInputStream {
        Value _value;

        private ValueObjectInputStream(Value value) throws IOException {
            this._value = value;
        }

        @Override
        public Object readObjectOverride() {
            return this._value.get();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public boolean readBoolean() {
            return this._value.getBoolean();
        }

        @Override
        public byte readByte() {
            return this._value.getByte();
        }

        @Override
        public int readUnsignedByte() {
            return this._value.getByte() & 0xFF;
        }

        @Override
        public short readShort() {
            return this._value.getShort();
        }

        @Override
        public int readUnsignedShort() {
            return this._value.getShort() & 0xFFFF;
        }

        @Override
        public char readChar() {
            return this._value.getChar();
        }

        @Override
        public int readInt() {
            return this._value.getInt();
        }

        @Override
        public long readLong() {
            return this._value.getLong();
        }

        @Override
        public float readFloat() {
            return this._value.getFloat();
        }

        @Override
        public double readDouble() {
            return this._value.getDouble();
        }

        @Override
        public String readUTF() {
            return this._value.getString();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.read(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int offset, int length) throws IOException {
            this.read(b, offset, length);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            if (offset < 0 || offset + length > b.length) {
                throw new IndexOutOfBoundsException();
            }
            int sourceLength = this._value._end - this._value._next;
            if (length > sourceLength) {
                throw new IOException("Not enough bytes remaining in value");
            }
            System.arraycopy(this._value._bytes, this._value._next, b, offset, length);
            this._value._next += length;
            return length;
        }

        @Override
        public int skipBytes(int length) throws IOException {
            int sourceLength = this._value._end - this._value._next;
            if (length > sourceLength) {
                throw new IOException("Not enough bytes remaining in value");
            }
            this._value._next += length;
            return length;
        }

        @Override
        public String readLine() {
            throw new UnsupportedOperationException("No readLine method");
        }

        @Override
        public void defaultReadObject() {
            if (this._value._currentCoder == null || this._value._currentObject == null) {
                throw new ConversionException("not in call to readObject");
            }
            this._value._currentCoder.renderDefaultFields(this._value, this._value._currentObject);
        }
    }

    private static class ValueObjectOutputStream
    extends ObjectOutputStream {
        private final Value _value;

        private ValueObjectOutputStream(Value value) throws IOException {
            this._value = value;
        }

        @Override
        public void writeObjectOverride(Object object) {
            this.writeObject0(object, true);
        }

        @Override
        public void write(int b) {
            this._value.ensureFit(1);
            ((Value)this._value)._bytes[((Value)this._value)._size++] = (byte)b;
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int size) {
            this._value.ensureFit(size);
            System.arraycopy(bytes, offset, this._value._bytes, this._value._size, size);
            this._value._size += size;
        }

        @Override
        public void writeBoolean(boolean v) {
            this._value.put(v);
        }

        @Override
        public void writeByte(int v) {
            this._value.put((byte)v);
        }

        @Override
        public void writeShort(int v) {
            this._value.put((short)v);
        }

        @Override
        public void writeChar(int v) {
            this._value.put((char)v);
        }

        @Override
        public void writeInt(int v) {
            this._value.put(v);
        }

        @Override
        public void writeLong(long v) {
            this._value.put(v);
        }

        @Override
        public void writeFloat(float v) {
            this._value.put(v);
        }

        @Override
        public void writeDouble(double v) {
            this._value.put(v);
        }

        @Override
        public void writeUnshared(Object object) {
            this.writeObject0(object, false);
        }

        @Override
        public void writeUTF(String v) {
            this._value.putUTF(v);
        }

        @Override
        public void writeBytes(String s) {
            throw new UnsupportedOperationException("No writeBytes method");
        }

        @Override
        public void writeChars(String s) {
            throw new UnsupportedOperationException("No writeChars method");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject0(Object object, boolean shared) {
            boolean saveShared = this._value._shared;
            this._value._shared = shared;
            try {
                this._value.put(object);
            }
            finally {
                this._value._shared = saveShared;
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void defaultWriteObject() throws IOException {
            if (this._value._currentCoder == null || this._value._currentObject == null) {
                throw new NotActiveException("not in call to writeObject");
            }
            this._value._currentCoder.putDefaultFields(this._value, this._value._currentObject);
        }
    }
}

