/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.BufferPool;
import com.persistit.CLI;
import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.KeyFilter;
import com.persistit.KeyParser;
import com.persistit.KeyState;
import com.persistit.Management;
import com.persistit.Persistit;
import com.persistit.Task;
import com.persistit.Transaction;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.ValueState;
import com.persistit.Volume;
import com.persistit.encoding.CoderContext;
import com.persistit.exception.PersistitException;
import com.persistit.exception.TreeNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.management.ObjectName;

class ManagementImpl
implements Management {
    private static final long MAX_STALE = 100L;
    private static int _localRegistryPort = -1;
    private long _taskIdCounter;
    private transient Persistit _persistit;
    private transient Management.DisplayFilter _displayFilter;
    private boolean _registered = false;
    private String _registeredHostName;
    private final HashMap<Long, Task> _tasks = new HashMap();
    private final Management.TransactionInfo _transactionInfoCache = new Management.TransactionInfo();

    public ManagementImpl(Persistit persistit) {
        this._persistit = persistit;
        this._displayFilter = new Management.DisplayFilter(){

            @Override
            public String toKeyDisplayString(Exchange exchange) {
                return exchange.getKey().toString();
            }

            @Override
            public String toValueDisplayString(Exchange exchange) {
                return exchange.getValue().toString();
            }
        };
    }

    @Override
    public boolean isInitialized() {
        return this._persistit.isInitialized();
    }

    @Override
    public String getVersion() {
        return Persistit.version();
    }

    @Override
    public String getCopyright() {
        return Persistit.copyright();
    }

    @Override
    public long getStartTime() {
        return this._persistit.startTime();
    }

    @Override
    public long getElapsedTime() {
        return this._persistit.elapsedTime();
    }

    @Override
    public int getRmiPort() {
        return _localRegistryPort;
    }

    @Override
    public long getCommittedTransactionCount() {
        return this.getTransactionInfo().getCommitCount();
    }

    @Override
    public long getRollbackCount() {
        return this.getTransactionInfo().getRollbackCount();
    }

    @Override
    public Management.VolumeInfo[] getVolumes() throws RemoteException {
        return this.getVolumeInfoArray();
    }

    @Override
    public Map<ObjectName, Object> getMXBeans() {
        return this._persistit.getMXBeans();
    }

    @Override
    public boolean isShutdownSuspended() {
        return this._persistit.isShutdownSuspended();
    }

    @Override
    public void setShutdownSuspended(boolean suspended) {
        this._persistit.setShutdownSuspended(suspended);
    }

    @Override
    public boolean isUpdateSuspended() {
        return this._persistit.isUpdateSuspended();
    }

    @Override
    public void setUpdateSuspended(boolean suspended) {
        this._persistit.setUpdateSuspended(suspended);
    }

    public void setIoLogFile(String path) throws RemoteException {
        try {
            if (path == null || path.isEmpty()) {
                this._persistit.getIOMeter().setLogFile(null);
            } else {
                this._persistit.getIOMeter().setLogFile(path);
            }
        }
        catch (IOException e) {
            throw new Management.WrappedRemoteException(e);
        }
    }

    @Override
    public void setAppendOnly(boolean suspended) {
        this._persistit.getJournalManager().setAppendOnly(suspended);
    }

    @Override
    public void setJournalCopyingFast(boolean fast) throws RemoteException {
        this._persistit.getJournalManager().setCopyingFast(fast);
    }

    @Override
    public String getDefaultCommitPolicy() {
        return this._persistit.getDefaultTransactionCommitPolicy().toString();
    }

    @Override
    public void setDefaultCommitPolicy(String policyName) {
        this._persistit.setDefaultTransactionCommitPolicy(policyName);
    }

    @Override
    public boolean close() throws RemoteException {
        try {
            this._persistit.close();
            return true;
        }
        catch (PersistitException e) {
            throw new Management.WrappedRemoteException(e);
        }
    }

    @Override
    public void flushAndForce() throws RemoteException {
        try {
            this._persistit.flush();
            this._persistit.force();
        }
        catch (PersistitException e) {
            throw new Management.WrappedRemoteException(e);
        }
    }

    @Override
    public Management.BufferPoolInfo[] getBufferPoolInfoArray() {
        HashMap<Integer, BufferPool> bufferPoolTable = this._persistit.getBufferPoolHashMap();
        int size = bufferPoolTable.size();
        Management.BufferPoolInfo[] result = new Management.BufferPoolInfo[size];
        int index = 0;
        for (int bufferSize = 1024; bufferSize <= 16384; bufferSize *= 2) {
            BufferPool pool = bufferPoolTable.get(new Integer(bufferSize));
            if (pool == null || index >= size) continue;
            Management.BufferPoolInfo info = new Management.BufferPoolInfo();
            pool.populateBufferPoolInfo(info);
            result[index++] = info;
        }
        return result;
    }

    @Override
    public Management.JournalInfo getJournalInfo() {
        Management.JournalInfo info = new Management.JournalInfo();
        this._persistit.getJournalManager().populateJournalInfo(info);
        return info;
    }

    @Override
    public Management.RecoveryInfo getRecoveryInfo() {
        Management.RecoveryInfo info = new Management.RecoveryInfo();
        this._persistit.getRecoveryManager().populateRecoveryInfo(info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Management.TransactionInfo getTransactionInfo() {
        Management.TransactionInfo info = this._transactionInfoCache;
        if (System.currentTimeMillis() - info.getAcquisitionTime() > 100L) {
            ArrayList<Transaction> transactions = new ArrayList<Transaction>();
            Management.TransactionInfo transactionInfo = info;
            synchronized (transactionInfo) {
                info.commitCount = 0L;
                info.rollbackCount = 0L;
                info.rollbackSinceCommitCount = 0L;
                this._persistit.populateTransactionList(transactions);
                for (Transaction txn : transactions) {
                    info.commitCount += txn.getCommittedTransactionCount();
                    info.rollbackCount += txn.getRolledBackTransactionCount();
                    info.rollbackSinceCommitCount += (long)txn.getRolledBackSinceLastCommitCount();
                }
                info.updateAcquisitonTime();
            }
        }
        return info;
    }

    @Override
    public String transactionReport(int max) {
        return this._persistit.transactionReport(max);
    }

    @Override
    public Management.LogicalRecord[] getLogicalRecordArray(String volumeName, String treeName, String keyFilterString, KeyState fromKey, Key.Direction direction, int maxCount, int maxValueBytes, boolean decodeStrings) throws RemoteException {
        Management.LogicalRecord[] records = new Management.LogicalRecord[maxCount];
        int count = 0;
        boolean forward = direction == Key.GT || direction == Key.GTEQ;
        Exchange exchange = null;
        try {
            exchange = treeName.equals("_directory") ? this._persistit.getVolume(volumeName).getStructure().directoryExchange() : this._persistit.getExchange(volumeName, treeName, false);
            exchange.ignoreMVCCFetch(true);
            KeyFilter filter = null;
            if (keyFilterString != null && keyFilterString.length() > 0) {
                filter = new KeyFilter(keyFilterString);
            }
            fromKey.copyTo(exchange.getKey());
            while (count < maxCount) {
                if (!exchange.traverse(direction, filter, maxValueBytes)) {
                    break;
                }
                Management.LogicalRecord record = new Management.LogicalRecord();
                record._key = new KeyState(exchange.getKey());
                record._value = new ValueState(exchange.getValue(), maxValueBytes);
                if (decodeStrings) {
                    record._keyString = this._displayFilter.toKeyDisplayString(exchange);
                    record._valueString = this._displayFilter.toValueDisplayString(exchange);
                }
                if (forward) {
                    records[count] = record;
                } else {
                    records[maxCount - count - 1] = record;
                }
                ++count;
            }
        }
        catch (Exception e) {
            throw new Management.WrappedRemoteException(e);
        }
        finally {
            exchange.ignoreMVCCFetch(false);
        }
        if (count < maxCount) {
            Management.LogicalRecord[] trimmed = new Management.LogicalRecord[count];
            System.arraycopy(records, forward ? 0 : maxCount - count, trimmed, 0, count);
            records = trimmed;
        }
        return records;
    }

    @Override
    public Management.LogicalRecordCount getLogicalRecordCount(String volumeName, String treeName, String keyFilterString, KeyState fromKey, Key.Direction direction, int maxCount) throws RemoteException {
        int count = 0;
        Exchange exchange = null;
        KeyState endKeyState = null;
        try {
            exchange = this._persistit.getExchange(volumeName, treeName, false);
            exchange.getAuxiliaryKey2().clear();
            KeyFilter filter = null;
            if (keyFilterString != null && keyFilterString.length() > 0) {
                filter = new KeyFilter(keyFilterString);
            }
            fromKey.copyTo(exchange.getKey());
            while (count < maxCount && exchange.traverse(direction, filter, 0)) {
                exchange.getKey().copyTo(exchange.getAuxiliaryKey2());
                ++count;
            }
            endKeyState = new KeyState(exchange.getAuxiliaryKey2());
        }
        catch (Exception pe) {
            throw new Management.WrappedRemoteException(pe);
        }
        finally {
            if (exchange != null) {
                this._persistit.releaseExchange(exchange);
            }
        }
        return new Management.LogicalRecordCount(endKeyState, count);
    }

    @Override
    public Management.RecordInfo[] getRecordInfoArray(String volumeName, long pageAddress) throws RemoteException {
        Volume volume = this._persistit.getVolume(volumeName);
        if (volume == null) {
            return new Management.RecordInfo[0];
        }
        try {
            Buffer buffer = volume.getPool().getBufferCopy(volume, pageAddress);
            return buffer.getRecords();
        }
        catch (PersistitException pe) {
            throw new Management.WrappedRemoteException(pe);
        }
    }

    @Override
    public Management.BufferInfo[] getBufferInfoArray(int bufferSize, int traversalType, String includeMask, String excludeMask) {
        BufferPool pool = this._persistit.getBufferPool(bufferSize);
        if (pool == null) {
            return new Management.BufferInfo[0];
        }
        Management.BufferInfo[] results = new Management.BufferInfo[pool.getBufferCount()];
        int count = pool.populateInfo(results, traversalType, ManagementImpl.makeStatus(includeMask), ManagementImpl.makeStatus(excludeMask));
        if (count < results.length) {
            Management.BufferInfo[] temp = new Management.BufferInfo[count];
            System.arraycopy(results, 0, temp, 0, count);
            results = temp;
        }
        return results;
    }

    @Override
    public Management.BufferInfo getBufferInfo(String volumeName, long pageAddress) throws RemoteException {
        Volume volume = this._persistit.getVolume(volumeName);
        if (volume == null) {
            return null;
        }
        try {
            Buffer buffer = volume.getPool().getBufferCopy(volume, pageAddress);
            Management.BufferInfo info = new Management.BufferInfo();
            buffer.populateInfo(info);
            return info;
        }
        catch (PersistitException pe) {
            throw new Management.WrappedRemoteException(pe);
        }
    }

    @Override
    public Management.BufferInfo getBufferInfo(String volumeName, String treeName, KeyState key, int level) throws RemoteException {
        try {
            Volume volume = this._persistit.getVolume(volumeName);
            if (volume == null) {
                return null;
            }
            Exchange exchange = treeName == null ? volume.getStructure().directoryExchange() : this._persistit.getExchange(volume, treeName, false);
            key.copyTo(exchange.getKey());
            Buffer buffer = exchange.fetchBufferCopy(level);
            Management.BufferInfo info = new Management.BufferInfo();
            buffer.populateInfo(info);
            return info;
        }
        catch (TreeNotFoundException tnfe) {
            return null;
        }
        catch (PersistitException pe) {
            throw new Management.WrappedRemoteException(pe);
        }
    }

    @Override
    public int populateBufferInfoArray(Management.BufferInfo[] results, int bufferSize, int traversalType, String includeMask, String excludeMask) {
        BufferPool pool = this._persistit.getBufferPool(bufferSize);
        if (pool == null) {
            return -1;
        }
        int count = pool.populateInfo(results, traversalType, ManagementImpl.makeStatus(includeMask), ManagementImpl.makeStatus(excludeMask));
        return count;
    }

    private static int makeStatus(String statusCode) {
        if (statusCode == null) {
            return 0;
        }
        int status = 0;
        if (statusCode.indexOf(118) >= 0) {
            status |= 0x20000;
        }
        if (statusCode.indexOf(100) >= 0) {
            status |= 0x10000;
        }
        if (statusCode.indexOf(114) >= 0) {
            status |= Short.MAX_VALUE;
        }
        if (statusCode.indexOf(119) >= 0) {
            status |= 0x8000;
        }
        if (statusCode.indexOf(112) >= 0) {
            status |= 0x40000000;
        }
        if (statusCode.indexOf(97) >= 0) {
            status |= 0x4003FFFF;
        }
        if (status == 0) {
            status = Integer.MIN_VALUE;
        }
        return status;
    }

    @Override
    public Management.VolumeInfo[] getVolumeInfoArray() {
        List<Volume> volumes = this._persistit.getVolumes();
        Object[] result = new Management.VolumeInfo[volumes.size()];
        for (int index = 0; index < volumes.size(); ++index) {
            result[index] = new Management.VolumeInfo(volumes.get(index));
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public Management.VolumeInfo getVolumeInfo(String volumeName) {
        Volume volume = this._persistit.getVolume(volumeName);
        if (volume == null) {
            return null;
        }
        return new Management.VolumeInfo(volume);
    }

    @Override
    public Management.TreeInfo[] getTreeInfoArray(String volumeName) throws RemoteException {
        if (volumeName == null) {
            return new Management.TreeInfo[0];
        }
        Volume volume = this._persistit.getVolume(volumeName);
        if (volume == null) {
            return new Management.TreeInfo[0];
        }
        try {
            String[] treeNames = volume.getTreeNames();
            Management.TreeInfo[] results = new Management.TreeInfo[treeNames.length + 1];
            int count = 0;
            results[count++] = new Management.TreeInfo(volume.getDirectoryTree());
            for (int index = 0; index < treeNames.length; ++index) {
                Management.TreeInfo info = volume.getTreeInfo(treeNames[index]);
                if (info == null) continue;
                results[count++] = info;
            }
            if (count < results.length) {
                Management.TreeInfo[] temp = new Management.TreeInfo[count];
                System.arraycopy(results, 0, temp, 0, count);
                results = temp;
            }
            return results;
        }
        catch (PersistitException pe) {
            throw new Management.WrappedRemoteException(pe);
        }
    }

    @Override
    public Management.TreeInfo getTreeInfo(String volumeName, String treeName) throws RemoteException {
        Volume volume = this._persistit.getVolume(volumeName);
        if (volume == null) {
            return null;
        }
        try {
            Tree tree = null;
            tree = "_directory".equals(treeName) ? volume.getDirectoryTree() : volume.getTree(treeName, false);
            if (tree != null) {
                return new Management.TreeInfo(tree);
            }
        }
        catch (PersistitException pe) {
            throw new Management.WrappedRemoteException(pe);
        }
        return null;
    }

    public Class getRemoteClass(String className) throws RemoteException {
        ClassLoader loader = new ClassLoader(){};
        try {
            Class<?> clazz = loader.loadClass(className);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            throw new Management.WrappedRemoteException(cnfe);
        }
    }

    @Override
    public int parseKeyFilterString(String keyFilterString) throws RemoteException {
        KeyParser parser = new KeyParser(keyFilterString);
        if (parser.parseKeyFilter() != null) {
            return -1;
        }
        return parser.getIndex();
    }

    @Override
    public Object[] decodeValueObjects(ValueState valueState, CoderContext context) throws RemoteException {
        try {
            Value value = new Value(this._persistit);
            valueState.copyTo(value);
            value.setStreamMode(true);
            Vector<Object> vector = new Vector<Object>();
            while (value.hasMoreItems()) {
                vector.addElement(value.get(null, context));
            }
            Object[] result = new Object[vector.size()];
            for (int index = 0; index < result.length; ++index) {
                result[index] = vector.get(index);
            }
            return result;
        }
        catch (Exception e) {
            throw new Management.WrappedRemoteException(e);
        }
    }

    @Override
    public Object[] decodeKeyObjects(KeyState keyState, CoderContext context) throws RemoteException {
        try {
            Key key = new Key(this._persistit);
            keyState.copyTo(key);
            int size = key.getDepth();
            Object[] result = new Object[size];
            for (int index = 0; index < size; ++index) {
                result[index] = key.decode(null, context);
            }
            return result;
        }
        catch (Exception e) {
            throw new Management.WrappedRemoteException(e);
        }
    }

    @Override
    public synchronized long startTask(String description, String owner, String commandLine, long maximumTime, int verbosity) throws RemoteException {
        try {
            Task task = CLI.parseTask(this._persistit, commandLine);
            if (task == null) {
                throw new Management.WrappedRemoteException(new IllegalArgumentException("Unknown task " + commandLine));
            }
            long taskId = ++this._taskIdCounter;
            task.setPersistit(this._persistit);
            task.setup(taskId, description, owner, maximumTime, verbosity);
            this._tasks.put(new Long(taskId), task);
            task.start();
            return taskId;
        }
        catch (Exception ex) {
            throw new Management.WrappedRemoteException(ex);
        }
    }

    @Override
    public synchronized Management.TaskStatus[] queryTaskStatus(long taskId, boolean details, boolean clearMessages) {
        return this.queryTaskStatus(taskId, details, clearMessages, true);
    }

    @Override
    public synchronized Management.TaskStatus[] queryTaskStatus(long taskId, boolean details, boolean clearMessages, boolean clearTasks) {
        if (taskId == -1L) {
            int size = this._tasks.size();
            int index = 0;
            Management.TaskStatus[] result = new Management.TaskStatus[size];
            Iterator<Task> iterator = this._tasks.values().iterator();
            while (iterator.hasNext()) {
                Task task = iterator.next();
                Management.TaskStatus ts = new Management.TaskStatus();
                task.populateTaskStatus(ts, details, clearMessages);
                result[index++] = ts;
                if (!clearTasks || !Task.isFinalStatus(task._state)) continue;
                iterator.remove();
            }
            return result;
        }
        Task task = this._tasks.get(taskId);
        if (task == null) {
            return new Management.TaskStatus[0];
        }
        Management.TaskStatus ts = new Management.TaskStatus();
        task.populateTaskStatus(ts, details, clearMessages);
        if (clearTasks && Task.isFinalStatus(task._state)) {
            this._tasks.remove(taskId);
        }
        return new Management.TaskStatus[]{ts};
    }

    @Override
    public synchronized void setTaskSuspended(long taskId, boolean suspend) {
        if (taskId == -1L) {
            for (Task task : this._tasks.values()) {
                if (suspend) {
                    task.suspend();
                    continue;
                }
                task.resume();
            }
        } else {
            Task task = this._tasks.get(new Long(taskId));
            if (task != null) {
                if (suspend) {
                    task.suspend();
                } else {
                    task.resume();
                }
            }
        }
    }

    @Override
    public synchronized void stopTask(long taskId, boolean remove) {
        if (taskId == -1L) {
            for (Task task : this._tasks.values()) {
                task.stop();
            }
            if (remove) {
                this._tasks.clear();
            }
        } else {
            Task task = this._tasks.get(new Long(taskId));
            if (task != null) {
                task.stop();
                if (remove) {
                    this._tasks.remove(new Long(task._taskId));
                }
            }
        }
    }

    @Override
    public synchronized void removeFinishedTasks(long taskId) {
        if (taskId == -1L) {
            Iterator<Task> iterator = this._tasks.values().iterator();
            while (iterator.hasNext()) {
                Task task = iterator.next();
                if (!Task.isFinalStatus(task._state)) continue;
                iterator.remove();
            }
        } else {
            Long key = taskId;
            Task task = this._tasks.get(key);
            if (task != null && Task.isFinalStatus(task._state)) {
                this._tasks.remove(key);
            }
        }
    }

    @Override
    public Management.DisplayFilter getDisplayFilter() {
        return this._displayFilter;
    }

    @Override
    public void setDisplayFilter(Management.DisplayFilter displayFilter) {
        this._displayFilter = displayFilter;
    }

    void register(String hostName, int rmiPort, int serverPort) {
        try {
            ManagementImpl impl = (ManagementImpl)this._persistit.getManagement();
            if (hostName == null && rmiPort != -1) {
                try {
                    if (hostName == null) {
                        InetAddress addr = InetAddress.getLocalHost();
                        try {
                            hostName = addr.getHostName() + ":" + rmiPort;
                        }
                        catch (Exception e) {
                            hostName = addr.getHostAddress() + ":" + rmiPort;
                        }
                    }
                }
                catch (NumberFormatException addr) {
                    // empty catch block
                }
            }
            if (rmiPort != -1 && _localRegistryPort != rmiPort) {
                LocateRegistry.createRegistry(rmiPort);
                _localRegistryPort = rmiPort;
            }
            if (hostName != null && hostName.length() > 0) {
                String name = "//" + hostName + "/PersistitManagementServer";
                UnicastRemoteObject.exportObject((Remote)impl, serverPort);
                Naming.rebind(name, impl);
                impl._registered = true;
                impl._registeredHostName = hostName;
                this._persistit.getLogBase().rmiServerRegistered.log(hostName);
            }
        }
        catch (Exception exception) {
            this._persistit.getLogBase().rmiRegisterException.log(hostName, exception);
        }
    }

    void unregister() {
        if (this._registered) {
            try {
                ManagementImpl impl = (ManagementImpl)this._persistit.getManagement();
                UnicastRemoteObject.unexportObject(impl, true);
                this._registered = false;
                this._persistit.getLogBase().rmiServerUnregister.log(this._registeredHostName);
            }
            catch (Exception exception) {
                this._persistit.getLogBase().rmiUnregisterException.log(this._registeredHostName, exception);
            }
        }
    }

    @Override
    public String launch(String commandLine) {
        try {
            Task task = CLI.parseTask(this._persistit, commandLine);
            if (task == null) {
                return "Invalid task " + commandLine;
            }
            if (task.isImmediate()) {
                task.runTask();
                task.setPersistit(null);
                return task.getStatusDetail();
            }
            return this.launch(task, commandLine);
        }
        catch (Exception ex) {
            return "Failed: " + ex.toString();
        }
    }

    @Override
    public Management.VolumeInfo volumeByName(String volumeName) throws RemoteException {
        return this.getVolumeInfo(volumeName);
    }

    @Override
    public synchronized String launch(Task task, String description) throws RemoteException {
        try {
            long taskId = this.taskId();
            task.setup(taskId, description, Thread.currentThread().getName(), 0L, 5);
            this._tasks.put(new Long(taskId), task);
            task.start();
            return Long.toString(taskId);
        }
        catch (Exception ex) {
            return "Failed: " + ex.toString();
        }
    }

    @Override
    public String execute(String commandLine) {
        try {
            Task task = CLI.parseTask(this._persistit, commandLine);
            if (task == null) {
                return "Invalid task " + commandLine;
            }
            task.runTask();
            task.setPersistit(null);
            return task.getStatusDetail();
        }
        catch (Exception ex) {
            return "Failed: " + ex.toString();
        }
    }

    public synchronized long taskId() {
        return ++this._taskIdCounter;
    }
}

