/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Volume;
import com.persistit.mxbeans.IOMeterMXBean;
import com.persistit.util.ArgParser;
import com.persistit.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class IOMeter
implements IOMeterMXBean {
    private static final int BUCKETS = 5;
    private static final long SECOND = 1000000000L;
    private static final long RECENT = 3000000000L;
    private static final long KILO = 1024L;
    private static final String DUMP_FORMAT = "time=%,12d op=%2s vol=%4s page=%,16d addr=%,16d size=%,8d index=%,7d";
    private static final int DUMP_RECORD_LENGTH = 37;
    private static final int DEFAULT_QUIESCENT_IO_THRESHOLD_KBYTES_PER_SEC = 100;
    private static final int MINIMUM_QUIESCENT_IO_THRESHOLD_KBYTES_PER_SEC = 0;
    private static final int MAXIMUM_QUIESCENT_IO_THRESHOLD_KBYTES_PER_SEC = 1000000;
    private static final int READ_PAGE_FROM_VOLUME = 1;
    private static final int READ_PAGE_FROM_JOURNAL = 2;
    private static final int COPY_PAGE_FROM_JOURNAL = 3;
    private static final int COPY_PAGE_TO_VOLUME = 4;
    private static final int WRITE_PAGE_TO_JOURNAL = 5;
    private static final int WRITE_TX_TO_JOURNAL = 6;
    private static final int WRITE_OTHER_TO_JOURNAL = 7;
    private static final int EVICT_PAGE_FROM_POOL = 8;
    private static final int FLUSH_JOURNAL = 9;
    private static final int GET_PAGE = 10;
    private static final int ITEM_COUNT = 11;
    private long _quiescentIOthreshold = 100L;
    private final AtomicReference<DataOutputStream> _logStream = new AtomicReference();
    private String _logFileName;
    private final Counter[][] _counters = new Counter[11][5];
    private final long[] _clockTimes = new long[5];
    private final AtomicLong[] _totalCounts = new AtomicLong[11];
    private final AtomicLong[] _totalSums = new AtomicLong[11];
    volatile int _currentBucket;

    IOMeter() {
        for (int item = 0; item < 11; ++item) {
            for (int bucket = 0; bucket < 5; ++bucket) {
                this._counters[item][bucket] = new Counter();
            }
            this._totalCounts[item] = new AtomicLong();
            this._totalSums[item] = new AtomicLong();
        }
        this._clockTimes[this._currentBucket] = System.nanoTime();
    }

    synchronized void poll() {
        int bucket = this._currentBucket;
        long now = System.nanoTime();
        if (now - this._clockTimes[bucket] > 1000000000L) {
            bucket = (bucket + 1) % 5;
            this._clockTimes[bucket] = now;
            for (int item = 0; item < 11; ++item) {
                this._totalCounts[item].addAndGet(this._counters[item][bucket].count());
                this._totalSums[item].addAndGet(this._counters[item][bucket].sum());
                this._counters[item][bucket].reset();
            }
            this._currentBucket = bucket;
        }
    }

    @Override
    public synchronized long getQuiescentIOthreshold() {
        return this._quiescentIOthreshold;
    }

    @Override
    public synchronized void setQuiescentIOthreshold(long quiescentIOthreshold) {
        this._quiescentIOthreshold = Util.rangeCheck(quiescentIOthreshold, 0L, 1000000L);
    }

    @Override
    public synchronized long getIoRate() {
        int bucket = this._currentBucket;
        int previousBucket = (bucket + 5 - 1) % 5;
        long interval = this._clockTimes[bucket] - this._clockTimes[previousBucket];
        if (interval < 1000000000L) {
            return 0L;
        }
        long sum = 0L;
        for (int item = 0; item < 11; ++item) {
            sum += this._counters[item][previousBucket].sum();
        }
        return sum * 1000000000L / interval / 1024L;
    }

    @Override
    public synchronized void setLogFile(String toFile) throws IOException {
        if (toFile == null || toFile.isEmpty()) {
            DataOutputStream dos = this._logStream.get();
            if (dos != null) {
                this._logStream.set(null);
                dos.close();
            }
        } else if (this._logStream.get() == null) {
            this._logStream.set(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(toFile))));
        }
        this._logFileName = toFile;
    }

    @Override
    public String getLogFile() {
        return this._logFileName;
    }

    private void charge(int size, int item) {
        int bucket = this._currentBucket;
        this._counters[item][bucket].charge(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int type, Volume volume, long pageAddress, int size, long journalAddress, int bufferIndex) {
        DataOutputStream os = this._logStream.get();
        if (os != null) {
            DataOutputStream dataOutputStream = os;
            synchronized (dataOutputStream) {
                try {
                    os.write((byte)type);
                    os.writeLong(System.currentTimeMillis());
                    os.writeInt(volume == null ? 0 : volume.getHandle());
                    os.writeLong(pageAddress);
                    os.writeInt(size);
                    os.writeLong(journalAddress);
                    os.writeInt(bufferIndex);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void dump(DataInputStream is, int count, boolean analyzePages) throws IOException {
        long start = 0L;
        HashMap events = new HashMap();
        for (int index = 0; index < count; ++index) {
            try {
                int op = is.read();
                if (op == -1) break;
                String opName = op >= 0 && op < OPERATIONS.length ? OPERATIONS[op] : "??";
                long time = is.readLong();
                int volumeHandle = is.readInt();
                long pageAddress = is.readLong();
                int size = is.readInt();
                long journalAddress = is.readLong();
                int bufferIndex = is.readInt();
                if (start == 0L) {
                    start = time;
                }
                System.out.printf(DUMP_FORMAT, time - start, opName, volumeHandle, pageAddress, journalAddress, size, bufferIndex);
                if (analyzePages && (op == 5 || op == 2 || op == 1 || op == 3 || op == 4 || op == 8)) {
                    long handle = (long)(volumeHandle << 48) + pageAddress;
                    ArrayList<Event> list = (ArrayList<Event>)events.get(handle);
                    if (list == null) {
                        list = new ArrayList<Event>(2);
                        events.put(handle, list);
                    }
                    for (Event e : list) {
                        System.out.printf("  %-35s", e.describe(time, index));
                    }
                    while (list.size() >= 2) {
                        list.remove(0);
                    }
                    list.add(new Event(time, index, op));
                }
                System.out.println();
                continue;
            }
            catch (EOFException e) {
                break;
            }
        }
    }

    public void chargeCopyPageFromJournal(Volume volume, long pageAddress, int size, long journalAddress, int urgency) {
        this.charge(size, 3);
        this.log(3, volume, pageAddress, size, journalAddress, 0);
    }

    public void chargeCopyPageToVolume(Volume volume, long pageAddress, int size, long journalAddress, int urgency) {
        this.charge(size, 4);
        this.log(4, volume, pageAddress, size, journalAddress, 0);
    }

    public void chargeReadPageFromVolume(Volume volume, long pageAddress, int size, int bufferIndex) {
        this.log(1, volume, pageAddress, size, -1L, bufferIndex);
        this.charge(size, 1);
    }

    public void chargeReadPageFromJournal(Volume volume, long pageAddress, int size, long journalAddress, int bufferIndex) {
        this.log(2, volume, pageAddress, size, journalAddress, bufferIndex);
        this.charge(size, 2);
    }

    public void chargeWritePageToJournal(Volume volume, long pageAddress, int size, long journalAddress, int urgency, int bufferIndex) {
        this.log(5, volume, pageAddress, size, journalAddress, bufferIndex);
        this.charge(size, 5);
    }

    public void chargeWriteTXtoJournal(int size, long journalAddress) {
        this.log(6, null, -1L, size, journalAddress, -1);
        this.charge(size, 6);
    }

    public void chargeWriteOtherToJournal(int size, long journalAddress) {
        this.log(7, null, -1L, size, journalAddress, -1);
        this.charge(size, 7);
    }

    public void chargeEvictPageFromPool(Volume volume, long pageAddress, int size, int bufferIndex) {
        this.log(8, volume, pageAddress, size, 0L, bufferIndex);
    }

    public void chargeFlushJournal(int size, long journalAddress) {
        this.log(9, null, -1L, size, journalAddress, -1);
        this.charge(size, 9);
    }

    public void chargeGetPage(Volume volume, long pageAddress, int size, int bufferIndex) {
        this.log(10, volume, pageAddress, size, 0L, bufferIndex);
    }

    @Override
    public long totalOperations(String opName) {
        return this.totalOperations(this.op(opName));
    }

    public long totalOperations(int op) {
        if (op > 0 && op < 11) {
            long count = this._totalCounts[op].get();
            for (int bucket = 0; bucket < 5; ++bucket) {
                count += this._counters[op][bucket].count();
            }
            return count;
        }
        return -1L;
    }

    @Override
    public long totalBytes(String opName) {
        return this.totalBytes(this.op(opName));
    }

    public long totalBytes(int op) {
        if (op > 0 && op < 11) {
            long sum = this._totalSums[op].get();
            for (int bucket = 0; bucket < 5; ++bucket) {
                sum += this._counters[op][bucket].sum();
            }
            return sum;
        }
        return -1L;
    }

    public int op(String opName) {
        for (int index = 1; index < 11; ++index) {
            if (!OPERATIONS[index].equalsIgnoreCase(opName)) continue;
            return index;
        }
        return -1;
    }

    synchronized long recentCharge() {
        int bucket;
        long now = System.nanoTime();
        long then = 0L;
        int current = this._currentBucket;
        long charge = 0L;
        for (int b = current + 5; b > current && this._clockTimes[bucket = b % 5] >= now - 3000000000L; --b) {
            for (int item = 0; item < 11; ++item) {
                if (item == 4) continue;
                charge += this._counters[item][bucket].sum();
            }
            then = this._clockTimes[bucket];
        }
        if (now - then <= 0L) {
            return -1L;
        }
        return charge * 1000000000L / (now - then);
    }

    public static void main(String[] args) throws Exception {
        ArgParser ap = new ArgParser("com.persistit.IOMeter", args, new String[]{"file||log file name", "skip|long:0:0:1000000000000|event skip count", "count|long:0:0:2000000000|event count nlimit", "_flag|a|Analyze page pattern"}).strict();
        String fileName = ap.getStringValue("file");
        long skip = ap.getLongValue("skip");
        int count = ap.getIntValue("count");
        if (fileName == null) {
            ap.usage();
        } else {
            IOMeter ioMeter = new IOMeter();
            DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            is.skip(skip * 37L);
            ioMeter.dump(is, count == 0 ? Integer.MAX_VALUE : count, ap.isFlag(97));
            is.close();
        }
    }

    private static class Event {
        long _time;
        int _count;
        int _op;

        Event(long time, int count, int op) {
            this._time = time;
            this._count = count;
            this._op = op;
        }

        private String describe(long time, int count) {
            String opName = this._op >= 0 && this._op < IOMeterMXBean.OPERATIONS.length ? IOMeterMXBean.OPERATIONS[this._op] : "??";
            return String.format("%s %,10dms %,8d events ago", opName, time - this._time, count - this._count);
        }
    }

    private static class Counter {
        AtomicLong _count = new AtomicLong();
        AtomicLong _sum = new AtomicLong();

        private Counter() {
        }

        void reset() {
            this._count.set(0L);
            this._sum.set(0L);
        }

        void charge(long size) {
            this._count.incrementAndGet();
            this._sum.addAndGet(size);
        }

        long sum() {
            return this._sum.get();
        }

        long count() {
            return this._count.get();
        }

        public String toString() {
            return String.format("(%d:%d)", this._count.get(), this._sum.get());
        }
    }
}

