/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonarsource.scanner.lib.Dirs;
import org.sonarsource.scanner.lib.internal.JreCacheHit;

public abstract class ScannerEngineFacade
implements AutoCloseable {
    private final Map<String, String> bootstrapProperties;
    private final boolean isSonarCloud;
    private final String serverVersion;
    private final boolean wasEngineCacheHit;
    private final JreCacheHit wasJreCacheHit;

    ScannerEngineFacade(Map<String, String> bootstrapProperties, boolean isSonarCloud, @Nullable String serverVersion, boolean wasEngineCacheHit, @Nullable JreCacheHit wasJreCacheHit) {
        this.bootstrapProperties = bootstrapProperties;
        this.isSonarCloud = isSonarCloud;
        this.serverVersion = serverVersion;
        this.wasEngineCacheHit = wasEngineCacheHit;
        this.wasJreCacheHit = wasJreCacheHit;
    }

    public String getServerVersion() {
        if (this.isSonarCloud) {
            throw new UnsupportedOperationException("Server version is not available for SonarCloud.");
        }
        return this.serverVersion;
    }

    public boolean isSonarCloud() {
        return this.isSonarCloud;
    }

    public boolean analyze(Map<String, String> analysisProps) {
        HashMap<String, String> allProps = new HashMap<String, String>();
        allProps.putAll(this.bootstrapProperties);
        allProps.putAll(analysisProps);
        ScannerEngineFacade.initAnalysisProperties(allProps);
        this.addStatsProperties(allProps);
        return this.doAnalyze(allProps);
    }

    private void addStatsProperties(Map<String, String> allProps) {
        if (this.wasJreCacheHit != null) {
            allProps.put("sonar.scanner.wasJreCacheHit", this.wasJreCacheHit.name());
        }
        allProps.put("sonar.scanner.wasEngineCacheHit", String.valueOf(this.wasEngineCacheHit));
    }

    abstract boolean doAnalyze(Map<String, String> var1);

    private static void initAnalysisProperties(Map<String, String> p) {
        new Dirs().init(p);
    }

    public Map<String, String> getBootstrapProperties() {
        return this.bootstrapProperties;
    }
}

