/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

public final class EscapeUtils {
    private EscapeUtils() {
    }

    public static String unescape(String value) {
        StringBuilder result = new StringBuilder();
        StringBuilder escapeSequence = new StringBuilder(4);
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                if ((ch = value.charAt(++i)) == 'u') {
                    i = EscapeUtils.consumeEscapeSequence(i, 4, value, escapeSequence, result);
                    continue;
                }
                if (ch == 'x') {
                    i = EscapeUtils.consumeEscapeSequence(i, 2, value, escapeSequence, result);
                    continue;
                }
                result.append(EscapeUtils.unescape(ch));
                ++i;
                continue;
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    private static int consumeEscapeSequence(int i, int len, String value, StringBuilder escapeSequence, StringBuilder result) {
        int ii = i;
        while (escapeSequence.length() != len && ii < value.length()) {
            escapeSequence.append(value.charAt(++ii));
        }
        if (escapeSequence.length() == len) {
            result.append((char)Integer.parseInt(escapeSequence.toString(), 16));
            escapeSequence.setLength(0);
        }
        return ++ii;
    }

    private static char unescape(char ch) {
        char result;
        switch (ch) {
            case 'b': {
                result = '\b';
                break;
            }
            case 't': {
                result = '\t';
                break;
            }
            case 'n': {
                result = '\n';
                break;
            }
            case 'v': {
                result = '\u000b';
                break;
            }
            case 'f': {
                result = '\f';
                break;
            }
            case 'r': {
                result = '\r';
                break;
            }
            case '\"': {
                result = '\"';
                break;
            }
            case '\'': {
                result = '\'';
                break;
            }
            case '\\': {
                result = '\\';
                break;
            }
            default: {
                result = ch;
            }
        }
        return result;
    }
}

