/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.TypeParameters;

@Rule(key="S4977")
public class TypeParametersShadowingCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String ISSUE_MESSAGE = "Rename \"%s\" which hides a type parameter from the outer scope.";
    private JavaFileScannerContext context;
    private Map<String, IdentifierTree> currentTypeParametersInScope;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.currentTypeParametersInScope = new HashMap<String, IdentifierTree>();
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.processTree(tree, tree.typeParameters(), tree.symbol().isStatic(), x$0 -> super.visitClass((ClassTree)x$0));
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.processTree(tree, tree.typeParameters(), tree.symbol().isStatic(), x$0 -> super.visitMethod((MethodTree)x$0));
    }

    private <T> void processTree(T tree, TypeParameters typeParameters, boolean isStatic, Consumer<T> visitTree) {
        Map<String, IdentifierTree> oldScope = this.currentTypeParametersInScope;
        if (isStatic) {
            this.currentTypeParametersInScope = new HashMap<String, IdentifierTree>();
        }
        Map<String, IdentifierTree> declaredTypeParameters = this.processAndGetTypeParameters(typeParameters);
        this.currentTypeParametersInScope.putAll(declaredTypeParameters);
        visitTree.accept(tree);
        declaredTypeParameters.forEach(this.currentTypeParametersInScope::remove);
        if (isStatic) {
            this.currentTypeParametersInScope = oldScope;
        }
    }

    private Map<String, IdentifierTree> processAndGetTypeParameters(TypeParameters typeParameters) {
        HashMap<String, IdentifierTree> declaredTypeParameters = new HashMap<String, IdentifierTree>();
        typeParameters.forEach(typeParameter -> {
            IdentifierTree id = typeParameter.identifier();
            String name = id.toString();
            IdentifierTree shadowedId = this.currentTypeParametersInScope.get(name);
            if (shadowedId != null) {
                this.context.reportIssue(this, id, String.format(ISSUE_MESSAGE, name), Collections.singletonList(new JavaFileScannerContext.Location("Shadowed type parameter", shadowedId)), null);
            } else {
                declaredTypeParameters.put(name, id);
            }
        });
        return declaredTypeParameters;
    }
}

