/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1217")
public class ThreadRunCheck
extends AbstractMethodDetection {
    private static final MethodMatchers THREAD_RUN_METHOD_MATCHER = MethodMatchers.create().ofSubTypes("java.lang.Thread").names("run").withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return THREAD_RUN_METHOD_MATCHER;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(Tree.Kind.METHOD); parent = parent.parent()) {
        }
        if (parent != null && THREAD_RUN_METHOD_MATCHER.matches((MethodTree)parent)) {
            return;
        }
        this.reportIssue(ExpressionUtils.methodName(mit), "Call the method Thread.start() to execute the content of the run() method in a dedicated thread.");
    }
}

