/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1479")
public class SwitchWithTooManyCasesCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM_CASES = 30;
    @RuleProperty(key="maximum", description="Maximum number of case", defaultValue="30")
    public int maximumCases = 30;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SWITCH_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        SwitchTree switchTree = (SwitchTree)tree;
        if (SwitchWithTooManyCasesCheck.isSwitchOverEnum(switchTree)) {
            return;
        }
        List<CaseGroupTree> cases = switchTree.cases();
        int size = cases.size();
        if (size > this.maximumCases) {
            ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>();
            for (CaseGroupTree element : cases) {
                secondary.add(new JavaFileScannerContext.Location("+1", element.labels().get(0)));
            }
            this.reportIssue(switchTree.switchKeyword(), String.format("Reduce the number of non-empty switch cases from %d to at most %d.", size, this.maximumCases), secondary, null);
        }
    }

    private static boolean isSwitchOverEnum(SwitchTree switchStatementTree) {
        Type type = switchStatementTree.expression().symbolType();
        return type.symbol().isEnum();
    }
}

