/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S1143")
public class ReturnInFinallyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Deque<Tree.Kind> treeKindStack = new LinkedList<Tree.Kind>();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.treeKindStack.clear();
        this.scan(context.getTree());
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resourceList());
        this.scan(tree.block());
        this.scan(tree.catches());
        BlockTree finallyBlock = tree.finallyBlock();
        if (finallyBlock != null) {
            this.treeKindStack.push(finallyBlock.kind());
            this.scan(finallyBlock);
            this.treeKindStack.pop();
        }
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.treeKindStack.push(tree.kind());
        super.visitMethod(tree);
        this.treeKindStack.pop();
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.treeKindStack.push(tree.kind());
        super.visitForStatement(tree);
        this.treeKindStack.pop();
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.treeKindStack.push(tree.kind());
        super.visitForEachStatement(tree);
        this.treeKindStack.pop();
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.treeKindStack.push(tree.kind());
        super.visitWhileStatement(tree);
        this.treeKindStack.pop();
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.treeKindStack.push(tree.kind());
        super.visitDoWhileStatement(tree);
        this.treeKindStack.pop();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.treeKindStack.push(tree.kind());
        super.visitSwitchStatement(tree);
        this.treeKindStack.pop();
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.reportIssue(tree.returnKeyword(), tree.kind());
        super.visitReturnStatement(tree);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.reportIssue(tree.throwKeyword(), tree.kind());
        super.visitThrowStatement(tree);
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.reportIssue(tree.continueKeyword(), tree.kind());
        super.visitContinueStatement(tree);
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.reportIssue(tree.breakKeyword(), tree.kind());
        super.visitBreakStatement(tree);
    }

    private void reportIssue(SyntaxToken syntaxToken, Tree.Kind jumpKind) {
        if (this.isAbruptFinallyBlock(jumpKind)) {
            this.context.reportIssue(this, syntaxToken, "Remove this " + syntaxToken.text() + " statement from this finally block.");
        }
    }

    private boolean isAbruptFinallyBlock(Tree.Kind jumpKind) {
        if (this.treeKindStack.isEmpty()) {
            return false;
        }
        Tree.Kind blockKind = this.treeKindStack.peek();
        switch (blockKind) {
            case BLOCK: {
                return true;
            }
            case FOR_STATEMENT: 
            case FOR_EACH_STATEMENT: 
            case WHILE_STATEMENT: 
            case DO_STATEMENT: 
            case SWITCH_STATEMENT: {
                return this.handleControlFlowInFinally(jumpKind);
            }
        }
        return false;
    }

    private boolean handleControlFlowInFinally(Tree.Kind jumpKind) {
        if (jumpKind == Tree.Kind.BREAK_STATEMENT || jumpKind == Tree.Kind.CONTINUE_STATEMENT) {
            return false;
        }
        Tree.Kind parentOfControlFlowStatement = this.treeKindStack.stream().filter(t -> t == Tree.Kind.BLOCK || t == Tree.Kind.METHOD).findFirst().orElse(Tree.Kind.METHOD);
        return parentOfControlFlowStatement == Tree.Kind.BLOCK;
    }
}

