/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2131")
public class PrimitiveTypeBoxingWithToStringCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatchers TO_STRING_MATCHERS = MethodMatchers.create().ofSubTypes("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean").names("toString").addWithoutParametersMatcher().build();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree abstractTypedTree;
        if (TO_STRING_MATCHERS.matches(tree) && ((abstractTypedTree = ((MemberSelectExpressionTree)tree.methodSelect()).expression()).is(Tree.Kind.NEW_CLASS) || PrimitiveTypeBoxingWithToStringCheck.isValueOfInvocation(abstractTypedTree))) {
            String typeName = abstractTypedTree.symbolType().toString();
            this.createIssue(tree, typeName);
        }
        super.visitMethodInvocation(tree);
    }

    private void createIssue(Tree reportingTree, String wrapperName) {
        this.context.reportIssue(this, reportingTree, "Use \"" + wrapperName + ".toString\" instead.");
    }

    @Override
    public void visitAnnotation(AnnotationTree annotationTree) {
        this.scan(annotationTree.annotationType());
    }

    private static boolean isValueOfInvocation(ExpressionTree abstractTypedTree) {
        if (!abstractTypedTree.is(Tree.Kind.METHOD_INVOCATION)) {
            return false;
        }
        Type type = abstractTypedTree.symbolType();
        MethodMatchers valueOfMatcher = MethodMatchers.create().ofTypes(type.fullyQualifiedName()).names("valueOf").addParametersMatcher(JUtils.primitiveType(type).fullyQualifiedName()).build();
        return valueOfMatcher.matches((MethodInvocationTree)abstractTypedTree);
    }
}

