/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2111")
public class BigDecimalDoubleConstructorCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers BIG_DECIMAL_DOUBLE_FLOAT = MethodMatchers.create().ofTypes("java.math.BigDecimal").constructor().addParametersMatcher("double").addParametersMatcher("float").addParametersMatcher("double", "*").addParametersMatcher("float", "*").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        if (BIG_DECIMAL_DOUBLE_FLOAT.matches((NewClassTree)tree)) {
            this.reportIssue(tree, "Use \"BigDecimal.valueOf\" instead.");
        }
    }
}

