/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class SurefireUtils {
    private static final Logger LOGGER = Loggers.get(SurefireUtils.class);
    @Deprecated
    public static final String SUREFIRE_REPORTS_PATH_PROPERTY = "sonar.junit.reportsPath";
    public static final String SUREFIRE_REPORT_PATHS_PROPERTY = "sonar.junit.reportPaths";

    private SurefireUtils() {
    }

    public static List<File> getReportsDirectories(Settings settings, FileSystem fs, PathResolver pathResolver) {
        File dir = SurefireUtils.getReportsDirectoryFromDeprecatedProperty(settings, fs, pathResolver);
        List<File> dirs = SurefireUtils.getReportsDirectoriesFromProperty(settings, fs, pathResolver);
        if (dirs != null) {
            if (dir != null) {
                LOGGER.info("Property '{}' is deprecated and will be ignored, as property '{}' is also set.", (Object)SUREFIRE_REPORTS_PATH_PROPERTY, (Object)SUREFIRE_REPORT_PATHS_PROPERTY);
            }
            return dirs;
        }
        if (dir != null) {
            return Collections.singletonList(dir);
        }
        return Collections.singletonList(new File(fs.baseDir(), "target/surefire-reports"));
    }

    @CheckForNull
    private static List<File> getReportsDirectoriesFromProperty(Settings settings, FileSystem fs, PathResolver pathResolver) {
        String paths;
        if (settings.hasKey(SUREFIRE_REPORT_PATHS_PROPERTY) && (paths = settings.getString(SUREFIRE_REPORT_PATHS_PROPERTY)) != null) {
            return Arrays.stream(paths.split(",")).map(String::trim).map(path -> SurefireUtils.getFileFromPath(fs, pathResolver, path)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    @CheckForNull
    private static File getReportsDirectoryFromDeprecatedProperty(Settings settings, FileSystem fs, PathResolver pathResolver) {
        if (settings.hasKey(SUREFIRE_REPORTS_PATH_PROPERTY)) {
            LOGGER.info("Property '{}' is deprecated. Use property '{}' instead.", (Object)SUREFIRE_REPORTS_PATH_PROPERTY, (Object)SUREFIRE_REPORT_PATHS_PROPERTY);
            String path = settings.getString(SUREFIRE_REPORTS_PATH_PROPERTY);
            if (path != null) {
                return SurefireUtils.getFileFromPath(fs, pathResolver, path);
            }
        }
        return null;
    }

    @CheckForNull
    private static File getFileFromPath(FileSystem fs, PathResolver pathResolver, String path) {
        try {
            return pathResolver.relativeFile(fs.baseDir(), path);
        }
        catch (Exception e) {
            LOGGER.info("Surefire report path: {}/{} not found.", (Object)fs.baseDir(), (Object)path);
            return null;
        }
    }
}

