/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.api.test.MutableTestPlan;
import org.sonar.api.test.TestCase;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.surefire.data.SurefireStaxHandler;
import org.sonar.plugins.surefire.data.UnitTestClassReport;
import org.sonar.plugins.surefire.data.UnitTestIndex;
import org.sonar.plugins.surefire.data.UnitTestResult;

public class SurefireJavaParser
implements BatchExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SurefireJavaParser.class);
    private final ResourcePerspectives perspectives;
    private final JavaResourceLocator javaResourceLocator;

    public SurefireJavaParser(ResourcePerspectives perspectives, JavaResourceLocator javaResourceLocator) {
        this.perspectives = perspectives;
        this.javaResourceLocator = javaResourceLocator;
    }

    public void collect(SensorContext context, File reportsDir) {
        File[] xmlFiles = this.getReports(reportsDir);
        if (xmlFiles.length > 0) {
            this.parseFiles(context, xmlFiles);
        }
    }

    private File[] getReports(File dir) {
        if (dir == null) {
            return new File[0];
        }
        if (!dir.isDirectory()) {
            LOGGER.error("Reports path not found or is not a directory: " + dir.getAbsolutePath());
            return new File[0];
        }
        File[] unitTestResultFiles = this.findXMLFilesStartingWith(dir, "TEST-");
        if (unitTestResultFiles.length == 0) {
            unitTestResultFiles = this.findXMLFilesStartingWith(dir, "TESTS-");
        }
        if (unitTestResultFiles.length == 0) {
            LOGGER.warn("Reports path contains no files matching TEST-.*.xml : " + dir.getAbsolutePath());
        }
        return unitTestResultFiles;
    }

    private File[] findXMLFilesStartingWith(File dir, final String fileNameStart) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileNameStart) && name.endsWith(".xml");
            }
        });
    }

    private void parseFiles(SensorContext context, File[] reports) {
        UnitTestIndex index = new UnitTestIndex();
        SurefireJavaParser.parseFiles(reports, index);
        SurefireJavaParser.sanitize(index);
        this.save(index, context);
    }

    private static void parseFiles(File[] reports, UnitTestIndex index) {
        SurefireStaxHandler staxParser = new SurefireStaxHandler(index);
        StaxParser parser = new StaxParser((StaxParser.XmlStreamHandler)staxParser, false);
        for (File report : reports) {
            try {
                parser.parse(report);
            }
            catch (XMLStreamException e) {
                throw new SonarException("Fail to parse the Surefire report: " + report, (Throwable)e);
            }
        }
    }

    private static void sanitize(UnitTestIndex index) {
        for (String classname : index.getClassnames()) {
            if (!StringUtils.contains((String)classname, (String)"$")) continue;
            String parentClassName = StringUtils.substringBefore((String)classname, (String)"$");
            index.merge(classname, parentClassName);
        }
    }

    private void save(UnitTestIndex index, SensorContext context) {
        long negativeTimeTestNumber = 0L;
        for (Map.Entry<String, UnitTestClassReport> entry : index.getIndexByClassname().entrySet()) {
            UnitTestClassReport report = entry.getValue();
            if (report.getTests() <= 0L) continue;
            negativeTimeTestNumber += report.getNegativeTimeTestNumber();
            Resource resource = this.getUnitTestResource(entry.getKey());
            if (resource != null) {
                this.save(report, resource, context);
                continue;
            }
            LOGGER.warn("Resource not found: {}", (Object)entry.getKey());
        }
        if (negativeTimeTestNumber > 0L) {
            LOGGER.warn("There is {} test(s) reported with negative time by surefire, total duration may not be accurate.", (Object)negativeTimeTestNumber);
        }
    }

    private void save(UnitTestClassReport report, Resource resource, SensorContext context) {
        double testsCount = report.getTests() - report.getSkipped();
        SurefireJavaParser.saveMeasure(context, resource, CoreMetrics.SKIPPED_TESTS, report.getSkipped());
        SurefireJavaParser.saveMeasure(context, resource, CoreMetrics.TESTS, testsCount);
        SurefireJavaParser.saveMeasure(context, resource, CoreMetrics.TEST_ERRORS, report.getErrors());
        SurefireJavaParser.saveMeasure(context, resource, CoreMetrics.TEST_FAILURES, report.getFailures());
        SurefireJavaParser.saveMeasure(context, resource, CoreMetrics.TEST_EXECUTION_TIME, report.getDurationMilliseconds());
        double passedTests = testsCount - (double)report.getErrors() - (double)report.getFailures();
        if (testsCount > 0.0) {
            double percentage = passedTests * 100.0 / testsCount;
            SurefireJavaParser.saveMeasure(context, resource, CoreMetrics.TEST_SUCCESS_DENSITY, ParsingUtils.scaleValue((double)percentage));
        }
        this.saveResults(resource, report);
    }

    protected void saveResults(Resource testFile, UnitTestClassReport report) {
        for (UnitTestResult unitTestResult : report.getResults()) {
            MutableTestPlan testPlan = (MutableTestPlan)this.perspectives.as(MutableTestPlan.class, testFile);
            if (testPlan == null) continue;
            testPlan.addTestCase(unitTestResult.getName()).setDurationInMs(Long.valueOf(Math.max(unitTestResult.getDurationMilliseconds(), 0L))).setStatus(TestCase.Status.of((String)unitTestResult.getStatus())).setMessage(unitTestResult.getMessage()).setType("UNIT").setStackTrace(unitTestResult.getStackTrace());
        }
    }

    protected Resource getUnitTestResource(String classKey) {
        return this.javaResourceLocator.findResourceByClassName(classKey);
    }

    private static void saveMeasure(SensorContext context, Resource resource, Metric metric, double value) {
        if (!Double.isNaN(value)) {
            context.saveMeasure(resource, metric, Double.valueOf(value));
        }
    }
}

