/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;

public class SmapFile {
    private static final Pattern LINE_INFO = Pattern.compile("(?<inputStartLine>\\d+)(?:#(?<lineFileId>\\d+))?(?:,(?<repeatCount>\\d+))?:(?<outputStartLine>\\d+)(?:,(?<outputIncrement>\\d+))?");
    private static final Logger LOG = LoggerFactory.getLogger(SmapFile.class);
    private final Path generatedFile;
    private final Map<Integer, FileInfo> fileSection;
    private final List<LineInfo> lineSection;
    private final Scanner sc;

    public SmapFile(Path rootDir, String smapString, Path uriRoot, FileSystem fileSystem) {
        this.sc = new Scanner(smapString);
        String header = this.sc.nextLine();
        if (!"SMAP".equals(header)) {
            throw new IllegalStateException("Not a source map");
        }
        String generatedFileName = this.sc.nextLine();
        this.generatedFile = rootDir.resolve(generatedFileName);
        String defaultStratum = this.sc.nextLine();
        if (!"JSP".equals(defaultStratum)) {
            throw new IllegalStateException("Not a JSP source map");
        }
        this.findSection("*S JSP");
        this.findSection("*F");
        this.fileSection = this.readFileSection(uriRoot, fileSystem);
        this.findSection("*L");
        this.lineSection = this.readLineSection();
    }

    public Path getGeneratedFile() {
        return this.generatedFile;
    }

    Map<Integer, FileInfo> getFileSection() {
        return this.fileSection;
    }

    List<LineInfo> getLineSection() {
        return this.lineSection;
    }

    private List<LineInfo> readLineSection() {
        ArrayList<LineInfo> result = new ArrayList<LineInfo>();
        int lineFileId = 0;
        while (this.sc.hasNext() && !this.sc.hasNext("\\*.")) {
            String line = this.sc.nextLine();
            Matcher matcher = LINE_INFO.matcher(line);
            if (matcher.matches()) {
                String repeatCountGroup;
                int inputStartLine = Integer.parseInt(matcher.group("inputStartLine"));
                String lineFileIdGroup = matcher.group("lineFileId");
                if (lineFileIdGroup != null) {
                    lineFileId = Integer.parseInt(lineFileIdGroup);
                }
                int repeatCount = (repeatCountGroup = matcher.group("repeatCount")) != null ? Integer.parseInt(repeatCountGroup) : 1;
                int outputStartLine = Integer.parseInt(matcher.group("outputStartLine"));
                String outputIncrementGroup = matcher.group("outputIncrement");
                int outputIncrement = outputIncrementGroup != null ? Integer.parseInt(outputIncrementGroup) : 1;
                result.add(new LineInfo(inputStartLine, lineFileId, repeatCount, outputStartLine, outputIncrement));
                continue;
            }
            LOG.warn("Invalid line info {}", (Object)line);
        }
        return result;
    }

    private void findSection(String section) {
        while (this.sc.hasNextLine()) {
            if (!section.equals(this.sc.nextLine())) continue;
            return;
        }
        throw new IllegalStateException("Section " + section + " not found");
    }

    private Map<Integer, FileInfo> readFileSection(Path uriRoot, FileSystem fileSystem) {
        HashMap<Integer, FileInfo> result = new HashMap<Integer, FileInfo>();
        while (this.sc.hasNext() && !this.sc.hasNext("\\*.")) {
            String file;
            int fileId;
            if (this.sc.hasNext("\\+")) {
                this.sc.next();
                fileId = this.sc.nextInt();
                file = this.sc.next();
                this.sc.nextLine();
                String path = this.sc.nextLine();
                InputFile inputFile = SmapFile.findFileWithPath(uriRoot.resolve(path), fileSystem);
                result.put(fileId, new FileInfo(fileId, file, path, inputFile));
                continue;
            }
            fileId = this.sc.nextInt();
            file = this.sc.next();
            InputFile inputFile = SmapFile.findFileWithPath(uriRoot.resolve(file), fileSystem);
            result.put(fileId, new FileInfo(fileId, file, null, inputFile));
        }
        return result;
    }

    @CheckForNull
    private static InputFile findFileWithPath(Path path, FileSystem fileSystem) {
        FilePredicates predicates = fileSystem.predicates();
        return fileSystem.inputFile(predicates.hasPath(path.toString()));
    }

    public String toString() {
        return this.generatedFile.toString();
    }

    Optional<InputFile> getInputFile(int fileId) {
        return Optional.ofNullable(this.fileSection.get(fileId)).map(info -> info.inputFile);
    }

    static class LineInfo {
        final int inputStartLine;
        final int lineFileId;
        final int repeatCount;
        final int outputStartLine;
        final int outputLineIncrement;

        LineInfo(int inputStartLine, int lineFileId, int repeatCount, int outputStartLine, int outputLineIncrement) {
            this.inputStartLine = inputStartLine;
            this.lineFileId = lineFileId;
            this.repeatCount = repeatCount;
            this.outputStartLine = outputStartLine;
            this.outputLineIncrement = outputLineIncrement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineInfo lineInfo = (LineInfo)o;
            return this.inputStartLine == lineInfo.inputStartLine && this.lineFileId == lineInfo.lineFileId && this.repeatCount == lineInfo.repeatCount && this.outputStartLine == lineInfo.outputStartLine && this.outputLineIncrement == lineInfo.outputLineIncrement;
        }

        public int hashCode() {
            return Objects.hash(this.inputStartLine, this.lineFileId, this.repeatCount, this.outputStartLine, this.outputLineIncrement);
        }

        public String toString() {
            return "LineInfo{inputStartLine=" + this.inputStartLine + ", lineFileId=" + this.lineFileId + ", repeatCount=" + this.repeatCount + ", outputStartLine=" + this.outputStartLine + ", outputLineIncrement=" + this.outputLineIncrement + "}";
        }
    }

    static class FileInfo {
        final int fileId;
        final String sourceName;
        final String sourcePath;
        final InputFile inputFile;

        FileInfo(int fileId, String sourceName, @Nullable String sourcePath, @Nullable InputFile inputFile) {
            this.fileId = fileId;
            this.sourceName = sourceName;
            this.sourcePath = sourcePath;
            this.inputFile = inputFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            return this.fileId == fileInfo.fileId && Objects.equals(this.sourceName, fileInfo.sourceName) && Objects.equals(this.sourcePath, fileInfo.sourcePath);
        }

        public int hashCode() {
            return Objects.hash(this.fileId, this.sourceName, this.sourcePath);
        }

        public String toString() {
            return "FileInfo{fileId=" + this.fileId + ", sourceName='" + this.sourceName + "', sourcePath='" + this.sourcePath + "'}";
        }
    }
}

