/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.java.Measurer;
import org.sonar.java.PerformanceMeasure;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.FileLinesVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.ast.visitors.SyntaxHighlighterVisitor;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.api.JavaVersion;

public class JavaSquid {
    private static final Logger LOG = Loggers.get(JavaSquid.class);
    private final JavaAstScanner astScanner;
    private final JavaAstScanner astScannerForTests;
    private final JavaAstScanner astScannerForGeneratedFiles;

    public JavaSquid(JavaVersion javaVersion, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, @Nullable SonarJavaIssueFilter postAnalysisIssueFilter, JavaCheck ... visitors) {
        this(javaVersion, sonarComponents, measurer, javaResourceLocator, postAnalysisIssueFilter, null, visitors);
    }

    public JavaSquid(JavaVersion javaVersion, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, @Nullable SonarJavaIssueFilter postAnalysisIssueFilter, @Nullable SubscriptionVisitor symbolicExecutionEngine, JavaCheck ... visitors) {
        ArrayList<JavaCheck> commonVisitors = new ArrayList<JavaCheck>();
        commonVisitors.add(javaResourceLocator);
        if (postAnalysisIssueFilter != null) {
            commonVisitors.add(postAnalysisIssueFilter);
        }
        List<Object> seVisitor = symbolicExecutionEngine == null ? Collections.emptyList() : Collections.singletonList(symbolicExecutionEngine);
        List<JavaCheck> codeVisitors = ListUtils.concat(new List[]{seVisitor, commonVisitors, Arrays.asList(visitors)});
        ArrayList<JavaCheck> testCodeVisitors = new ArrayList<JavaCheck>(commonVisitors);
        if (measurer != null) {
            List<Measurer> measurers = Collections.singletonList(measurer);
            codeVisitors = ListUtils.concat(new Iterable[]{measurers, codeVisitors});
            testCodeVisitors.add(measurer.new Measurer.TestFileMeasurer());
        }
        ArrayList<File> classpath = new ArrayList();
        ArrayList<File> testClasspath = new ArrayList();
        ArrayList<JavaCheck> jspCodeVisitors = new ArrayList();
        ArrayList<File> jspClasspath = new ArrayList();
        if (sonarComponents != null) {
            if (!sonarComponents.isSonarLintContext()) {
                codeVisitors = ListUtils.concat(new Iterable[]{codeVisitors, Arrays.asList(new FileLinesVisitor(sonarComponents), new SyntaxHighlighterVisitor(sonarComponents))});
                testCodeVisitors.add(new SyntaxHighlighterVisitor(sonarComponents));
            }
            classpath = sonarComponents.getJavaClasspath();
            testClasspath = sonarComponents.getJavaTestClasspath();
            jspClasspath = sonarComponents.getJspClasspath();
            testCodeVisitors.addAll(sonarComponents.testCheckClasses());
            jspCodeVisitors = sonarComponents.jspCodeVisitors();
        }
        this.astScanner = new JavaAstScanner(sonarComponents);
        this.astScanner.setVisitorBridge(JavaSquid.createVisitorBridge(codeVisitors, classpath, javaVersion, sonarComponents));
        this.astScannerForTests = new JavaAstScanner(sonarComponents);
        this.astScannerForTests.setVisitorBridge(JavaSquid.createVisitorBridge(testCodeVisitors, testClasspath, javaVersion, sonarComponents));
        this.astScannerForGeneratedFiles = new JavaAstScanner(sonarComponents);
        this.astScannerForGeneratedFiles.setVisitorBridge(JavaSquid.createVisitorBridge(jspCodeVisitors, jspClasspath, javaVersion, sonarComponents));
    }

    private static VisitorsBridge createVisitorBridge(Iterable<JavaCheck> codeVisitors, List<File> classpath, JavaVersion javaVersion, @Nullable SonarComponents sonarComponents) {
        VisitorsBridge visitorsBridge = new VisitorsBridge(codeVisitors, classpath, sonarComponents);
        visitorsBridge.setJavaVersion(javaVersion);
        return visitorsBridge;
    }

    public void scan(Iterable<InputFile> sourceFiles, Iterable<InputFile> testFiles, Iterable<? extends InputFile> generatedFiles) {
        PerformanceMeasure.Duration mainDuration = PerformanceMeasure.start("Main");
        this.scanSources(sourceFiles);
        mainDuration.stop();
        PerformanceMeasure.Duration testDuration = PerformanceMeasure.start("Test");
        this.scanTests(testFiles);
        testDuration.stop();
        PerformanceMeasure.Duration generatedDuration = PerformanceMeasure.start("Generated");
        this.scanGeneratedFiles(generatedFiles);
        generatedDuration.stop();
    }

    private void scanSources(Iterable<InputFile> sourceFiles) {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Java Main Files AST scan");
        this.astScanner.scan(sourceFiles);
        profiler.stopInfo();
    }

    private void scanTests(Iterable<InputFile> testFiles) {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Java Test Files AST scan");
        this.astScannerForTests.scan(testFiles);
        profiler.stopInfo();
    }

    private void scanGeneratedFiles(Iterable<? extends InputFile> generatedFiles) {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Java Generated Files AST scan");
        this.astScannerForGeneratedFiles.scan(generatedFiles);
        profiler.stopInfo();
    }
}

