/*
 * SonarQube Java
 * Copyright (C) 2012-2020 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.plugins.java.api.tree;

import com.google.common.annotations.Beta;

import javax.annotation.Nullable;

/**
 * The 'exports' directive from java 9 module directives
 *
 * JLS9 - §7.7.2
 *
 * <pre>
 *   exports {@link #packageName()} ;
 *   exports {@link #packageName()} to {@link #moduleNames()} ;
 * </pre>
 *
 * @since Java 9
 */
@Beta
public interface ExportsDirectiveTree extends ModuleDirectiveTree {

  ExpressionTree packageName();

  @Nullable
  SyntaxToken toKeyword();

  ListTree<ModuleNameTree> moduleNames();

}
