/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.Lists;
import java.util.Objects;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class LabeledStatementTreeImpl
extends JavaTree
implements LabeledStatementTree {
    private final IdentifierTree label;
    private final InternalSyntaxToken colonToken;
    private final StatementTree statement;
    private Symbol.LabelSymbol symbol;

    public LabeledStatementTreeImpl(IdentifierTree label, InternalSyntaxToken colonToken, StatementTree statement) {
        super(Tree.Kind.LABELED_STATEMENT);
        this.label = Objects.requireNonNull(label);
        this.colonToken = colonToken;
        this.statement = Objects.requireNonNull(statement);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.LABELED_STATEMENT;
    }

    @Override
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public Symbol.LabelSymbol symbol() {
        return this.symbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitLabeledStatement(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Lists.newArrayList((Object[])new Tree[]{this.label, this.colonToken, this.statement});
    }

    public void setSymbol(JavaSymbol.JavaLabelSymbol symbol) {
        this.symbol = symbol;
    }
}

