/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractPackageInfoChecker;
import org.sonar.plugins.java.api.InputFileScannerContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.ModuleScannerContext;

@Rule(key="S4032")
public class UselessPackageInfoCheck
extends AbstractPackageInfoChecker {
    private final Map<String, InputFileScannerContext> unneededPackageInfoFiles = new HashMap<String, InputFileScannerContext>();
    private final Set<String> knownPackagesWithOtherFiles = new HashSet<String>();

    @Override
    protected void processFile(InputFileScannerContext context, String packageName) {
        File packageInfoFile;
        boolean hasOtherFiles;
        if (this.knownPackagesWithOtherFiles.contains(packageName)) {
            return;
        }
        File packageDirectory = context.getInputFile().file().getParentFile();
        boolean bl = hasOtherFiles = !UselessPackageInfoCheck.isOnlyFileFromPackage(packageDirectory, packageInfoFile = new File(packageDirectory, "package-info.java"));
        if (hasOtherFiles) {
            this.knownPackagesWithOtherFiles.add(packageName);
        } else if (packageInfoFile.isFile()) {
            this.unneededPackageInfoFiles.put(packageName, context);
        }
    }

    public void endOfAnalysis(ModuleScannerContext context) {
        this.unneededPackageInfoFiles.keySet().removeAll(this.knownPackagesWithOtherFiles);
        for (InputFileScannerContext uselessPackageInfoFileContext : this.unneededPackageInfoFiles.values()) {
            uselessPackageInfoFileContext.addIssueOnFile((JavaCheck)this, "Remove this package.");
        }
        this.unneededPackageInfoFiles.clear();
        this.knownPackagesWithOtherFiles.clear();
    }

    private static boolean isOnlyFileFromPackage(File packageDirectory, File file) {
        File[] filesInPackage = packageDirectory.listFiles(f -> !f.equals(file));
        return filesInPackage != null && filesInPackage.length == 0;
    }
}

