/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S2737")
public class CatchRethrowingCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        CatchTree catchTree;
        TryStatementTree tst = (TryStatementTree)tree;
        if (tst.catches().size() == 1 && CatchRethrowingCheck.onlyRethrows(catchTree = (CatchTree)tst.catches().get(0))) {
            this.reportIssue((Tree)catchTree.block().body().get(0), "Add logic to this catch clause or eliminate it and rethrow the exception automatically.");
        }
    }

    private static boolean onlyRethrows(CatchTree catchTree) {
        List catchBody = catchTree.block().body();
        if (catchBody.size() == 1) {
            return ((StatementTree)catchBody.get(0)).is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT}) && catchTree.parameter().symbol().usages().contains(((ThrowStatementTree)catchBody.get(0)).expression());
        }
        return false;
    }
}

