/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AnyRuleIssueFilter
extends BaseTreeVisitor
implements JavaIssueFilter {
    private String componentKey;
    private final Set<Integer> excludedLines = new HashSet<Integer>();

    public void scanFile(JavaFileScannerContext context) {
        this.componentKey = context.getInputFile().key();
        this.excludedLines.clear();
        this.scan((Tree)context.getTree());
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        return !issue.componentKey().equals(this.componentKey) || !this.excludedLines.contains(issue.line());
    }

    @Override
    public final Set<Class<? extends JavaCheck>> filteredRules() {
        return Collections.emptySet();
    }

    public void excludeLines(Tree tree) {
        this.excludedLines.addAll(AnyRuleIssueFilter.filteredLines(tree));
    }

    private static Set<Integer> filteredLines(Tree tree) {
        SyntaxToken firstSyntaxToken = tree.firstToken();
        SyntaxToken lastSyntaxToken = tree.lastToken();
        if (firstSyntaxToken != null && lastSyntaxToken != null) {
            int startLine = firstSyntaxToken.line();
            int endLine = lastSyntaxToken.line();
            List trivias = firstSyntaxToken.trivias();
            if (!trivias.isEmpty()) {
                startLine = ((SyntaxTrivia)trivias.get(0)).startLine();
            }
            return IntStream.rangeClosed(startLine, endLine).boxed().collect(Collectors.toSet());
        }
        return new HashSet<Integer>();
    }
}

