/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5777")
public class TestAnnotationWithExpectedExceptionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        TestAnnotationWithExpectedExceptionCheck.findExpectedException(method.modifiers().annotations()).ifPresent(expected -> {
            AssertionCollector assertionCollector = new AssertionCollector();
            method.accept((TreeVisitor)assertionCollector);
            if (!assertionCollector.assertions.isEmpty()) {
                this.reportIssue((Tree)expected, "Move assertions into separate method or use assertThrows or try-catch instead.", assertionCollector.assertions, null);
            }
        });
    }

    private static Optional<ExpressionTree> findExpectedException(List<AnnotationTree> annotations) {
        for (AnnotationTree annotation : annotations) {
            if (!annotation.annotationType().symbolType().is("org.junit.Test")) continue;
            for (ExpressionTree argument : annotation.arguments()) {
                AssignmentExpressionTree assignment;
                IdentifierTree identifier;
                if (!argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) || !(identifier = (IdentifierTree)(assignment = (AssignmentExpressionTree)argument).variable()).name().equals("expected")) continue;
                return Optional.of(assignment);
            }
        }
        return Optional.empty();
    }

    private static class AssertionCollector
    extends BaseTreeVisitor {
        private final List<JavaFileScannerContext.Location> assertions = new ArrayList<JavaFileScannerContext.Location>();

        private AssertionCollector() {
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (UnitTestUtils.ASSERTIONS_METHOD_MATCHER.matches(methodInvocation)) {
                this.assertions.add(new JavaFileScannerContext.Location("Assertion in method with expected exception", (Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation)));
            }
        }
    }
}

