/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5790")
public class JunitNestedAnnotationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        IdentifierTree className = classTree.simpleName();
        if (className == null) {
            return;
        }
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (JunitNestedAnnotationCheck.isNestedClass(classSymbol) && JunitNestedAnnotationCheck.hasJUnit5TestMethods(classTree)) {
            boolean hasNestedAnnotation = UnitTestUtils.hasNestedAnnotation(classTree);
            if (classSymbol.isStatic() && hasNestedAnnotation) {
                this.reportIssue((Tree)className, "Remove @Nested from this static nested test class or convert it into an inner class");
            } else if (!classSymbol.isStatic() && !hasNestedAnnotation) {
                this.reportIssue((Tree)className, "Add @Nested to this inner test class");
            }
        }
    }

    private static boolean hasJUnit5TestMethods(ClassTree classTree) {
        return classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).anyMatch(UnitTestUtils::hasJUnit5TestAnnotation);
    }

    private static boolean isNestedClass(Symbol.TypeSymbol classSymbol) {
        return Optional.ofNullable(classSymbol.owner()).map(Symbol::isTypeSymbol).orElse(false);
    }
}

