/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3551")
public class SynchronizedOverrideCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make this method \"synchronized\" to match the parent class implementation.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        List overriddenSymbols = methodSymbol.overriddenSymbols();
        if (overriddenSymbols.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol overriddenSymbol = (Symbol.MethodSymbol)overriddenSymbols.get(0);
        if (JUtils.isSynchronizedMethod((Symbol.MethodSymbol)overriddenSymbol) && !JUtils.isSynchronizedMethod((Symbol.MethodSymbol)methodSymbol)) {
            List<Object> secondaries = Collections.emptyList();
            MethodTree overridenMethodTree = overriddenSymbol.declaration();
            if (overridenMethodTree != null) {
                secondaries = Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)overridenMethodTree.simpleName()));
            }
            this.reportIssue((Tree)methodTree.simpleName(), MESSAGE, secondaries, null);
        }
    }
}

