/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3358")
public class NestedTernaryOperatorsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        ConditionalExpressionTree ternary = (ConditionalExpressionTree)tree;
        Stream.of(ternary.condition(), ternary.trueExpression(), ternary.falseExpression()).forEach(expr -> expr.accept((TreeVisitor)new TernaryVisitor()));
    }

    private class TernaryVisitor
    extends BaseTreeVisitor {
        private TernaryVisitor() {
        }

        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            NestedTernaryOperatorsCheck.this.reportIssue((Tree)tree, "Extract this nested ternary operation into an independent statement.");
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

