/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven.helpers;

import org.apache.commons.lang.StringUtils;
import org.sonar.java.checks.xml.maven.helpers.PatternMatcher;
import org.sonar.java.checks.xml.maven.helpers.RangedVersionMatcher;
import org.sonar.java.checks.xml.maven.helpers.StringMatcher;

public class MavenDependencyMatcher {
    private static final StringMatcher ALWAYS_MATCHING_MATCHER = StringMatcher.any();
    private final StringMatcher groupIdMatcher;
    private final StringMatcher artifactIdMatcher;
    private final StringMatcher versionMatcher;

    public MavenDependencyMatcher(String dependencyName, String version) {
        String[] name = dependencyName.split(":");
        if (name.length != 2) {
            throw new IllegalArgumentException("Invalid dependency name. Should match '[groupId]:[artifactId]' use '*' as wildcard");
        }
        this.groupIdMatcher = MavenDependencyMatcher.getMatcherForPattern(name[0].trim());
        this.artifactIdMatcher = MavenDependencyMatcher.getMatcherForPattern(name[1].trim());
        this.versionMatcher = MavenDependencyMatcher.getMatcherForVersion(version);
    }

    private static StringMatcher getMatcherForPattern(String pattern) {
        return StringUtils.isBlank((String)pattern) || MavenDependencyMatcher.isWildCard(pattern) ? ALWAYS_MATCHING_MATCHER : new PatternMatcher(pattern);
    }

    private static boolean isWildCard(String pattern) {
        return "*".equals(pattern);
    }

    private static StringMatcher getMatcherForVersion(String version) {
        if (version.contains("-")) {
            String[] bounds = version.split("-");
            return new RangedVersionMatcher(bounds[0], bounds[1]);
        }
        return MavenDependencyMatcher.getMatcherForPattern(version);
    }

    public boolean matches(String groupId, String artifactId, String version) {
        return this.groupIdMatcher.test(groupId) && this.artifactIdMatcher.test(artifactId) && this.versionMatcher.test(version);
    }
}

