/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.checks.tests.AbstractOneExpectedExceptionRule;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5778")
public class OneExpectedRuntimeExceptionCheck
extends AbstractOneExpectedExceptionRule {
    private static final MethodMatchers MOCKITO_MOCK_METHOD_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"org.mockito.Mockito"}).names(new String[]{"mock"}).addParametersMatcher(new String[]{"java.lang.Class"}).addParametersMatcher(new String[]{"java.lang.Class", "java.lang.String"}).build();
    private static final MethodMatchers AUTHORIZED_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{UnitTestUtils.FAIL_METHOD_MATCHER, MOCKITO_MOCK_METHOD_MATCHERS});

    @Override
    void reportMultipleCallInTree(List<Type> expectedExceptions, Tree treeToVisit, Tree reportLocation, String placeToRefactor) {
        List checkedTypes = expectedExceptions.stream().filter(e -> !OneExpectedRuntimeExceptionCheck.isChecked(e)).collect(Collectors.toList());
        if (checkedTypes.isEmpty()) {
            return;
        }
        AbstractOneExpectedExceptionRule.MethodInvocationCollector visitor = new AbstractOneExpectedExceptionRule.MethodInvocationCollector(symbol -> !AUTHORIZED_METHODS.matches(symbol));
        treeToVisit.accept((TreeVisitor)visitor);
        List<Tree> invocationTree = visitor.invocationTree;
        if (invocationTree.size() > 1) {
            this.reportIssue(reportLocation, String.format("Refactor the %s to have only one invocation throwing an exception.", placeToRefactor), OneExpectedRuntimeExceptionCheck.secondaryLocations(invocationTree), null);
        }
    }
}

