/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5826")
public class JUnit45MethodAnnotationCheck
extends IssuableSubscriptionVisitor {
    private static final String JUNIT_SETUP = "setUp";
    private static final String JUNIT_TEARDOWN = "tearDown";
    private static final String ORG_JUNIT_AFTER = "org.junit.After";
    private static final String ORG_JUNIT_BEFORE = "org.junit.Before";
    private static final Map<String, String> JUNIT4_TO_JUNIT5 = ImmutableMap.builder().put((Object)"org.junit.Before", (Object)"org.junit.jupiter.api.BeforeEach").put((Object)"org.junit.BeforeClass", (Object)"org.junit.jupiter.api.BeforeAll").put((Object)"org.junit.After", (Object)"org.junit.jupiter.api.AfterEach").put((Object)"org.junit.AfterClass", (Object)"org.junit.jupiter.api.AfterAll").build();
    private static final Set<String> JUNIT4_ANNOTATIONS = JUNIT4_TO_JUNIT5.keySet();
    private static final Set<String> JUNIT5_ANNOTATIONS = new HashSet<String>(JUNIT4_TO_JUNIT5.values());

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        List<MethodTree> methods = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).collect(Collectors.toList());
        int jUnitVersion = JUnit45MethodAnnotationCheck.getJUnitVersion(methods);
        if (jUnitVersion > 0) {
            methods.forEach(methodTree -> this.checkJUnitMethod((MethodTree)methodTree, jUnitVersion));
        }
    }

    private static int getJUnitVersion(List<MethodTree> methods) {
        boolean containsJUnit4Tests = false;
        for (MethodTree methodTree : methods) {
            SymbolMetadata metadata = methodTree.symbol().metadata();
            containsJUnit4Tests |= metadata.isAnnotatedWith("org.junit.Test");
            if (!UnitTestUtils.hasJUnit5TestAnnotation(methodTree)) continue;
            return 5;
        }
        return containsJUnit4Tests ? 4 : -1;
    }

    private void checkJUnitMethod(MethodTree methodTree, int jUnitVersion) {
        if (JUnit45MethodAnnotationCheck.isSetupTearDownSignature(methodTree) || jUnitVersion == 5 && JUnit45MethodAnnotationCheck.isAnnotatedWith(methodTree, ORG_JUNIT_BEFORE, ORG_JUNIT_AFTER)) {
            this.checkSetupTearDownSignature(methodTree, jUnitVersion);
        }
    }

    private void checkSetupTearDownSignature(MethodTree methodTree, int jUnitVersion) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        if (Boolean.TRUE.equals(methodTree.isOverriding())) {
            return;
        }
        SymbolMetadata metadata = symbol.metadata();
        Optional<String> junit4Annotation = JUNIT4_ANNOTATIONS.stream().filter(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0)).findFirst();
        boolean isAnnotatedWithJUnit4 = junit4Annotation.isPresent();
        boolean isAnnotatedWithJUnit5 = JUNIT5_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0));
        if (jUnitVersion == 5 && isAnnotatedWithJUnit4 && !isAnnotatedWithJUnit5) {
            String jUnit4Annotation = junit4Annotation.get();
            this.reportIssue((Tree)methodTree.simpleName(), String.format("Annotate this method with JUnit5 '@%s' instead of JUnit4 '@%s'.", JUNIT4_TO_JUNIT5.get(jUnit4Annotation), jUnit4Annotation.substring(jUnit4Annotation.lastIndexOf(46) + 1)));
        } else if (!isAnnotatedWithJUnit4 && !isAnnotatedWithJUnit5) {
            this.reportIssue((Tree)methodTree.simpleName(), String.format("Annotate this method with JUnit%d '@%s' or rename it to avoid confusion.", jUnitVersion, JUnit45MethodAnnotationCheck.expectedAnnotation(symbol, jUnitVersion)));
        }
    }

    private static boolean isAnnotatedWith(MethodTree methodTree, String ... annotations) {
        SymbolMetadata methodMetadata = methodTree.symbol().metadata();
        return Arrays.stream(annotations).anyMatch(arg_0 -> ((SymbolMetadata)methodMetadata).isAnnotatedWith(arg_0));
    }

    private static boolean isSetupTearDownSignature(MethodTree methodTree) {
        String name = methodTree.simpleName().name();
        return (JUNIT_SETUP.equals(name) || JUNIT_TEARDOWN.equals(name)) && methodTree.parameters().isEmpty() && !methodTree.symbol().isPrivate();
    }

    private static String expectedAnnotation(Symbol.MethodSymbol symbol, int jUnitVersion) {
        String expected = JUNIT_SETUP.equals(symbol.name()) ? ORG_JUNIT_BEFORE : ORG_JUNIT_AFTER;
        return jUnitVersion == 4 ? expected : JUNIT4_TO_JUNIT5.get(expected);
    }
}

