/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractJUnit5NotCompliantModifierChecker
extends IssuableSubscriptionVisitor {
    protected abstract boolean isNotCompliantModifier(Modifier var1, boolean var2);

    protected abstract void raiseIssueOnNotCompliantReturnType(MethodTree var1);

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        List testMethods = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(UnitTestUtils::hasJUnit5TestAnnotation).collect(Collectors.toList());
        for (MethodTree testMethod : testMethods) {
            this.raiseIssueOnNotCompliantModifiers(testMethod.modifiers(), true);
            this.raiseIssueOnNotCompliantReturnType(testMethod);
        }
        if (!testMethods.isEmpty()) {
            this.raiseIssueOnNotCompliantModifiers(classTree.modifiers(), false);
        }
    }

    private void raiseIssueOnNotCompliantModifiers(ModifiersTree modifierTree, boolean isMethod) {
        modifierTree.modifiers().stream().filter(modifier -> this.isNotCompliantModifier(modifier.modifier(), isMethod)).findFirst().ifPresent(modifier -> this.reportIssue((Tree)modifier, "Remove this '" + modifier.keyword().text() + "' modifier."));
    }
}

