/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5301")
public class XxeActiveMQCheck
extends AbstractMethodDetection {
    private static final String CONSTRUCTOR = "<init>";
    private static final String MQ_CONNECTION_FACTORY_CLASS_NAME = "org.apache.activemq.ActiveMQConnectionFactory";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{MQ_CONNECTION_FACTORY_CLASS_NAME}).names(new String[]{CONSTRUCTOR}).withAnyParameters().build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        MethodTree enclosingMethod = ExpressionUtils.getEnclosingMethod((ExpressionTree)newClassTree);
        if (enclosingMethod == null) {
            return;
        }
        Optional assignedSymbol = ExpressionUtils.getAssignedSymbol((ExpressionTree)newClassTree);
        MethodBodyVisitor visitor = new MethodBodyVisitor(assignedSymbol.orElse(null));
        enclosingMethod.accept((TreeVisitor)visitor);
        if (!visitor.foundCallsToSecuringMethods()) {
            this.reportIssue((Tree)newClassTree, "Secure this \"ActiveMQConnectionFactory\" by whitelisting the trusted packages using the \"setTrustedPackages\" method and make sure the \"setTrustAllPackages\" is not set to true.");
        }
    }

    private static class MethodBodyVisitor
    extends BaseTreeVisitor {
        private static final MethodMatchers SET_TRUSTED_PACKAGES = MethodMatchers.create().ofSubTypes(new String[]{"org.apache.activemq.ActiveMQConnectionFactory"}).names(new String[]{"setTrustedPackages"}).addParametersMatcher(new String[]{"*"}).build();
        private static final MethodMatchers SET_TRUST_ALL_PACKAGES = MethodMatchers.create().ofSubTypes(new String[]{"org.apache.activemq.ActiveMQConnectionFactory"}).names(new String[]{"setTrustAllPackages"}).addParametersMatcher(new String[]{"boolean"}).build();
        private boolean hasTrustedPackages = false;
        private boolean hasTrustAllPackages = false;
        private boolean callArgumentsOfSetTrustedPackages = false;
        private Symbol variable;

        MethodBodyVisitor(@Nullable Symbol variable) {
            this.variable = variable;
        }

        private boolean foundCallsToSecuringMethods() {
            return this.hasTrustedPackages && !this.hasTrustAllPackages;
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (ExpressionUtils.isInvocationOnVariable((MethodInvocationTree)methodInvocation, (Symbol)this.variable, (boolean)true)) {
                Arguments arguments = methodInvocation.arguments();
                if (SET_TRUSTED_PACKAGES.matches(methodInvocation)) {
                    this.hasTrustedPackages |= !((ExpressionTree)arguments.get(0)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
                    this.callArgumentsOfSetTrustedPackages = true;
                } else if (SET_TRUST_ALL_PACKAGES.matches(methodInvocation)) {
                    this.hasTrustAllPackages |= Boolean.TRUE.equals(((ExpressionTree)arguments.get(0)).asConstant(Boolean.class).orElse(null));
                }
            }
            super.visitMethodInvocation(methodInvocation);
            this.callArgumentsOfSetTrustedPackages = false;
        }

        public void visitLiteral(LiteralTree tree) {
            if (this.callArgumentsOfSetTrustedPackages && tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && "*".equals(LiteralUtils.trimQuotes((String)tree.value()))) {
                this.hasTrustAllPackages = true;
            }
            super.visitLiteral(tree);
        }
    }
}

