/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4524")
public class SwitchDefaultLastCaseCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        SwitchDefaultLastCaseCheck.getDefaultLabelAtWrongPosition(switchStatementTree).ifPresent(defaultLabel -> this.reportIssue((Tree)defaultLabel, "Move this default to the end of the switch."));
    }

    private static Optional<CaseLabelTree> getDefaultLabelAtWrongPosition(SwitchStatementTree switchStatementTree) {
        for (int i = 0; i < switchStatementTree.cases().size(); ++i) {
            List labels = ((CaseGroupTree)switchStatementTree.cases().get(i)).labels();
            for (int j = 0; j < labels.size(); ++j) {
                CaseLabelTree label = (CaseLabelTree)labels.get(j);
                boolean defaultExists = SwitchDefaultLastCaseCheck.isDefault(label);
                if (defaultExists && (j != labels.size() - 1 || i == switchStatementTree.cases().size() - 1)) {
                    return Optional.empty();
                }
                if (!defaultExists) continue;
                return Optional.of(label);
            }
        }
        return Optional.empty();
    }

    private static boolean isDefault(CaseLabelTree caseLabelTree) {
        return JavaKeyword.DEFAULT.getValue().equals(caseLabelTree.caseOrDefaultKeyword().text());
    }
}

