/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2629")
public class LazyArgEvaluationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String STRING = "java.lang.String";
    private static final String OBJECT_ARR = "java.lang.Object[]";
    private static final MethodMatchers PRECONDITIONS = MethodMatchers.create().ofTypes(new String[]{"com.google.common.base.Preconditions"}).names(new String[]{"checkState"}).withAnyParameters().build();
    private static final MethodMatchers LAZY_ARG_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{PRECONDITIONS, SLF4J.access$100(), JUL.access$200(), LOG4J.access$300()});
    private static final MethodMatchers LOG_LEVEL_TESTS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{SLF4J.access$400(), JUL.access$500(), LOG4J.access$600()});
    private JavaFileScannerContext context;
    private Deque<Tree> treeStack = new ArrayDeque<Tree>();

    private static String[] testMethodNames(String[] lowerCaseNames) {
        return (String[])Stream.of(lowerCaseNames).map(name -> "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "Enabled").toArray(String[]::new);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() == null) {
            return;
        }
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (LAZY_ARG_METHODS.matches(tree) && !this.insideCatchStatement() && !this.insideLevelTest() && !LazyArgEvaluationCheck.argsUsingSuppliers(tree)) {
            this.onMethodInvocationFound(tree);
        }
    }

    private static boolean argsUsingSuppliers(MethodInvocationTree tree) {
        return tree.arguments().stream().map(ExpressionTree::symbolType).anyMatch(LOG4J.SUPPLIER);
    }

    public void visitIfStatement(IfStatementTree ifTree) {
        LevelTestVisitor levelTestVisitor = new LevelTestVisitor();
        ifTree.condition().accept((TreeVisitor)levelTestVisitor);
        if (levelTestVisitor.match) {
            this.stackAndContinue(ifTree, x$0 -> super.visitIfStatement(x$0));
        } else {
            super.visitIfStatement(ifTree);
        }
    }

    public void visitCatch(CatchTree tree) {
        this.stackAndContinue(tree, x$0 -> super.visitCatch(x$0));
    }

    public void visitMethod(MethodTree tree) {
        this.stackAndContinue(tree, x$0 -> super.visitMethod(x$0));
    }

    private boolean insideLevelTest() {
        return this.treeStack.stream().anyMatch(t -> t.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}));
    }

    private boolean insideCatchStatement() {
        return this.treeStack.peek() != null && this.treeStack.peek().is(new Tree.Kind[]{Tree.Kind.CATCH});
    }

    private <T extends Tree> void stackAndContinue(T tree, Consumer<T> visit) {
        this.treeStack.push(tree);
        visit.accept(tree);
        this.treeStack.pop();
    }

    private void onMethodInvocationFound(MethodInvocationTree mit) {
        List flow = LazyArgEvaluationCheck.findStringArg(mit).flatMap(LazyArgEvaluationCheck::checkArgument).collect(Collectors.toList());
        if (!flow.isEmpty()) {
            this.context.reportIssue((JavaCheck)this, ((JavaFileScannerContext.Location)flow.get((int)0)).syntaxNode, ((JavaFileScannerContext.Location)flow.get((int)0)).msg, flow.subList(1, flow.size()), null);
        }
    }

    private static Stream<JavaFileScannerContext.Location> checkArgument(ExpressionTree stringArgument) {
        StringExpressionVisitor visitor = new StringExpressionVisitor();
        stringArgument.accept((TreeVisitor)visitor);
        if (visitor.shouldReport) {
            return Stream.of(LazyArgEvaluationCheck.locationFromArg(stringArgument, visitor));
        }
        return Stream.empty();
    }

    private static JavaFileScannerContext.Location locationFromArg(ExpressionTree stringArgument, StringExpressionVisitor visitor) {
        StringBuilder msg = new StringBuilder();
        if (visitor.hasMethodInvocation) {
            msg.append("Invoke method(s) only conditionally. ");
        }
        if (visitor.hasBinaryExpression) {
            msg.append("Use the built-in formatting to construct this argument.");
        }
        return new JavaFileScannerContext.Location(msg.toString(), (Tree)stringArgument);
    }

    private static Stream<ExpressionTree> findStringArg(MethodInvocationTree mit) {
        return mit.arguments().stream().filter(arg -> arg.symbolType().is(STRING));
    }

    static /* synthetic */ String[] access$000(String[] x0) {
        return LazyArgEvaluationCheck.testMethodNames(x0);
    }

    private static class LevelTestVisitor
    extends BaseTreeVisitor {
        boolean match = false;

        private LevelTestVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (LOG_LEVEL_TESTS.matches(mit)) {
                this.match = true;
            }
        }
    }

    private static class StringExpressionVisitor
    extends BaseTreeVisitor {
        private boolean hasBinaryExpression;
        private boolean shouldReport;
        private boolean hasMethodInvocation;

        private StringExpressionVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (!StringExpressionVisitor.isGetter(tree) && !StringExpressionVisitor.isAnnotationMethod(tree)) {
                this.shouldReport = true;
                this.hasMethodInvocation = true;
            }
        }

        private static boolean isGetter(MethodInvocationTree tree) {
            String methodName = tree.symbol().name();
            return methodName != null && (methodName.startsWith("get") || methodName.startsWith("is"));
        }

        private static boolean isAnnotationMethod(MethodInvocationTree tree) {
            Symbol owner = tree.symbol().owner();
            return owner.isTypeSymbol() && JUtils.isAnnotation((Symbol.TypeSymbol)((Symbol.TypeSymbol)owner));
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (this.hasBinaryExpression) {
                this.shouldReport = true;
            }
        }

        public void visitNewClass(NewClassTree tree) {
            this.hasMethodInvocation = true;
            this.shouldReport = true;
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            this.hasBinaryExpression = true;
            if (!StringExpressionVisitor.isConstant(tree.rightOperand())) {
                tree.rightOperand().accept((TreeVisitor)this);
            }
            if (!StringExpressionVisitor.isConstant(tree.leftOperand())) {
                tree.leftOperand().accept((TreeVisitor)this);
            }
        }

        private static boolean isConstant(ExpressionTree operand) {
            switch (operand.kind()) {
                case BOOLEAN_LITERAL: 
                case CHAR_LITERAL: 
                case DOUBLE_LITERAL: 
                case FLOAT_LITERAL: 
                case INT_LITERAL: 
                case LONG_LITERAL: 
                case STRING_LITERAL: 
                case NULL_LITERAL: {
                    return true;
                }
                case IDENTIFIER: {
                    return StringExpressionVisitor.isConstant(((IdentifierTree)operand).symbol());
                }
                case MEMBER_SELECT: {
                    MemberSelectExpressionTree mset = (MemberSelectExpressionTree)operand;
                    return StringExpressionVisitor.isConstant(mset.identifier().symbol());
                }
            }
            return false;
        }

        private static boolean isConstant(Symbol symbol) {
            return symbol.isStatic() && symbol.isFinal();
        }
    }

    private static class LOG4J {
        private static final String[] METHOD_NAMES = new String[]{"debug", "error", "fatal", "info", "trace", "warn"};
        private static final String LEVEL = "org.apache.logging.log4j.Level";
        private static final String LOGGER = "org.apache.logging.log4j.Logger";
        private static final String MARKER = "org.apache.logging.log4j.Marker";
        private static final Predicate<Type> SUPPLIER = type -> type.isSubtypeOf("org.apache.logging.log4j.util.Supplier") || type.isSubtypeOf("org.apache.logging.log4j.util.MessageSupplier");
        private static final MethodMatchers LOG = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.apache.logging.log4j.Logger"}).names(METHOD_NAMES).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.apache.logging.log4j.Logger"}).names(new String[]{"log"}).withAnyParameters().build()});
        private static final MethodMatchers TEST = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.apache.logging.log4j.Logger"}).names(LazyArgEvaluationCheck.access$000(METHOD_NAMES)).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.apache.logging.log4j.Logger"}).names(new String[]{"isEnabled"}).addParametersMatcher(new String[]{"org.apache.logging.log4j.Level"}).addParametersMatcher(new String[]{"org.apache.logging.log4j.Level", "org.apache.logging.log4j.Marker"}).build()});

        private LOG4J() {
        }

        static /* synthetic */ MethodMatchers access$300() {
            return LOG;
        }

        static /* synthetic */ MethodMatchers access$600() {
            return TEST;
        }
    }

    private static class JUL {
        private static final String[] METHOD_NAMES = new String[]{"severe", "warning", "info", "config", "fine", "finer", "finest"};
        private static final String LOGGER = "java.util.logging.Logger";
        private static final MethodMatchers LOG = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(METHOD_NAMES).addParametersMatcher(new String[]{"java.lang.String"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"log"}).addParametersMatcher(new String[]{"java.util.logging.Level", "java.lang.String"}).build()});
        private static final MethodMatchers TEST = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"isLoggable"}).addParametersMatcher(new String[]{"java.util.logging.Level"}).build();

        private JUL() {
        }

        static /* synthetic */ MethodMatchers access$200() {
            return LOG;
        }

        static /* synthetic */ MethodMatchers access$500() {
            return TEST;
        }
    }

    private static class SLF4J {
        private static final String[] METHOD_NAMES = new String[]{"trace", "debug", "info", "warn", "error"};
        private static final String LOGGER = "org.slf4j.Logger";
        private static final String MARKER = "org.slf4j.Marker";
        private static final MethodMatchers LOG = MethodMatchers.create().ofSubTypes(new String[]{"org.slf4j.Logger"}).names(METHOD_NAMES).addParametersMatcher(new String[]{"java.lang.String"}).addParametersMatcher(new String[]{"java.lang.String", "*"}).addParametersMatcher(new String[]{"java.lang.String", "*", "*"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.Object[]"}).addParametersMatcher(new String[]{"org.slf4j.Marker", "java.lang.String"}).addParametersMatcher(new String[]{"org.slf4j.Marker", "java.lang.String", "*"}).addParametersMatcher(new String[]{"org.slf4j.Marker", "java.lang.String", "*", "*"}).addParametersMatcher(new String[]{"org.slf4j.Marker", "java.lang.String", "java.lang.Object[]"}).build();
        private static final MethodMatchers TEST = MethodMatchers.create().ofSubTypes(new String[]{"org.slf4j.Logger"}).names(LazyArgEvaluationCheck.access$000(METHOD_NAMES)).addWithoutParametersMatcher().build();

        private SLF4J() {
        }

        static /* synthetic */ MethodMatchers access$100() {
            return LOG;
        }

        static /* synthetic */ MethodMatchers access$400() {
            return TEST;
        }
    }
}

