/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2479")
public class ControlCharacterInLiteralCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE_FORMAT = "Remove the non-escaped \\u%04X character from this literal.";
    private static final String CONTROL_CHARACTERS_WITHOUT_TAB = "\u0000-\b\u000b-\f\u000e-\u001f\u007f\u0085\u00a0\u1680\u180e\u2000-\u200d\u2028\u2029\u202f\u205f\u2060\u3000\ufeff";
    private static final Pattern NON_TEXT_BLOC_CONTROL_CHARACTERS = Pattern.compile("[\t\u0000-\b\u000b-\f\u000e-\u001f\u007f\u0085\u00a0\u1680\u180e\u2000-\u200d\u2028\u2029\u202f\u205f\u2060\u3000\ufeff]");
    private static final Pattern TEXT_BLOC_CONTROL_CHARACTERS = Pattern.compile("[\u0000-\b\u000b-\f\u000e-\u001f\u007f\u0085\u00a0\u1680\u180e\u2000-\u200d\u2028\u2029\u202f\u205f\u2060\u3000\ufeff]");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.STRING_LITERAL, Tree.Kind.CHAR_LITERAL);
    }

    public void visitNode(Tree tree) {
        LiteralTree literal = (LiteralTree)tree;
        String literalValue = LiteralUtils.trimQuotes((String)literal.value());
        Pattern controlCharacterPattern = LiteralUtils.isTextBlock((String)literal.value()) ? TEXT_BLOC_CONTROL_CHARACTERS : NON_TEXT_BLOC_CONTROL_CHARACTERS;
        Matcher matcher = controlCharacterPattern.matcher(literalValue);
        if (matcher.find()) {
            this.reportIssue((Tree)literal, String.format(MESSAGE_FORMAT, literalValue.codePointAt(matcher.start())));
        }
    }
}

