/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2638")
public class ChangeMethodContractCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        Symbol.MethodSymbol overridee = methodSymbol.overriddenSymbol();
        if (overridee != null && overridee.isMethodSymbol()) {
            this.checkContractChange(methodTree, overridee);
        }
    }

    private void checkContractChange(MethodTree methodTree, Symbol.MethodSymbol overridee) {
        if (MethodTreeUtils.isEqualsMethod(methodTree)) {
            NullableAnnotationUtils.nonNullAnnotation((ModifiersTree)((VariableTree)methodTree.parameters().get(0)).modifiers()).ifPresent(annotation -> this.reportIssue((Tree)annotation, "Equals method should accept null parameters and return false."));
            return;
        }
        for (int i = 0; i < methodTree.parameters().size(); ++i) {
            VariableTree parameter = (VariableTree)methodTree.parameters().get(i);
            this.checkParameter(parameter, JUtils.parameterAnnotations((Symbol.MethodSymbol)overridee, (int)i));
        }
        if (NullableAnnotationUtils.isAnnotatedNonNull((Symbol)overridee)) {
            NullableAnnotationUtils.nullableAnnotation((ModifiersTree)methodTree.modifiers()).ifPresent(annotation -> this.reportIssue((Tree)annotation, "Remove this \"" + annotation.symbolType().name() + "\" annotation to honor the overridden method's contract."));
        }
    }

    private void checkParameter(VariableTree parameter, SymbolMetadata overrideeParamMetadata) {
        if (NullableAnnotationUtils.isAnnotatedNullable((SymbolMetadata)overrideeParamMetadata)) {
            NullableAnnotationUtils.nonNullAnnotation((ModifiersTree)parameter.modifiers()).ifPresent(annotation -> this.reportIssue((Tree)annotation, "Remove this \"" + annotation.annotationType().symbolType().name() + "\" annotation to honor the overridden method's contract."));
        }
    }
}

