/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.BackReferenceTree;
import org.sonar.java.regex.ast.CapturingGroupTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5860")
public class UnusedGroupNamesCheck
extends AbstractRegexCheck {
    private static final String ISSUE_NO_GROUP_WITH_SUCH_NAME = "There is no group named '%s' in the regular expression.";
    private static final String ISSUE_USE_NAME_INSTEAD_OF_NUMBER = "Directly use '%s' instead of its group number.";
    private static final String ISSUE_USE_GROUPS_OR_REMOVE = "Use the named groups of this regex or remove the names.";
    private static final String JAVA_UTIL_REGEX_PATTERN = "java.util.regex.Pattern";
    private static final String JAVA_UTIL_REGEX_MATCHER = "java.util.regex.Matcher";
    private static final MethodMatchers PATTERN_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Pattern"}).names(new String[]{"matcher"}).addParametersMatcher(new String[]{"java.lang.CharSequence"}).build();
    private static final MethodMatchers MATCHER_GROUP = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Matcher"}).names(new String[]{"group"}).addParametersMatcher(new String[]{"java.lang.String"}).addParametersMatcher(new String[]{"int"}).build();
    private final Map<Symbol.VariableSymbol, KnownGroupsCollector> knownPatternsWithGroups = new HashMap<Symbol.VariableSymbol, KnownGroupsCollector>();
    private final Map<Symbol.VariableSymbol, Symbol.VariableSymbol> matcherToPattern = new HashMap<Symbol.VariableSymbol, Symbol.VariableSymbol>();
    private final Set<Symbol.VariableSymbol> returnedVariables = new HashSet<Symbol.VariableSymbol>();
    private final Set<RegexTree> usedGroupsRegexes = new HashSet<RegexTree>();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{REGEX_METHODS, PATTERN_MATCHER, MATCHER_GROUP});
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> nodes = new ArrayList<Tree.Kind>(super.nodesToVisit());
        nodes.add(Tree.Kind.COMPILATION_UNIT);
        nodes.add(Tree.Kind.RETURN_STATEMENT);
        return nodes;
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.collectReturnedVariables(((ReturnStatementTree)tree).expression());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.checkNotUsingAnyNamedGroup();
            this.knownPatternsWithGroups.clear();
            this.matcherToPattern.clear();
            this.usedGroupsRegexes.clear();
            this.returnedVariables.clear();
        }
    }

    private void collectReturnedVariables(@Nullable ExpressionTree returnedExpression) {
        if (returnedExpression == null || !returnedExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return;
        }
        Symbol returnedSymbol = ((IdentifierTree)returnedExpression).symbol();
        if (!UnusedGroupNamesCheck.isPrivateEffectivelyFinalVariable(returnedSymbol)) {
            return;
        }
        Type returnedType = returnedSymbol.type();
        if (returnedType.is(JAVA_UTIL_REGEX_MATCHER) || returnedType.is(JAVA_UTIL_REGEX_PATTERN)) {
            this.returnedVariables.add((Symbol.VariableSymbol)returnedSymbol);
        }
    }

    private static boolean isPrivateEffectivelyFinalVariable(Symbol symbol) {
        return !(!symbol.isPrivate() && !symbol.owner().isMethodSymbol() || !symbol.isVariableSymbol() || !symbol.isFinal() && !JUtils.isEffectivelyFinal((Symbol.VariableSymbol)((Symbol.VariableSymbol)symbol)));
    }

    private void checkNotUsingAnyNamedGroup() {
        this.knownPatternsWithGroups.entrySet().stream().filter(e -> this.isNotReturned((Symbol.VariableSymbol)e.getKey())).map(Map.Entry::getValue).filter(this::isNotCallingGroups).filter(UnusedGroupNamesCheck::isNotUsingBackReferences).forEach(knownGroups -> {
            ArrayList namedGroups = new ArrayList(((KnownGroupsCollector)knownGroups).groupsByName.values());
            List<RegexCheck.RegexIssueLocation> secondaries = namedGroups.stream().map(group -> UnusedGroupNamesCheck.toLocation(group, "Named group '%s'", g -> g.getName().get())).collect(Collectors.toList());
            this.reportIssue((RegexSyntaxElement)namedGroups.get(0), ISSUE_USE_GROUPS_OR_REMOVE, null, secondaries);
        });
    }

    private boolean isNotReturned(Symbol.VariableSymbol regex) {
        if (this.returnedVariables.contains(regex)) {
            return false;
        }
        return this.matcherToPattern.entrySet().stream().noneMatch(e -> this.returnedVariables.contains(e.getKey()) && ((Symbol.VariableSymbol)e.getValue()).equals(regex));
    }

    private boolean isNotCallingGroups(KnownGroupsCollector knownGroups) {
        return !this.usedGroupsRegexes.contains(knownGroups.target);
    }

    private static boolean isNotUsingBackReferences(KnownGroupsCollector knownGroups) {
        return !knownGroups.usesBackReferences;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        if (PATTERN_MATCHER.matches(mit)) {
            this.collectPattern(mit);
        } else if (MATCHER_GROUP.matches(mit)) {
            this.checkGroupUsage(mit);
        } else if ("compile".equals(methodName)) {
            super.onMethodInvocationFound(mit);
        }
    }

    private void collectPattern(MethodInvocationTree mit) {
        for (Symbol.VariableSymbol knownPattern : this.knownPatternsWithGroups.keySet()) {
            if (!ExpressionUtils.isInvocationOnVariable((MethodInvocationTree)mit, (Symbol)knownPattern, (boolean)false)) continue;
            Optional<Symbol.VariableSymbol> matcher = UnusedGroupNamesCheck.getAssignedPrivateVariable(mit);
            if (matcher.isPresent()) {
                this.matcherToPattern.put(matcher.get(), knownPattern);
                break;
            }
            this.knownPatternsWithGroups.remove(knownPattern);
            break;
        }
    }

    private void checkGroupUsage(MethodInvocationTree mit) {
        this.matcherToPattern.forEach((knownMatcher, knownPattern) -> {
            if (!ExpressionUtils.isInvocationOnVariable((MethodInvocationTree)mit, (Symbol)knownMatcher, (boolean)false)) {
                return;
            }
            KnownGroupsCollector knownGroups = this.knownPatternsWithGroups.get(knownPattern);
            this.usedGroupsRegexes.add(knownGroups.target);
            ExpressionTree arg0 = (ExpressionTree)mit.arguments().get(0);
            Type arg0Type = arg0.symbolType();
            if (arg0Type.is("int")) {
                this.checkUsingNumberInsteadOfName(knownGroups, arg0);
            } else {
                this.checkNoSuchName(knownGroups, arg0);
            }
        });
    }

    private void checkUsingNumberInsteadOfName(KnownGroupsCollector knownGroups, ExpressionTree arg0) {
        Optional groupNumber = arg0.asConstant(Integer.class);
        if (!groupNumber.isPresent()) {
            return;
        }
        Integer groupNumberValue = (Integer)groupNumber.get();
        CapturingGroupTree capturingGroupTree = (CapturingGroupTree)knownGroups.groupsByNumber.get(groupNumberValue);
        if (capturingGroupTree == null) {
            return;
        }
        String message = String.format(ISSUE_USE_NAME_INSTEAD_OF_NUMBER, capturingGroupTree.getName().orElse("?"));
        RegexCheck.RegexIssueLocation secondary = UnusedGroupNamesCheck.toLocation(capturingGroupTree, "Group %d", g -> groupNumberValue);
        this.reportIssue((Tree)arg0, message, null, Collections.singletonList(secondary));
    }

    private void checkNoSuchName(KnownGroupsCollector knownGroups, ExpressionTree arg0) {
        Optional groupName = arg0.asConstant(String.class);
        if (!groupName.isPresent()) {
            return;
        }
        String groupNameValue = (String)groupName.get();
        if (!knownGroups.groupsByName.keySet().contains(groupNameValue)) {
            String message = String.format(ISSUE_NO_GROUP_WITH_SUCH_NAME, groupNameValue);
            List<RegexCheck.RegexIssueLocation> secondaries = knownGroups.groupsByName.values().stream().map(group -> UnusedGroupNamesCheck.toLocation(group, "Named group '%s'", g -> g.getName().get())).collect(Collectors.toList());
            this.reportIssue((Tree)arg0, message, null, secondaries);
        }
    }

    private static RegexCheck.RegexIssueLocation toLocation(CapturingGroupTree group, String message, Function<CapturingGroupTree, Object> arg) {
        return new RegexCheck.RegexIssueLocation((RegexSyntaxElement)group, String.format(message, arg.apply(group)));
    }

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, MethodInvocationTree mit) {
        UnusedGroupNamesCheck.getAssignedPrivateVariable(mit).ifPresent(variableSymbol -> UnusedGroupNamesCheck.collectGroups(regexForLiterals).ifPresent(knownGroups -> this.knownPatternsWithGroups.put((Symbol.VariableSymbol)variableSymbol, (KnownGroupsCollector)((Object)((Object)knownGroups)))));
    }

    private static Optional<Symbol.VariableSymbol> getAssignedPrivateVariable(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        Symbol symbol = null;
        if (parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            symbol = ((VariableTree)parent).symbol();
        } else if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            MemberSelectExpressionTree mset;
            ExpressionTree variable = ((AssignmentExpressionTree)parent).variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                symbol = ((IdentifierTree)variable).symbol();
            } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ExpressionUtils.isSelectOnThisOrSuper((MemberSelectExpressionTree)(mset = (MemberSelectExpressionTree)variable))) {
                symbol = mset.identifier().symbol();
            }
        }
        if (symbol == null || !UnusedGroupNamesCheck.isPrivateEffectivelyFinalVariable(symbol)) {
            return Optional.empty();
        }
        return Optional.of((Symbol.VariableSymbol)symbol);
    }

    private static Optional<KnownGroupsCollector> collectGroups(RegexParseResult regex) {
        KnownGroupsCollector visitor = new KnownGroupsCollector();
        visitor.visit(regex);
        return visitor.groupsByName.isEmpty() ? Optional.empty() : Optional.of(visitor);
    }

    private static class KnownGroupsCollector
    extends RegexBaseVisitor {
        private RegexTree target;
        private Map<String, CapturingGroupTree> groupsByName = new HashMap<String, CapturingGroupTree>();
        private Map<Integer, CapturingGroupTree> groupsByNumber = new HashMap<Integer, CapturingGroupTree>();
        private boolean usesBackReferences = false;

        private KnownGroupsCollector() {
        }

        protected void before(RegexParseResult regexParseResult) {
            this.target = regexParseResult.getResult();
        }

        public void visitCapturingGroup(CapturingGroupTree tree) {
            tree.getName().ifPresent(name -> {
                this.groupsByName.put((String)name, tree);
                this.groupsByNumber.put(tree.getGroupNumber(), tree);
            });
            super.visitCapturingGroup(tree);
        }

        public void visitBackReference(BackReferenceTree tree) {
            this.usesBackReferences = true;
            super.visitBackReference(tree);
        }
    }
}

