/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.spring;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="S3438")
public class SingleConnectionFactoryCheck
extends SimpleXPathBasedCheck {
    private XPathExpression singleConnectionFactoryBeansExpression = this.getXPathExpression("beans/bean[@class='org.springframework.jms.connection.SingleConnectionFactory']");
    private XPathExpression reconnectOnExceptionPropertyValueExpression = this.getXPathExpression("property[@name='reconnectOnException' and value='true']");

    public void scanFile(XmlFile file) {
        this.evaluateAsList(this.singleConnectionFactoryBeansExpression, file.getNamespaceUnawareDocument()).forEach(bean -> {
            if (!SingleConnectionFactoryCheck.hasPropertyAsAttribute(bean) && !this.hasPropertyAsChild((Node)bean)) {
                this.reportIssue((Node)bean, "Add a \"reconnectOnException\" property, set to \"true\"");
            }
        });
    }

    private static boolean hasPropertyAsAttribute(Node bean) {
        Node attribute = XmlFile.nodeAttribute((Node)bean, (String)"p:reconnectOnException");
        return attribute != null && "true".equals(attribute.getNodeValue());
    }

    private boolean hasPropertyAsChild(Node bean) {
        NodeList nodeList = this.evaluate(this.reconnectOnExceptionPropertyValueExpression, bean);
        return nodeList != null && nodeList.getLength() != 0;
    }
}

