/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4426")
public class CryptographicKeySizeCheck
extends AbstractMethodDetection {
    private static final String KEY_PAIR_GENERATOR = "java.security.KeyPairGenerator";
    private static final String KEY_GENERATOR = "javax.crypto.KeyGenerator";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static final String STRING = "java.lang.String";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(KEY_GENERATOR).name(GET_INSTANCE_METHOD).addParameter(STRING), MethodMatcher.create().typeDefinition(KEY_PAIR_GENERATOR).name(GET_INSTANCE_METHOD).addParameter(STRING));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MethodTree methodTree = ExpressionUtils.getEnclosingMethod((ExpressionTree)mit);
        String getInstanceArg = ExpressionsHelper.getConstantValueAsString((ExpressionTree)mit.arguments().get(0)).value();
        if (methodTree != null && getInstanceArg != null) {
            MethodVisitor methodVisitor = new MethodVisitor(getInstanceArg);
            methodTree.accept((TreeVisitor)methodVisitor);
        }
    }

    private class MethodVisitor
    extends BaseTreeVisitor {
        private final String algorithm;
        private final Map<String, Integer> algorithmKeySizeMap = ImmutableMap.of((Object)"Blowfish", (Object)128, (Object)"RSA", (Object)2048);
        private final MethodMatcher keyGenInit = MethodMatcher.create().typeDefinition("javax.crypto.KeyGenerator").name("init").addParameter("int");
        private final MethodMatcher keyPairGenInitialize = MethodMatcher.create().typeDefinition("java.security.KeyPairGenerator").name("initialize").addParameter("int");

        public MethodVisitor(String getInstanceArg) {
            this.algorithm = getInstanceArg;
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            Integer keySize;
            Integer minKeySize;
            if ((this.keyGenInit.matches(mit) || this.keyPairGenInitialize.matches(mit)) && (minKeySize = this.algorithmKeySizeMap.get(this.algorithm)) != null && (keySize = LiteralUtils.intLiteralValue((ExpressionTree)((ExpressionTree)mit.arguments().get(0)))) != null && keySize < minKeySize) {
                CryptographicKeySizeCheck.this.reportIssue((Tree)mit, "Use a key length of at least " + minKeySize + " bits.");
            }
        }
    }
}

