/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="MethodCyclomaticComplexity")
@RspecKey(value="S1541")
public class MethodComplexityCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(key="Threshold", description="The maximum authorized complexity.", defaultValue="10")
    private int max = 10;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (MethodComplexityCheck.isExcluded(methodTree)) {
            return;
        }
        List complexity = this.context.getComplexityNodes((Tree)methodTree);
        int size = complexity.size();
        if (size > this.max) {
            ArrayList<JavaFileScannerContext.Location> flow = new ArrayList<JavaFileScannerContext.Location>();
            for (Tree element : complexity) {
                flow.add(new JavaFileScannerContext.Location("+1", element));
            }
            this.reportIssue((Tree)methodTree.simpleName(), "The Cyclomatic Complexity of this method \"" + methodTree.simpleName().name() + "\" is " + size + " which is greater than " + this.max + " authorized.", flow, size - this.max);
        }
    }

    private static boolean isExcluded(MethodTree methodTree) {
        String name = methodTree.simpleName().name();
        if ("equals".equals(name)) {
            return methodTree.parameters().size() == 1;
        }
        if ("hashCode".equals(name)) {
            return methodTree.parameters().isEmpty();
        }
        return false;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

