/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.lex;

import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.sonar.plugins.html.lex.PageLexer;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.NodeType;
import org.sonar.plugins.html.node.TagNode;

public class VueLexer
extends PageLexer {
    private static final Object TEMPLATE_LEVEL = new Object();
    private static final String TEMPLATE = "template";

    @Override
    public List<Node> parse(Reader reader) {
        List<Node> nodes = super.parse(reader);
        boolean firstTemplateTag = true;
        LinkedList<Node> templateNodes = new LinkedList<Node>();
        LinkedList<Object> templateLevels = new LinkedList<Object>();
        for (Node node : nodes) {
            TagNode tagNode;
            if (node.getNodeType() == NodeType.TAG && (tagNode = (TagNode)node).equalsElementName(TEMPLATE)) {
                if (tagNode.isEndElement()) {
                    if (!templateLevels.isEmpty()) {
                        templateLevels.pop();
                        if (templateLevels.isEmpty()) {
                            break;
                        }
                    }
                } else if (!tagNode.hasEnd()) {
                    templateLevels.push(TEMPLATE_LEVEL);
                }
            }
            if (templateLevels.isEmpty()) continue;
            if (firstTemplateTag) {
                firstTemplateTag = false;
                continue;
            }
            templateNodes.add(node);
        }
        return templateNodes;
    }
}

