/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.structure;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="IllegalElementCheck")
public class IllegalElementCheck
extends AbstractPageCheck {
    private static final String DEFAULT_ELEMENTS = "";
    @RuleProperty(key="elements", description="Comma-separated list of names of forbidden elements", defaultValue="")
    public String elements = "";
    private String[] elementsArray;

    @Override
    public void startDocument(List<Node> nodes) {
        this.elementsArray = this.trimSplitCommaSeparatedList(this.elements);
    }

    @Override
    public void startElement(TagNode element) {
        for (String elementName : this.elementsArray) {
            if (!StringUtils.equalsIgnoreCase(element.getLocalName(), elementName) && !StringUtils.equalsIgnoreCase(element.getNodeName(), elementName)) continue;
            this.createViolation(element, "Remove this \"" + elementName + "\" element.");
        }
    }
}

