/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="PageWithoutTitleCheck")
public class PageWithoutTitleCheck
extends AbstractPageCheck {
    private int currentHtmlTagLine;
    private int currentHeadTagLine;
    private boolean foundTitleTag;
    private boolean isReported;

    @Override
    public void startDocument(List<Node> nodes) {
        this.currentHtmlTagLine = 0;
        this.currentHeadTagLine = 0;
    }

    @Override
    public void startElement(TagNode node) {
        if (PageWithoutTitleCheck.isHtmlTag(node)) {
            this.currentHtmlTagLine = node.getStartLinePosition();
            this.isReported = false;
            this.foundTitleTag = false;
        } else if (PageWithoutTitleCheck.isHeadTag(node)) {
            this.currentHeadTagLine = node.getStartLinePosition();
            this.isReported = false;
            this.foundTitleTag = false;
        } else if (this.currentHeadTagLine != 0 && PageWithoutTitleCheck.isTitleTag(node)) {
            this.foundTitleTag = true;
        }
    }

    @Override
    public void endElement(TagNode node) {
        int line = 0;
        if (PageWithoutTitleCheck.isHtmlTag(node)) {
            line = this.currentHtmlTagLine;
            this.currentHtmlTagLine = 0;
            this.currentHeadTagLine = 0;
        } else if (PageWithoutTitleCheck.isHeadTag(node)) {
            line = this.currentHeadTagLine;
            this.currentHeadTagLine = 0;
        }
        if (!this.foundTitleTag && line != 0 && !this.isReported) {
            this.createViolation(line, "Add a <title> tag to this page.");
            this.isReported = true;
        }
    }

    private static boolean isHtmlTag(TagNode node) {
        return "HTML".equalsIgnoreCase(node.getLocalName());
    }

    private static boolean isHeadTag(TagNode node) {
        return "HEAD".equalsIgnoreCase(node.getLocalName());
    }

    private static boolean isTitleTag(TagNode node) {
        return "TITLE".equalsIgnoreCase(node.getLocalName());
    }
}

