/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="MetaRefreshCheck")
public class MetaRefreshCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (MetaRefreshCheck.isMetaRefreshTag(node)) {
            this.createViolation(node, "Remove this meta refresh tag.");
        }
    }

    private static boolean isMetaRefreshTag(TagNode node) {
        String httpEquiv = node.getAttribute("HTTP-EQUIV");
        return "META".equalsIgnoreCase(node.getNodeName()) && httpEquiv != null && "REFRESH".equalsIgnoreCase(httpEquiv);
    }
}

