/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.node.TextNode;

@Rule(key="LinksIdenticalTextsDifferentTargetsCheck")
public class LinksIdenticalTextsDifferentTargetsCheck
extends AbstractPageCheck {
    private boolean inLink;
    private final Map<String, Link> links = new HashMap<String, Link>();
    private final StringBuilder text = new StringBuilder();
    private String target = "";
    private int line;

    @Override
    public void startDocument(List<Node> nodes) {
        this.links.clear();
        this.inLink = false;
    }

    @Override
    public void startElement(TagNode node) {
        if (LinksIdenticalTextsDifferentTargetsCheck.isA(node)) {
            this.inLink = true;
            this.text.delete(0, this.text.length());
            this.target = LinksIdenticalTextsDifferentTargetsCheck.getTarget(node);
            this.line = node.getStartLinePosition();
        }
    }

    private static String getTarget(TagNode node) {
        String target = node.getPropertyValue("href");
        return target == null ? "" : target;
    }

    @Override
    public void characters(TextNode textNode) {
        if (this.inLink) {
            this.text.append(textNode.getCode());
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (LinksIdenticalTextsDifferentTargetsCheck.isA(node)) {
            this.inLink = false;
            String upperText = this.text.toString().toUpperCase(Locale.ENGLISH).trim();
            if (!upperText.isEmpty()) {
                if (this.links.containsKey(upperText)) {
                    Link previousLink = this.links.get(upperText);
                    if (!this.target.equals(previousLink.getTarget())) {
                        this.createViolation(this.line, "Use distinct texts or point to the same target for this link and the one at line " + previousLink.getLine() + ".");
                    }
                } else {
                    this.links.put(upperText, new Link(this.line, this.target));
                }
            }
        }
    }

    private static boolean isA(TagNode node) {
        return "A".equalsIgnoreCase(node.getNodeName());
    }

    private static class Link {
        private final int line;
        private final String target;

        public Link(int line, String target) {
            this.line = line;
            this.target = target;
        }

        public int getLine() {
            return this.line;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

