/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.checks.sonar.FlashHelper;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="FlashUsesBothObjectAndEmbedCheck")
public class FlashUsesBothObjectAndEmbedCheck
extends AbstractPageCheck {
    private TagNode object;
    private boolean foundEmbed;

    @Override
    public void startDocument(List<Node> nodes) {
        this.object = null;
    }

    @Override
    public void startElement(TagNode node) {
        if (FlashUsesBothObjectAndEmbedCheck.isObject(node) && FlashHelper.isFlashObject(node)) {
            this.object = node;
            this.foundEmbed = false;
        } else if (FlashUsesBothObjectAndEmbedCheck.isEmbed(node) && FlashHelper.isFlashEmbed(node)) {
            this.foundEmbed = true;
            if (node.getParent() == null || !FlashUsesBothObjectAndEmbedCheck.isObject(node.getParent())) {
                this.createViolation(node, "Surround this <embed> tag by an <object> one.");
            }
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (FlashUsesBothObjectAndEmbedCheck.isObject(node)) {
            if (this.object != null && !this.foundEmbed) {
                this.createViolation(this.object, "Add an <embed> tag within this <object> one.");
            }
            this.object = null;
        }
    }

    private static boolean isObject(TagNode node) {
        return "OBJECT".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isEmbed(TagNode node) {
        return "EMBED".equalsIgnoreCase(node.getNodeName());
    }
}

