/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.Locale;
import javax.annotation.Nullable;
import org.sonar.plugins.html.node.TagNode;

public class FlashHelper {
    private FlashHelper() {
    }

    public static boolean isFlashObject(TagNode node) {
        return FlashHelper.hasFlashClassId(node.getAttribute("classid")) || FlashHelper.hasFlashType(node.getAttribute("type")) || FlashHelper.hasFlashExtension(node.getAttribute("data"));
    }

    private static boolean hasFlashClassId(@Nullable String classId) {
        return classId != null && "CLSID:D27CDB6E-AE6D-11CF-96B8-444553540000".equalsIgnoreCase(classId);
    }

    private static boolean hasFlashType(@Nullable String type) {
        return type != null && type.toUpperCase(Locale.ENGLISH).contains("X-SHOCKWAVE-FLASH");
    }

    private static boolean hasFlashExtension(@Nullable String file) {
        return file != null && file.toUpperCase(Locale.ENGLISH).endsWith(".SWF");
    }

    public static boolean isFlashEmbed(TagNode node) {
        return FlashHelper.hasFlashType(node.getAttribute("type")) || FlashHelper.hasFlashExtension(node.getAttribute("src"));
    }
}

