/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="BoldAndItalicTagsCheck")
public class BoldAndItalicTagsCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (BoldAndItalicTagsCheck.isBold(node)) {
            this.createViolation(node, "Replace this <" + node.getNodeName() + "> tag by <strong>.");
        } else if (BoldAndItalicTagsCheck.isItalicAndNotAriaHidden(node)) {
            this.createViolation(node, "Replace this <" + node.getNodeName() + "> tag by <em>.");
        }
    }

    private static boolean isBold(TagNode node) {
        return "B".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isItalicAndNotAriaHidden(TagNode node) {
        return "I".equalsIgnoreCase(node.getNodeName()) && !"true".equalsIgnoreCase(node.getPropertyValue("aria-hidden"));
    }
}

