/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.comments;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.CommentNode;
import org.sonarsource.analyzer.commons.recognizers.CodeRecognizer;
import org.sonarsource.analyzer.commons.recognizers.ContainsDetector;
import org.sonarsource.analyzer.commons.recognizers.Detector;
import org.sonarsource.analyzer.commons.recognizers.EndWithDetector;
import org.sonarsource.analyzer.commons.recognizers.LanguageFootprint;

@Rule(key="AvoidCommentedOutCodeCheck")
public class AvoidCommentedOutCodeCheck
extends AbstractPageCheck {
    private static final double THRESHOLD = 0.9;
    private static final LanguageFootprint LANGUAGE_FOOTPRINT = () -> new HashSet<Detector>(Arrays.asList(new ContainsDetector(0.7, "=\"", "='"), new ContainsDetector(0.8, "/>", "</", "<%", "%>"), new EndWithDetector(0.9, '>')));
    private static final CodeRecognizer CODE_RECOGNIZER = new CodeRecognizer(0.9, LANGUAGE_FOOTPRINT);

    @Override
    public void comment(CommentNode node) {
        String comment;
        if (node.isHtml() && !AvoidCommentedOutCodeCheck.isIgnored(comment = node.getCode()) && CODE_RECOGNIZER.isLineOfCode(comment)) {
            this.createViolation(node.getStartLinePosition(), "Remove this commented out code.");
        }
    }

    private static boolean isIgnored(String comment) {
        return StringUtils.containsIgnoreCase(comment, "copyright") || comment.startsWith("<!--[if") || comment.startsWith("<!--#");
    }
}

