/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.coding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="UnclosedTagCheck")
public class UnclosedTagCheck
extends AbstractPageCheck {
    private static final String DEFAULT_IGNORE_TAGS = "HTML,HEAD,BODY,P,DT,DD,LI,OPTION,THEAD,TH,TBODY,TR,TD,TFOOT,COLGROUP,IMG,INPUT,BR,HR,FRAME,AREA,BASE,BASEFONT,COL,ISINDEX,LINK,META,PARAM";
    @RuleProperty(key="ignoreTags", description="Ignore tags", defaultValue="HTML,HEAD,BODY,P,DT,DD,LI,OPTION,THEAD,TH,TBODY,TR,TD,TFOOT,COLGROUP,IMG,INPUT,BR,HR,FRAME,AREA,BASE,BASEFONT,COL,ISINDEX,LINK,META,PARAM")
    public String ignoreTags = "HTML,HEAD,BODY,P,DT,DD,LI,OPTION,THEAD,TH,TBODY,TR,TD,TFOOT,COLGROUP,IMG,INPUT,BR,HR,FRAME,AREA,BASE,BASEFONT,COL,ISINDEX,LINK,META,PARAM";
    private List<String> ignoreTagsList;
    private final List<TagNode> nodes = new ArrayList<TagNode>();
    private boolean skipFile = false;

    @Override
    public void startDocument(List<Node> nodes) {
        this.skipFile = false;
        if (this.isCshtmlFile()) {
            this.skipFile = true;
            return;
        }
        if (this.ignoreTagsList == null) {
            this.ignoreTagsList = Arrays.asList(StringUtils.split(this.ignoreTags, ','));
        }
        this.nodes.clear();
    }

    @Override
    public void endElement(TagNode element) {
        TagNode previousNode;
        if (this.skipFile) {
            return;
        }
        if (this.isNotIgnoreTag(element) && !this.nodes.isEmpty() && !(previousNode = this.nodes.remove(0)).getNodeName().equals(element.getNodeName())) {
            this.createViolation(previousNode, "The tag \"" + previousNode.getNodeName() + "\" has no corresponding closing tag.");
            ArrayList<TagNode> rollup = new ArrayList<TagNode>();
            for (TagNode node : this.nodes) {
                rollup.add(node);
                if (!node.getNodeName().equals(element.getNodeName())) continue;
                this.nodes.removeAll(rollup);
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNotIgnoreTag(TagNode node) {
        String nodeName = node.getNodeName();
        if (nodeName != null) {
            if (nodeName.startsWith("!")) return false;
        }
        if (!this.ignoreTagsList.stream().noneMatch(node::equalsElementName)) return false;
        return true;
    }

    @Override
    public void startElement(TagNode element) {
        if (this.skipFile) {
            return;
        }
        if (this.isNotIgnoreTag(element)) {
            this.nodes.add(0, element);
        }
    }

    @Override
    public void endDocument() {
        if (this.skipFile) {
            return;
        }
        for (TagNode node : this.nodes) {
            this.createViolation(node, "The tag \"" + node.getNodeName() + "\" has no corresponding closing tag.");
        }
    }

    private boolean isCshtmlFile() {
        return this.getHtmlSourceCode().inputFile().filename().endsWith(".cshtml");
    }
}

